/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAConnectionManager
implements ConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final long serialVersionUID = 4409118162975011014L;
    ConcurrentHashSet<ManagedConnection> connections = new ConcurrentHashSet();

    public ActiveMQRAConnectionManager() {
        logger.trace("constructor()");
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        logger.trace("allocateConnection({}, {})", (Object)mcf, (Object)cxRequestInfo);
        ManagedConnection mc = mcf.createManagedConnection(null, cxRequestInfo);
        Object c = mc.getConnection(null, cxRequestInfo);
        logger.trace("Allocated connection: {}, with managed connection: {}", c, (Object)mc);
        this.connections.add((Object)mc);
        return c;
    }

    public void stop() {
        for (ManagedConnection conn : this.connections) {
            try {
                conn.destroy();
            }
            catch (Throwable throwable) {}
        }
    }
}

