/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.logging;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;

public class ProtocolLogger_$logger
extends DelegatingBasicLogger
implements ProtocolLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProtocolLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ProtocolLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void errorClosingChannel(String message) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.errorClosingChannel$str(), (Object)message);
    }

    protected String errorClosingChannel$str() {
        return "WFLYPRT0001: Got error closing channel %s";
    }

    @Override
    public final void failedToCloseResource(Throwable cause, Object resource) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseResource$str(), resource);
    }

    protected String failedToCloseResource$str() {
        return "WFLYPRT0003: Failed to close resource %s";
    }

    @Override
    public final void failedToCloseServerSocket(Throwable cause, ServerSocket socket) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseServerSocket$str(), (Object)socket);
    }

    protected String failedToCloseServerSocket$str() {
        return "WFLYPRT0004: Failed to close the server socket %s";
    }

    @Override
    public final void noSuchRequest(int requestId, Channel channel) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.noSuchRequest$str(), (Object)requestId, (Object)channel);
    }

    protected String noSuchRequest$str() {
        return "WFLYPRT0018: No such request (%d) associated with channel %s";
    }

    protected String couldNotConnect$str() {
        return "WFLYPRT0023: Could not connect to %s. The connection timed out";
    }

    @Override
    public final ConnectException couldNotConnect(URI uri) {
        ConnectException result = new ConnectException(String.format(this.getLoggingLocale(), this.couldNotConnect$str(), uri));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String invalidByteToken$str() {
        return "WFLYPRT0030: Invalid byte token.  Expecting '%d' received '%d'";
    }

    @Override
    public final IOException invalidByteToken(int expected, byte actual) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidByteToken$str(), expected, actual));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSignature$str() {
        return "WFLYPRT0032: Invalid signature [%s]";
    }

    @Override
    public final IOException invalidSignature(String signature) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidSignature$str(), signature));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidType1$str() {
        return "WFLYPRT0034: Invalid type: %s";
    }

    @Override
    public final IOException invalidType(String type) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidType1$str(), type));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidType3$str() {
        return "WFLYPRT0035: Type is neither %s or %s: %s";
    }

    @Override
    public final IllegalArgumentException invalidType(String validType1, String validType2, byte providedType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidType3$str(), validType1, validType2, providedType));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationIdAlreadyExists$str() {
        return "WFLYPRT0051: Operation with id %d already registered";
    }

    @Override
    public final IllegalStateException operationIdAlreadyExists(int operationId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.operationIdAlreadyExists$str(), operationId));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullExecutor$str() {
        return "WFLYPRT0052: Null executor";
    }

    @Override
    public final IllegalArgumentException nullExecutor() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullExecutor$str(), new Object[0]));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToConnect$str() {
        return "WFLYPRT0053: Could not connect to %s. The connection failed";
    }

    @Override
    public final ConnectException failedToConnect(URI uri, Exception cause) {
        ConnectException result = new ConnectException(String.format(this.getLoggingLocale(), this.failedToConnect$str(), uri));
        result.initCause(cause);
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String channelClosed$str() {
        return "WFLYPRT0054: Channel closed";
    }

    @Override
    public final IOException channelClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.channelClosed$str(), new Object[0]));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchResponseHandler$str() {
        return "WFLYPRT0055: no handler registered for request type '%s'.";
    }

    @Override
    public final IOException noSuchResponseHandler(String type) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.noSuchResponseHandler$str(), type));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String responseHandlerNotFound$str() {
        return "WFLYPRT0056: No response handler for request %s";
    }

    @Override
    public final IOException responseHandlerNotFound(int id) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.responseHandlerNotFound$str(), id));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cancelledAsyncTask(String asyncTaskRunner, Thread thread) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.cancelledAsyncTask$str(), (Object)asyncTaskRunner, (Object)thread);
    }

    protected String cancelledAsyncTask$str() {
        return "WFLYPRT0057: %s cancelled task by interrupting thread %s";
    }

    @Override
    public final void cancelledAsyncTaskBeforeRun(String asyncTaskRunner) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.cancelledAsyncTaskBeforeRun$str(), (Object)asyncTaskRunner);
    }

    protected String cancelledAsyncTaskBeforeRun$str() {
        return "WFLYPRT0058: %s cancelled task before execution began";
    }

    @Override
    public final void deprecatedCLIConfiguration(String systemPropName) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.deprecatedCLIConfiguration$str(), (Object)systemPropName);
    }

    protected String deprecatedCLIConfiguration$str() {
        return "WFLYPRT0059: You are using a deprecated way to set the client bind address. Please use the \"--bind\" parameter on the CLI instead of the %s system property.";
    }

    protected String channelTimedOut$str() {
        return "WFLYPRT0060: Channel open request timed out";
    }

    @Override
    public final IOException channelTimedOut() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.channelTimedOut$str(), new Object[0]));
        ProtocolLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

