/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.batch;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.NAMED_CACHE)
public class BatchContainer {
    @Inject
    TransactionManager transactionManager;
    private final ThreadLocal<BatchDetails> batchDetailsTl = new ThreadLocal();

    public boolean startBatch() throws CacheException {
        return this.startBatch(false);
    }

    public boolean startBatch(boolean autoBatch) throws CacheException {
        BatchDetails bd = this.batchDetailsTl.get();
        if (bd == null) {
            bd = new BatchDetails();
        }
        try {
            if (this.transactionManager.getTransaction() == null && bd.tx == null) {
                this.transactionManager.begin();
                bd.nestedInvocationCount = 1;
                bd.suspendTxAfterInvocation = !autoBatch;
                bd.thread = Thread.currentThread();
                bd.tx = autoBatch ? this.transactionManager.getTransaction() : this.transactionManager.suspend();
                this.batchDetailsTl.set(bd);
                return true;
            }
            ++bd.nestedInvocationCount;
            this.batchDetailsTl.set(bd);
            return false;
        }
        catch (Exception e) {
            this.batchDetailsTl.remove();
            throw new CacheException("Unable to start batch", (Throwable)e);
        }
    }

    public void endBatch(boolean success) {
        this.endBatch(false, success);
    }

    public void endBatch(boolean autoBatch, boolean success) {
        BatchDetails bd = this.batchDetailsTl.get();
        if (bd == null) {
            return;
        }
        if (bd.tx == null) {
            this.batchDetailsTl.remove();
            return;
        }
        if (autoBatch) {
            --bd.nestedInvocationCount;
        }
        if (!autoBatch || bd.nestedInvocationCount == 0) {
            Transaction existingTx = null;
            try {
                existingTx = this.transactionManager.getTransaction();
                if (existingTx == null && !autoBatch || !bd.tx.equals(existingTx)) {
                    this.transactionManager.resume(bd.tx);
                }
                this.resolveTransaction(bd, success);
            }
            catch (Exception e) {
                throw new CacheException("Unable to end batch", (Throwable)e);
            }
            finally {
                this.batchDetailsTl.remove();
                try {
                    if (!autoBatch && existingTx != null) {
                        this.transactionManager.resume(existingTx);
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Failed resuming existing transaction " + existingTx, (Throwable)e);
                }
            }
        }
    }

    private void resolveTransaction(BatchDetails bd, boolean success) throws Exception {
        Thread currentThread = Thread.currentThread();
        if (bd.thread.equals(currentThread)) {
            if (success) {
                this.transactionManager.commit();
            } else {
                this.transactionManager.rollback();
            }
        } else if (success) {
            bd.tx.commit();
        } else {
            bd.tx.rollback();
        }
    }

    public Transaction getBatchTransaction() {
        Transaction tx = null;
        BatchDetails bd = this.batchDetailsTl.get();
        if (bd != null && (tx = bd.tx) == null) {
            this.batchDetailsTl.remove();
        }
        return tx;
    }

    public boolean isSuspendTxAfterInvocation() {
        BatchDetails bd = this.batchDetailsTl.get();
        return bd != null && bd.suspendTxAfterInvocation;
    }

    private static class BatchDetails {
        int nestedInvocationCount;
        boolean suspendTxAfterInvocation;
        Transaction tx;
        Thread thread;

        private BatchDetails() {
        }
    }
}

