/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClearCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.impl.ActivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.NotifyHelper;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceStatus;
import org.infinispan.persistence.util.EntryLoader;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public interface ClusteringDependentLogic {
    public void start();

    public LocalizedCacheTopology getCacheTopology();

    public CompletionStage<Void> commitEntry(CacheEntry var1, FlagAffectedCommand var2, InvocationContext var3, Flag var4, boolean var5);

    public Commit commitType(FlagAffectedCommand var1, InvocationContext var2, int var3, boolean var4);

    public CompletionStage<Map<Object, IncrementableEntryVersion>> createNewVersionsAndCheckForWriteSkews(VersionGenerator var1, TxInvocationContext var2, VersionedPrepareCommand var3);

    public Address getAddress();

    public <K, V> EntryLoader<K, V> getEntryLoader();

    public static class ScatteredLogic
    extends DistributionLogic {
        protected CompletableFuture<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            throw new UnsupportedOperationException();
        }
    }

    public static class DistributionLogic
    extends AbstractClusteringDependentLogic {
        @Inject
        StateTransferLock stateTransferLock;
        private final WriteSkewHelper.KeySpecificLogic localNodeIsPrimaryOwner = segment -> this.getCacheTopology().getSegmentDistribution(segment).isPrimary();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CompletionStage<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            Commit doCommit;
            Object key = entry.getKey();
            int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
            Object previousValue = null;
            Metadata previousMetadata = null;
            this.stateTransferLock.acquireSharedTopologyLock();
            CompletionStage<Void> stage = null;
            try {
                doCommit = this.commitType(command, ctx, segment, entry.isRemoved());
                boolean isL1Write = false;
                if (!doCommit.isCommit() && this.configuration.clustering().l1().enabled()) {
                    long lifespan;
                    if (!(entry.isRemoved() || (lifespan = entry.getLifespan()) >= 0L && lifespan <= this.configuration.clustering().l1().lifespan())) {
                        Metadata metadata = entry.getMetadata().builder().lifespan(this.configuration.clustering().l1().lifespan()).build();
                        entry.setMetadata(new L1Metadata(metadata));
                    }
                    isL1Write = true;
                    doCommit = Commit.COMMIT_NON_LOCAL;
                } else if (doCommit.isCommit() && entry.getMetadata() instanceof L1Metadata) {
                    throw new IllegalStateException("Local entries must not have L1 metadata");
                }
                if (doCommit.isCommit()) {
                    boolean skipL1Write;
                    InternalCacheEntry previousEntry = this.dataContainer.peek(segment, key);
                    if (previousEntry != null) {
                        previousValue = previousEntry.getValue();
                        previousMetadata = previousEntry.getMetadata();
                    }
                    boolean bl = skipL1Write = isL1Write && previousEntry != null && !previousEntry.isL1Entry();
                    if (!skipL1Write) {
                        stage = this.commitManager.commit(entry, trackFlag, segment, l1Invalidation || isL1Write, ctx);
                    }
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
            if (doCommit.isCommit() && doCommit.isLocal()) {
                boolean created = entry.isCreated();
                boolean removed = entry.isRemoved();
                boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
                if (stage == null || CompletionStages.isCompletedSuccessfully(stage)) {
                    return NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata, this.evictionManager);
                }
                Object finalPreviousValue = previousValue;
                Metadata finalPreviousMetadata = previousMetadata;
                return stage.thenCompose(ignore -> NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, finalPreviousValue, finalPreviousMetadata, this.evictionManager));
            }
            return stage == null ? CompletableFutures.completedNull() : stage;
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic() {
            return this.localNodeIsPrimaryOwner;
        }
    }

    public static class ReplicationLogic
    extends InvalidationLogic {
        @Inject
        StateTransferLock stateTransferLock;
        private final WriteSkewHelper.KeySpecificLogic localNodeIsPrimaryOwner = segment -> this.getCacheTopology().getSegmentDistribution(segment).isPrimary();

        @Override
        public Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            return this.clusterCommitType(command, ctx, segment, removed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CompletionStage<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            Commit doCommit;
            Object key = entry.getKey();
            int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
            Object previousValue = null;
            Metadata previousMetadata = null;
            CompletionStage<Void> stage = null;
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                doCommit = this.commitType(command, ctx, segment, entry.isRemoved());
                if (doCommit.isCommit()) {
                    InternalCacheEntry previousEntry = this.dataContainer.peek(segment, key);
                    if (previousEntry != null) {
                        previousValue = previousEntry.getValue();
                        previousMetadata = previousEntry.getMetadata();
                    }
                    stage = this.commitManager.commit(entry, trackFlag, segment, l1Invalidation, ctx);
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
            if (doCommit.isCommit() && doCommit.isLocal()) {
                boolean created = entry.isCreated();
                boolean removed = entry.isRemoved();
                boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
                if (stage == null || CompletionStages.isCompletedSuccessfully(stage)) {
                    return NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata, this.evictionManager);
                }
                Object finalPreviousValue = previousValue;
                Metadata finalPreviousMetadata = previousMetadata;
                return stage.thenCompose(ignore -> NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, finalPreviousValue, finalPreviousMetadata, this.evictionManager));
            }
            return stage == null ? CompletableFutures.completedNull() : stage;
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic() {
            return this.localNodeIsPrimaryOwner;
        }
    }

    public static class InvalidationLogic
    extends AbstractClusteringDependentLogic {
        @Override
        public Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            return Commit.COMMIT_LOCAL;
        }

        @Override
        protected CompletionStage<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            Metadata previousMetadata;
            Object previousValue;
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
            Object key = entry.getKey();
            int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
            InternalCacheEntry previousEntry = this.dataContainer.peek(segment, entry.getKey());
            if (previousEntry != null) {
                previousValue = previousEntry.getValue();
                previousMetadata = previousEntry.getMetadata();
            } else {
                previousValue = null;
                previousMetadata = null;
            }
            CompletionStage<Void> stage = this.commitManager.commit(entry, trackFlag, segment, l1Invalidation, ctx);
            return stage.thenCompose(ignore -> NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata, this.evictionManager));
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic() {
            return null;
        }
    }

    public static class LocalLogic
    extends AbstractClusteringDependentLogic {
        private LocalizedCacheTopology localTopology;

        @Inject
        public void init(Transport transport, Configuration configuration, KeyPartitioner keyPartitioner) {
            Address address = transport != null ? transport.getAddress() : LocalModeAddress.INSTANCE;
            boolean segmented = configuration.persistence().stores().stream().anyMatch(StoreConfiguration::segmented);
            this.localTopology = segmented ? LocalizedCacheTopology.makeSegmentedSingletonTopology(keyPartitioner, configuration.clustering().hash().numSegments(), address) : LocalizedCacheTopology.makeSingletonTopology(CacheMode.LOCAL, address);
        }

        @Override
        public LocalizedCacheTopology getCacheTopology() {
            return this.localTopology;
        }

        @Override
        public Address getAddress() {
            return this.localTopology.getLocalAddress();
        }

        @Override
        public Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            return Commit.COMMIT_LOCAL;
        }

        @Override
        protected CompletionStage<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            Metadata previousMetadata;
            Object previousValue;
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean expired = removed && entry instanceof MVCCEntry && ((MVCCEntry)entry).isExpired();
            Object key = entry.getKey();
            int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
            InternalCacheEntry previousEntry = this.dataContainer.peek(segment, entry.getKey());
            if (previousEntry != null) {
                previousValue = previousEntry.getValue();
                previousMetadata = previousEntry.getMetadata();
            } else {
                previousValue = null;
                previousMetadata = null;
            }
            CompletionStage<Void> stage = this.commitManager.commit(entry, trackFlag, segment, l1Invalidation, ctx);
            return stage.thenCompose(ignore -> NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata, this.evictionManager));
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic() {
            return WriteSkewHelper.ALWAYS_TRUE_LOGIC;
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    public static abstract class AbstractClusteringDependentLogic
    implements ClusteringDependentLogic,
    PersistenceManager.StoreChangeListener {
        private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        @Inject
        protected ComponentRegistry componentRegistry;
        @Inject
        protected DistributionManager distributionManager;
        @Inject
        protected InternalDataContainer<Object, Object> dataContainer;
        @Inject
        protected CacheNotifier<Object, Object> notifier;
        @Inject
        protected CommitManager commitManager;
        @Inject
        protected PersistenceManager persistenceManager;
        @Inject
        protected TimeService timeService;
        @Inject
        protected FunctionalNotifier<Object, Object> functionalNotifier;
        @Inject
        protected Configuration configuration;
        @Inject
        protected KeyPartitioner keyPartitioner;
        @Inject
        protected EvictionManager<?, ?> evictionManager;
        @Inject
        protected DataOperationOrderer orderer;
        @Inject
        protected ActivationManager activationManager;
        @Inject
        protected KeyPartitioner keyPartioner;
        private WriteSkewHelper.KeySpecificLogic keySpecificLogic;
        private EntryLoader<?, ?> entryLoader;
        private volatile boolean writeOrdering = false;
        private volatile boolean passivation = false;

        @Override
        @Start
        public void start() {
            this.updateOrdering(this.configuration.persistence().usingStores());
            this.keySpecificLogic = this.initKeySpecificLogic();
            CacheLoaderInterceptor cli = this.componentRegistry.getComponent(CacheLoaderInterceptor.class);
            this.entryLoader = cli != null ? cli : (ctx, key, segment, cmd) -> {
                InternalCacheEntry<Object, Object> ice = this.dataContainer.peek(segment, key);
                if (ice != null && ice.canExpire() && ice.isExpired(this.timeService.wallClockTime())) {
                    ice = null;
                }
                return CompletableFuture.completedFuture(ice);
            };
            this.persistenceManager.addStoreListener(this);
        }

        @Stop
        public void stop() {
            this.persistenceManager.removeStoreListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void storeChanged(PersistenceStatus persistenceStatus) {
            AbstractClusteringDependentLogic abstractClusteringDependentLogic = this;
            synchronized (abstractClusteringDependentLogic) {
                this.updateOrdering(persistenceStatus.isEnabled());
            }
        }

        private void updateOrdering(boolean usingStores) {
            MemoryConfiguration memoryConfiguration = this.configuration.memory();
            PersistenceConfiguration persistenceConfiguration = this.configuration.persistence();
            if (memoryConfiguration.isEvictionEnabled() || usingStores) {
                this.writeOrdering = true;
                this.passivation = usingStores && persistenceConfiguration.passivation();
            }
        }

        @Override
        public CompletionStage<Map<Object, IncrementableEntryVersion>> createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            CompletionStage<Map<Object, IncrementableEntryVersion>> uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.entryLoader, versionGenerator, context, this.keySpecificLogic, this.keyPartitioner);
            return uv.thenApply(evm -> {
                Object cacheTransaction = context.getCacheTransaction();
                Map<Object, IncrementableEntryVersion> uvOld = cacheTransaction.getUpdatedEntryVersions();
                if (uvOld != null && !uvOld.isEmpty()) {
                    uvOld.putAll((Map<Object, IncrementableEntryVersion>)evm);
                    evm = uvOld;
                }
                cacheTransaction.setUpdatedEntryVersions((Map<Object, IncrementableEntryVersion>)evm);
                return evm.isEmpty() ? null : evm;
            });
        }

        @Override
        public final CompletionStage<Void> commitEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            if (entry instanceof ClearCacheEntry) {
                return this.commitClearCommand(this.dataContainer, ctx, command);
            }
            if (!this.writeOrdering) {
                return this.commitSingleEntry(entry, command, ctx, trackFlag, l1Invalidation);
            }
            if (this.passivation) {
                return this.commitEntryPassivation(entry, command, ctx, trackFlag, l1Invalidation);
            }
            return this.commitEntryOrdered(entry, command, ctx, trackFlag, l1Invalidation);
        }

        private CompletionStage<Void> commitClearCommand(DataContainer<Object, Object> dataContainer, InvocationContext context, FlagAffectedCommand command) {
            if (this.notifier.hasListener(CacheEntryRemoved.class)) {
                Iterator<InternalCacheEntry<Object, Object>> iterator = dataContainer.iteratorIncludingExpired();
                AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
                while (iterator.hasNext()) {
                    InternalCacheEntry<Object, Object> entry = iterator.next();
                    dataContainer.remove(entry.getKey());
                    aggregateCompletionStage.dependsOn(this.notifier.notifyCacheEntryRemoved(entry.getKey(), entry.getValue(), entry.getMetadata(), false, context, command));
                }
                return aggregateCompletionStage.freeze();
            }
            dataContainer.clear();
            return CompletableFutures.completedNull();
        }

        private CompletionStage<Void> commitEntryPassivation(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            Object key = entry.getKey();
            int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartioner);
            CompletableFuture<DataOperationOrderer.Operation> ourFuture = new CompletableFuture<DataOperationOrderer.Operation>();
            CompletionStage<DataOperationOrderer.Operation> waitingFuture = this.orderer.orderOn(key, ourFuture);
            CompletionStage<Void> chainedStage = waitingFuture != null ? waitingFuture.thenCompose(ignore -> this.activateKey(key, segment, entry, command, ctx, trackFlag, l1Invalidation)) : this.activateKey(key, segment, entry, command, ctx, trackFlag, l1Invalidation);
            return chainedStage.whenComplete((ignore, ignoreT) -> this.orderer.completeOperation(key, ourFuture, AbstractClusteringDependentLogic.operation(entry)));
        }

        private static DataOperationOrderer.Operation operation(CacheEntry entry) {
            return entry.isRemoved() ? DataOperationOrderer.Operation.REMOVE : DataOperationOrderer.Operation.WRITE;
        }

        private CompletionStage<Void> activateKey(Object key, int segment, CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            boolean shouldActivate = this.dataContainer.peek(segment, key) == null;
            CompletionStage<Void> commitStage = this.commitSingleEntry(entry, command, ctx, trackFlag, l1Invalidation);
            if (shouldActivate) {
                return commitStage.thenCompose(ignore1 -> {
                    if (log.isTraceEnabled()) {
                        log.tracef("Activating entry for key %s due to update in dataContainer", key);
                    }
                    return this.activationManager.activateAsync(key, segment);
                });
            }
            if (log.isTraceEnabled()) {
                log.tracef("Skipping removal from store as %s was in the data container", key);
            }
            return commitStage;
        }

        private CompletionStage<Void> commitEntryOrdered(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            CompletableFuture<DataOperationOrderer.Operation> ourFuture;
            Object key = entry.getKey();
            CompletionStage<DataOperationOrderer.Operation> waitingFuture = this.orderer.orderOn(key, ourFuture = new CompletableFuture<DataOperationOrderer.Operation>());
            CompletionStage<Void> chainedStage = waitingFuture != null ? waitingFuture.thenCompose(ignore -> this.commitSingleEntry(entry, command, ctx, trackFlag, l1Invalidation)) : this.commitSingleEntry(entry, command, ctx, trackFlag, l1Invalidation);
            if (CompletionStages.isCompletedSuccessfully(chainedStage)) {
                this.orderer.completeOperation(key, ourFuture, AbstractClusteringDependentLogic.operation(entry));
                return CompletableFutures.completedNull();
            }
            return chainedStage.whenComplete((ignore, ignoreT) -> this.orderer.completeOperation(key, ourFuture, AbstractClusteringDependentLogic.operation(entry)));
        }

        protected abstract CompletionStage<Void> commitSingleEntry(CacheEntry var1, FlagAffectedCommand var2, InvocationContext var3, Flag var4, boolean var5);

        protected Commit clusterCommitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            if (command != null && command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK)) {
                return Commit.COMMIT_LOCAL;
            }
            if (this.getCacheTopology().isSegmentWriteOwner(segment)) {
                return Commit.COMMIT_LOCAL;
            }
            return Commit.NO_COMMIT;
        }

        @Override
        public Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            return this.clusterCommitType(command, ctx, segment, removed);
        }

        protected abstract WriteSkewHelper.KeySpecificLogic initKeySpecificLogic();

        @Override
        public LocalizedCacheTopology getCacheTopology() {
            return this.distributionManager.getCacheTopology();
        }

        @Override
        public Address getAddress() {
            return this.getCacheTopology().getLocalAddress();
        }

        @Override
        public final <K, V> EntryLoader<K, V> getEntryLoader() {
            return this.entryLoader;
        }
    }

    public static enum Commit {
        NO_COMMIT(false, false),
        COMMIT_NON_LOCAL(true, false),
        COMMIT_LOCAL(true, true);

        private final boolean commit;
        private final boolean local;

        private Commit(boolean commit, boolean local) {
            this.commit = commit;
            this.local = local;
        }

        public boolean isCommit() {
            return this.commit;
        }

        public boolean isLocal() {
            return this.local;
        }
    }
}

