/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetClusterExecutorAction;
import org.infinispan.security.impl.SecureCacheImpl;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static ClusterExecutor getClusterExecutor(Cache<?, ?> cache) {
        GetClusterExecutorAction action = new GetClusterExecutorAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    static ClusterExecutor getClusterExecutor(EmbeddedCacheManager cacheManager) {
        GetClusterExecutorAction action = new GetClusterExecutorAction(cacheManager);
        return SecurityActions.doPrivileged(action);
    }

    static <K, V> Cache<K, V> getUnwrappedCache(Cache<K, V> cache) {
        if (cache instanceof SecureCacheImpl) {
            return SecurityActions.doPrivileged(((SecureCacheImpl)cache)::getDelegate);
        }
        return cache;
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager cacheManager) {
        return SecurityActions.doPrivileged(new GetCacheManagerConfigurationAction(cacheManager));
    }

    public static CacheMgmtInterceptor getCacheMgmtInterceptor(AdvancedCache<?, ?> cache) {
        ComponentRegistry componentRegistry = SecurityActions.doPrivileged(new GetCacheComponentRegistryAction(cache));
        return componentRegistry.getComponent(CacheMgmtInterceptor.class);
    }
}

