/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.common.spi;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.common.spi.AbstractMultiIndexSearchIndexNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexCompositeNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexCompositeNodeTypeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexSchemaElementContextHelper;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchIndexValueFieldContext;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractMultiIndexSearchIndexCompositeNodeContext<S extends SearchIndexCompositeNodeContext<SC>, SC extends SearchIndexScope<?>, NT extends SearchIndexCompositeNodeTypeContext<SC, S>, F extends SearchIndexNodeContext<SC>>
extends AbstractMultiIndexSearchIndexNodeContext<S, SC, NT>
implements SearchIndexCompositeNodeContext<SC>,
SearchIndexCompositeNodeTypeContext<SC, S> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private Map<String, F> staticChildrenByName;

    public AbstractMultiIndexSearchIndexCompositeNodeContext(SC scope, String absolutePath, List<? extends S> nodeForEachIndex) {
        super(scope, absolutePath, nodeForEachIndex);
    }

    public final NT type() {
        return (NT)((SearchIndexCompositeNodeTypeContext)this.selfAsNodeType());
    }

    @Override
    public final boolean isComposite() {
        return true;
    }

    @Override
    public boolean isObjectField() {
        return this.absolutePath != null;
    }

    @Override
    public final boolean isValueField() {
        return false;
    }

    public final S toComposite() {
        return (S)((SearchIndexCompositeNodeContext)this.self());
    }

    public S toObjectField() {
        if (this.isObjectField()) {
            return (S)((SearchIndexCompositeNodeContext)this.self());
        }
        return (S)SearchIndexSchemaElementContextHelper.throwingToObjectField(this);
    }

    @Override
    public SearchIndexValueFieldContext<SC> toValueField() {
        return SearchIndexSchemaElementContextHelper.throwingToValueField(this);
    }

    @Override
    public final String absolutePath(String relativeFieldName) {
        return FieldPaths.compose(this.absolutePath(), relativeFieldName);
    }

    @Override
    public final boolean nested() {
        return this.fromTypeIfCompatible(SearchIndexCompositeNodeTypeContext::nested, Object::equals, "nested");
    }

    @Override
    public final Map<String, F> staticChildrenByName() {
        if (this.staticChildrenByName != null) {
            return this.staticChildrenByName;
        }
        TreeMap<String, F> result = new TreeMap<String, F>();
        Function<String, SearchIndexNodeContext> createChildFieldContext = this::childInScope;
        for (SearchIndexCompositeNodeContext nodeForIndex : this.nodeForEachIndex) {
            for (String childRelativeName : nodeForIndex.staticChildrenByName().keySet()) {
                try {
                    result.computeIfAbsent(childRelativeName, createChildFieldContext);
                }
                catch (SearchException e) {
                    throw log.inconsistentConfigurationInContextForSearch(this.relativeEventContext(), e.getMessage(), this.indexesEventContext(), e);
                }
            }
        }
        this.staticChildrenByName = result;
        return this.staticChildrenByName;
    }

    protected abstract F childInScope(String var1);

    @Override
    final SearchIndexSchemaElementContextHelper helper() {
        return SearchIndexSchemaElementContextHelper.COMPOSITE;
    }
}

