/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.util.Objects;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.credential.Credential;

public final class GSSKerberosCredential
implements Credential {
    private final GSSCredential gssCredential;
    private final KerberosTicket kerberosTicket;

    public GSSKerberosCredential(GSSCredential gssCredential) {
        this(gssCredential, null);
    }

    public GSSKerberosCredential(GSSCredential gssCredential, KerberosTicket kerberosTicket) {
        Assert.checkNotNullParam((String)"gssCredential", (Object)gssCredential);
        this.gssCredential = gssCredential;
        this.kerberosTicket = kerberosTicket;
    }

    public GSSCredential getGssCredential() {
        return this.gssCredential;
    }

    public KerberosTicket getKerberosTicket() {
        return this.kerberosTicket;
    }

    @Override
    public GSSKerberosCredential clone() {
        return this;
    }

    public int hashCode() {
        return HashMath.multiHashOrdered((int)this.gssCredential.hashCode(), (int)31, (int)Objects.hashCode(this.kerberosTicket));
    }

    public boolean equals(Object obj) {
        return obj instanceof GSSKerberosCredential && this.equals((GSSKerberosCredential)obj);
    }

    private boolean equals(GSSKerberosCredential obj) {
        return this.gssCredential.equals(obj.gssCredential) && Objects.equals(this.kerberosTicket, obj.kerberosTicket);
    }
}

