/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.service.extensions.xa.recovery;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXARecoveryLogger;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class ActiveMQXARecoveryLogger_impl
implements ActiveMQXARecoveryLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQXARecoveryLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void serverRunningCachedCommand(Runnable run) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ171003: JMS Server Manager Running cached command for {}", (Object)run);
        }
    }

    @Override
    public void serverCachingCommand(Object runnable) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ171004: JMS Server Manager Caching command for {} since the JMS Server is not active.", runnable);
        }
    }

    @Override
    public void invalidHostForConnector(String name, String newHost) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172005: Invalid \"host\" value \"0.0.0.0\" detected for \"{}\" connector. Switching to \"{}\". If this new address is incorrect please manually configure the connector to use the proper one.", (Object)name, (Object)newHost);
        }
    }

    @Override
    public void noQueueOnTopic(String queueName, String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172007: Queue {} does not exist on the topic {}. It was deleted manually probably.", (Object)queueName, (Object)name);
        }
    }

    @Override
    public void recoveryConnectFailed(String s) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172008: XA Recovery can not connect to any broker on recovery {}", (Object)s);
        }
    }

    @Override
    public void jndiUnbindError(String key, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172011: error unbinding {} from JNDI", (Object)key, (Object)e);
        }
    }

    @Override
    public void jmsServerError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172012: JMS Server Manager error", (Throwable)e);
        }
    }

    @Override
    public void xaRecoverError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172013: Error in XA Recovery recover", (Throwable)e);
        }
    }

    @Override
    public void xaRecoverConnectionError(ClientSessionFactory csf, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172014: Notified of connection failure in xa recovery connectionFactory for provider {} will attempt reconnect on next pass", (Object)csf, (Object)e);
        }
    }

    @Override
    public void xaRecoverAutoConnectionError(XARecoveryConfig csf, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172015: Can not connect to {} on auto-generated resource recovery", (Object)csf, (Object)e);
        }
    }

    @Override
    public void xaRecoveryError(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ172016: Error in XA Recovery", (Throwable)e);
        }
    }

    @Override
    public void failedToCorrectHost(String name, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172017: Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{}\" connector, but received an exception.", (Object)name, (Object)e);
        }
    }

    @Override
    public void xaRecoveryStartError(XARecoveryConfig e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172018: Could not start recovery discovery on {}, we will retry every recovery scan until the server is available", (Object)e);
        }
    }

    @Override
    public void jmsConfigMissingKey(Node e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ174000: key attribute missing for JMS configuration {}", (Object)e);
        }
    }

    @Override
    public void jmsDeployerStartError(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ174002: Failed to start JMS deployer", (Throwable)e);
        }
    }
}

