/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.helpers;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.smallrye.reactive.messaging.providers.helpers.TypeUtils;
import jakarta.enterprise.inject.Instance;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;

public class ConverterUtils {
    private ConverterUtils() {
    }

    public static Multi<? extends Message<?>> convert(Multi<? extends Message<?>> upstream, final Instance<MessageConverter> converters, final Type injectedPayloadType) {
        if (injectedPayloadType != null) {
            return upstream.map(new Function<Message<?>, Message<?>>(){
                MessageConverter actual;

                @Override
                public Message<?> apply(Message<?> o) {
                    if (injectedPayloadType == null) {
                        return o;
                    }
                    if (o.getPayload() != null && o.getPayload().getClass().equals(injectedPayloadType)) {
                        return o;
                    }
                    if (this.actual != null) {
                        return this.actual.convert(o, injectedPayloadType);
                    }
                    if (o.getPayload() != null && TypeUtils.isAssignable(o.getPayload().getClass(), injectedPayloadType)) {
                        this.actual = MessageConverter.IdentityConverter.INSTANCE;
                        return o;
                    }
                    for (MessageConverter conv : CDIUtils.getSortedInstances(converters)) {
                        if (!conv.canConvert(o, injectedPayloadType)) continue;
                        this.actual = conv;
                        return this.actual.convert(o, injectedPayloadType);
                    }
                    return o;
                }
            });
        }
        return upstream;
    }
}

