/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.bgi;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;

public class BooleanGetAndIsPlugin {
    private static final Logger LOG = Logger.getLogger(BooleanGetAndIsPlugin.class.getName());
    private static final String IS_PREFIX = "is";

    public String getOptionName() {
        return "Xbgi";
    }

    public String getUsage() {
        return "  -Xbgi                 : Generate getXXX and isXXX methods for Booleans";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClass(classOutline);
        }
        return true;
    }

    private void processClass(ClassOutline clazz) {
        Collection methods = clazz.implClass.methods();
        HashMap<String, JType> methodsToAdd = new HashMap<String, JType>();
        for (JMethod method : methods) {
            if (!method.name().startsWith(IS_PREFIX) || !this.requiresGetter(methods, method)) continue;
            methodsToAdd.put(method.name(), method.type());
        }
        for (Map.Entry entry : methodsToAdd.entrySet()) {
            String newName = "get" + ((String)entry.getKey()).substring(2);
            LOG.info("Adding method " + newName);
            JMethod newMethod = clazz.implClass.method(1, (JType)entry.getValue(), newName);
            JBlock body = newMethod.body();
            body.directStatement("return " + (String)entry.getKey() + "();");
        }
    }

    private boolean requiresGetter(Collection<JMethod> methods, JMethod method) {
        String newName = "get" + method.name().substring(2);
        for (JMethod cursor : methods) {
            if (!newName.equals(cursor.name())) continue;
            return false;
        }
        return true;
    }
}

