/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.internal;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import io.narayana.lra.coordinator.domain.model.FailedLongRunningAction;
import io.narayana.lra.coordinator.domain.model.LongRunningAction;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.coordinator.internal.Implementations;
import io.narayana.lra.coordinator.internal.RecoveringLRA;
import io.narayana.lra.logging.LRALogger;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.microprofile.lra.annotation.LRAStatus;

public class LRARecoveryModule
implements RecoveryModule {
    private LRAService service;
    private final String _transactionType = LongRunningAction.getType();
    private static RecoveryStore _recoveryStore = null;
    private final TransactionStatusConnectionManager _transactionStatusConnectionMgr;
    private static LRARecoveryModule lraRecoveryModule;

    public LRARecoveryModule() {
        this.service = new LRAService();
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
        Implementations.install();
    }

    public static LRAService getService() {
        return LRARecoveryModule.getInstance().service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LRARecoveryModule getInstance() {
        if (lraRecoveryModule != null) {
            return lraRecoveryModule;
        }
        RecoveryManager.manager();
        for (RecoveryModule rm : recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryModules()) {
            if (!(rm instanceof LRARecoveryModule)) continue;
            lraRecoveryModule = (LRARecoveryModule)rm;
            return lraRecoveryModule;
        }
        Class<LRARecoveryModule> clazz = LRARecoveryModule.class;
        synchronized (LRARecoveryModule.class) {
            if (lraRecoveryModule == null) {
                lraRecoveryModule = new LRARecoveryModule();
                RecoveryManager.manager().addModule((RecoveryModule)lraRecoveryModule);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return lraRecoveryModule;
        }
    }

    public void periodicWorkFirstPass() {
        if (LRALogger.logger.isTraceEnabled()) {
            LRALogger.logger.trace((Object)"LRARecoveryModule: first pass");
        }
    }

    public void periodicWorkSecondPass() {
        if (LRALogger.logger.isTraceEnabled()) {
            LRALogger.logger.trace((Object)"LRARecoveryModule: second pass");
        }
        this.recoverTransactions();
    }

    private synchronized void recoverTransactions() {
        InputObjectState aa_uids = new InputObjectState();
        if (this.getUids(this._transactionType, aa_uids)) {
            this.processTransactionsStatus(this.processTransactions(aa_uids));
        }
    }

    private void doRecoverTransaction(Uid recoverUid) {
        block7: {
            int theStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._transactionType, recoverUid);
            try {
                RecoveringLRA lra = new RecoveringLRA(this.service, recoverUid, theStatus);
                boolean inFlight = lra.getLRAStatus() == LRAStatus.Active;
                LRAStatus lraStatus = lra.getLRAStatus();
                if (LRAStatus.FailedToCancel.equals((Object)lraStatus) || LRAStatus.FailedToClose.equals((Object)lraStatus)) {
                    this.moveEntryToFailedLRAPath(recoverUid);
                    return;
                }
                if (!this.service.hasTransaction(lra.getId())) {
                    this.service.addTransaction(lra);
                }
                if (LRALogger.logger.isDebugEnabled()) {
                    LRALogger.logger.debug((Object)("LRARecoverModule: transaction type is " + this._transactionType + " uid is " + recoverUid.toString() + "\n Status is " + lraStatus + " in flight is " + inFlight));
                }
                if (!inFlight && lra.hasPendingActions()) {
                    lra.replayPhase2();
                    if (!lra.isRecovering()) {
                        this.service.finished(lra, false);
                    }
                }
            }
            catch (Exception e) {
                if (!LRALogger.logger.isInfoEnabled()) break block7;
                LRALogger.logger.infof("LRARecoverModule: Error '%s' while recovering LRA record %s", (Object)e.getMessage(), (Object)recoverUid.fileStringForm());
            }
        }
    }

    public boolean moveEntryToFailedLRAPath(Uid failedUid) {
        String failedLRAType = "/StateManager/BasicAction/LongRunningAction/Failed";
        boolean moved = false;
        try {
            InputObjectState inputState = _recoveryStore.read_committed(failedUid, this._transactionType);
            InputObjectState failedLRAUidState = _recoveryStore.read_committed(failedUid, failedLRAType);
            if (inputState != null) {
                if (failedLRAUidState != null) {
                    moved = true;
                    if (!_recoveryStore.remove_committed(failedUid, this._transactionType)) {
                        LRALogger.i18nLogger.warn_UnableToRemoveDuplicateFailedLRAParticipantRecord(failedUid.toString(), failedLRAType, this._transactionType);
                        moved = false;
                    }
                    return moved;
                }
                if (_recoveryStore.write_committed(failedUid, failedLRAType, new OutputObjectState(inputState)) && (moved = _recoveryStore.remove_committed(failedUid, this._transactionType))) {
                    LRALogger.logger.infof("Failed lra record (Uid: %s) moved to new location type: %s", (Object)failedUid, (Object)failedLRAType);
                }
            }
        }
        catch (ObjectStoreException e) {
            LRALogger.i18nLogger.warn_move_lra_record(failedUid.toString(), e.getMessage());
        }
        return moved;
    }

    private Collection<Uid> processTransactions(InputObjectState uids) {
        ArrayList<Uid> uidCollection = new ArrayList<Uid>();
        if (LRALogger.logger.isDebugEnabled()) {
            LRALogger.logger.debugf("LRARecoverModule: processing transaction type %s", (Object)this._transactionType);
        }
        Consumer<Uid> uidUnpacker = uidCollection::add;
        this.forEach(uids, uidUnpacker, this._transactionType);
        return uidCollection;
    }

    private void processTransactionsStatus(Collection<Uid> uids) {
        uids.forEach(uid -> {
            block4: {
                try {
                    if (_recoveryStore.currentState(uid, this._transactionType) != -1) {
                        this.doRecoverTransaction((Uid)uid);
                    }
                }
                catch (ObjectStoreException e) {
                    if (LRALogger.logger.isTraceEnabled()) {
                        LRALogger.logger.tracef((Throwable)e, "LRARecoverModule: Object store exception '%s' while reading the current state of LRA record %s:", (Object)e.getMessage(), (Object)uid.fileStringForm());
                    }
                    if (!LRALogger.logger.isInfoEnabled()) break block4;
                    LRALogger.logger.infof("LRARecoverModule: Object store exception '%s' while reading the current state of LRA record %s", (Object)e.getMessage(), (Object)uid.fileStringForm());
                }
            }
        });
    }

    public void getRecoveringLRAs(Map<URI, LongRunningAction> lras) {
        InputObjectState aa_uids = new InputObjectState();
        if (this.getUids(this._transactionType, aa_uids)) {
            Collection<Uid> uids = this.processTransactions(aa_uids);
            uids.forEach(uid -> {
                int status = this._transactionStatusConnectionMgr.getTransactionStatus(this._transactionType, uid);
                RecoveringLRA lra = new RecoveringLRA(this.service, (Uid)uid, status);
                if (lra.isActivated()) {
                    lras.put(lra.getId(), lra);
                } else {
                    LRALogger.logger.infof("LRARecoverModule: failed to activate LRA record %s", (Object)uid.fileStringForm());
                }
            });
        }
    }

    public boolean removeCommitted(Uid lraUid) {
        try {
            return _recoveryStore.remove_committed(lraUid, this._transactionType);
        }
        catch (ObjectStoreException e) {
            if (LRALogger.logger.isTraceEnabled()) {
                LRALogger.logger.tracef((Throwable)e, "LRARecoveryModule: Object store exception '%s' while removing LRA record %s", (Object)e.getMessage(), (Object)lraUid.fileStringForm());
            } else if (LRALogger.logger.isInfoEnabled()) {
                LRALogger.logger.infof("LRARecoveryModule: Object store exception '%s' while removing LRA record %s", (Object)e.getMessage(), (Object)lraUid.fileStringForm());
            }
            return false;
        }
    }

    public void recover() {
        this.recoverTransactions();
    }

    public void getFailedLRAs(Map<URI, LongRunningAction> lras) {
        InputObjectState aa_uids = new InputObjectState();
        Consumer<Uid> failedLRACreator = uid -> {
            FailedLongRunningAction lra = new FailedLongRunningAction(this.service, new Uid(uid));
            lra.activate();
            LRAStatus status = lra.getLRAStatus();
            if (LRAStatus.FailedToCancel.equals((Object)status) || LRAStatus.FailedToClose.equals((Object)status)) {
                lras.put(lra.getId(), lra);
            }
        };
        if (this.getUids("/StateManager/BasicAction/LongRunningAction/Failed", aa_uids)) {
            this.forEach(aa_uids, failedLRACreator, "/StateManager/BasicAction/LongRunningAction/Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getUids(String type, InputObjectState aa_uids) {
        LRARecoveryModule lRARecoveryModule = this;
        synchronized (lRARecoveryModule) {
            try {
                return _recoveryStore.allObjUids(type, aa_uids);
            }
            catch (ObjectStoreException e) {
                if (LRALogger.logger.isTraceEnabled()) {
                    LRALogger.logger.tracef((Throwable)e, "LRARecoverModule: Object store exception %s while unpacking records of type %s", (Object)e.getMessage(), (Object)type);
                } else if (LRALogger.logger.isInfoEnabled()) {
                    LRALogger.logger.infof("LRARecoverModule: Object store exception %s while unpacking records of type %s", (Object)e.getMessage(), (Object)type);
                }
                return false;
            }
        }
    }

    private void forEach(InputObjectState uids, Consumer<Uid> consumer, String transactionType) {
        try {
            while (true) {
                Uid uid;
                if ((uid = new Uid(uids.unpackBytes())).equals(Uid.nullUid())) {
                    return;
                }
                consumer.accept(uid);
            }
        }
        catch (IOException e) {
            if (LRALogger.logger.isTraceEnabled()) {
                LRALogger.logger.tracef((Throwable)e, "LRARecoverModule: Object store exception %s while unpacking a record of type %s", (Object)e.getMessage(), (Object)transactionType);
            } else if (LRALogger.logger.isInfoEnabled()) {
                LRALogger.logger.infof("LRARecoverModule: Object store exception %s while unpacking a record of type: %s", (Object)e.getMessage(), (Object)transactionType);
            }
            return;
        }
    }
}

