/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;

public interface AttributeConverter {
    public static final AttributeConverter DEFAULT_VALUE = new AttributeConverter(){

        @Override
        public void convertOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            if (!attributeValue.isDefined()) {
                String operationName = operation.get("operation").asString();
                if (operationName.equals("write-attribute")) {
                    this.convertResourceAttribute(address, attributeName, attributeValue, context);
                } else {
                    ImmutableManagementResourceRegistration registration = context.getResourceRegistrationFromRoot(PathAddress.EMPTY_ADDRESS);
                    OperationDefinition definition = registration.getOperationEntry(address, operationName).getOperationDefinition();
                    for (AttributeDefinition parameter : definition.getParameters()) {
                        if (!parameter.getName().equals(attributeName)) continue;
                        attributeValue.set(parameter.getDefaultValue());
                        break;
                    }
                }
            }
        }

        @Override
        public void convertResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (!attributeValue.isDefined()) {
                ImmutableManagementResourceRegistration registration = context.getResourceRegistrationFromRoot(PathAddress.EMPTY_ADDRESS);
                AttributeDefinition definition = registration.getAttributeAccess(address, attributeName).getAttributeDefinition();
                attributeValue.set(definition.getDefaultValue());
            }
        }
    };
    public static final AttributeConverter NAME_FROM_ADDRESS = new DefaultAttributeConverter(){

        @Override
        public void convertAttribute(PathAddress address, String name, ModelNode attributeValue, TransformationContext context) {
            PathElement element = address.getLastElement();
            attributeValue.set(element.getValue());
        }
    };

    public void convertOperationParameter(PathAddress var1, String var2, ModelNode var3, ModelNode var4, TransformationContext var5);

    public void convertResourceAttribute(PathAddress var1, String var2, ModelNode var3, TransformationContext var4);

    public static class Factory {
        public static AttributeConverter createHardCoded(ModelNode hardCodedValue) {
            return Factory.createHardCoded(hardCodedValue, false);
        }

        public static AttributeConverter createHardCoded(final ModelNode hardCodedValue, final boolean undefinedOnly) {
            return new DefaultAttributeConverter(){

                @Override
                public void convertAttribute(PathAddress address, String name, ModelNode attributeValue, TransformationContext context) {
                    if (!undefinedOnly || !attributeValue.isDefined()) {
                        attributeValue.set(hardCodedValue);
                    }
                }
            };
        }
    }

    public static abstract class DefaultAttributeConverter
    implements AttributeConverter {
        @Override
        public void convertOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            this.convertAttribute(address, attributeName, attributeValue, context);
        }

        @Override
        public void convertResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            this.convertAttribute(address, attributeName, attributeValue, context);
        }

        protected abstract void convertAttribute(PathAddress var1, String var2, ModelNode var3, TransformationContext var4);
    }
}

