/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Predicate;
import org.wildfly.clustering.ejb.cache.timer.ImmutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerConfiguration;
import org.wildfly.clustering.ejb.timer.TimerType;
import org.wildfly.clustering.marshalling.spi.Marshaller;

public class DefaultImmutableTimerMetaData<C>
implements ImmutableTimerMetaData {
    private final ImmutableTimerMetaDataEntry<C> entry;
    private final boolean persistent;
    private final Marshaller<Object, C> marshaller;

    public DefaultImmutableTimerMetaData(TimerMetaDataConfiguration<C> configuration, ImmutableTimerMetaDataEntry<C> entry) {
        this.marshaller = configuration.getMarshaller();
        this.persistent = configuration.isPersistent();
        this.entry = entry;
    }

    public TimerType getType() {
        return this.entry.getType();
    }

    public Object getContext() {
        try {
            return this.marshaller.read(this.entry.getContext());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Optional<Instant> getLastTimeout() {
        return Optional.ofNullable(this.entry.getLastTimeout()).map(this.entry.getStart()::plus);
    }

    public Optional<Instant> getNextTimeout() {
        Optional<Instant> lastTimeout = this.getLastTimeout();
        return lastTimeout.isPresent() ? lastTimeout.map(this.entry) : Optional.of(this.entry.getStart());
    }

    public <TC extends TimerConfiguration> TC getConfiguration(Class<TC> configurationClass) {
        return (TC)((TimerConfiguration)configurationClass.cast(this.entry));
    }

    public Predicate<Method> getTimeoutMatcher() {
        return this.entry.getTimeoutMatcher();
    }
}

