/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.stub;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.subordinate.SubordinateBACoordinator;
import com.arjuna.webservices11.wsba.BusinessActivityConstants;
import com.arjuna.wst.BusinessAgreementWithCoordinatorCompletionParticipant;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst.PersistableParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.BAParticipantManager;
import java.io.IOException;
import org.jboss.jbossts.xts.recovery.participant.ba.PersistableBAParticipant;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryManager;

public class SubordinateCoordinatorCompletionParticipantStub
implements BusinessAgreementWithCoordinatorCompletionParticipant,
PersistableParticipant,
PersistableBAParticipant {
    private SubordinateBACoordinator coordinator;
    private String coordinatorId;
    private boolean recovered;
    private BAParticipantManager manager;

    public SubordinateCoordinatorCompletionParticipantStub(SubordinateBACoordinator coordinator) {
        this.coordinator = coordinator;
        this.coordinatorId = coordinator.get_uid().stringForm();
        this.recovered = false;
        this.manager = null;
    }

    public SubordinateCoordinatorCompletionParticipantStub() {
        this.coordinator = null;
        this.coordinatorId = null;
        this.recovered = true;
        this.manager = null;
    }

    public void setManager(BAParticipantManager manager) {
        this.manager = manager;
    }

    @Override
    public void complete() throws WrongStateException, SystemException {
        if (!this.recovered) {
            try {
                this.coordinator.complete();
            }
            catch (com.arjuna.mw.wsas.exceptions.WrongStateException wse) {
                throw new WrongStateException(wse.getMessage());
            }
            catch (com.arjuna.mw.wsas.exceptions.SystemException se) {
                throw new SystemException(se.getMessage());
            }
            if (this.coordinator.status() == 4) {
                this.manager.fail(BusinessActivityConstants.WSBA_ELEMENT_FAIL_QNAME);
            } else {
                this.manager = null;
            }
        } else {
            throw new WrongStateException();
        }
    }

    @Override
    public void close() throws WrongStateException, SystemException {
        if (!this.recovered) {
            int result;
            try {
                result = this.coordinator.close();
            }
            catch (com.arjuna.mw.wsas.exceptions.SystemException se) {
                throw new SystemException(se.getMessage());
            }
            if (result != 7) {
                throw new SystemException("failed to close subordinate transaction " + this.coordinatorId);
            }
        } else {
            XTSBARecoveryManager recoveryManager = null;
            boolean isRecoveryScanStarted = false;
            if (this.coordinator == null) {
                recoveryManager = XTSBARecoveryManager.getRecoveryManager();
                isRecoveryScanStarted = recoveryManager.isSubordinateCoordinatorRecoveryStarted();
                this.coordinator = SubordinateBACoordinator.getRecoveredCoordinator(this.coordinatorId);
            }
            if (this.coordinator == null) {
                if (!isRecoveryScanStarted) {
                    throw new SystemException();
                }
            } else {
                if (!this.coordinator.isActivated()) {
                    throw new SystemException();
                }
                int status = this.coordinator.status();
                if (status == 5 || status == 6) {
                    try {
                        this.coordinator.close();
                        SubordinateBACoordinator.removeActiveProxy(this.coordinatorId);
                    }
                    catch (com.arjuna.mw.wsas.exceptions.SystemException e) {
                        throw new SystemException();
                    }
                    status = this.coordinator.status();
                }
                if (status == 6) {
                    throw new SystemException();
                }
            }
        }
    }

    @Override
    public void cancel() throws FaultedException, WrongStateException, SystemException {
        if (!this.recovered) {
            int result = this.coordinator.cancel();
            if (result != 4) {
                throw new FaultedException("failed to compensate subordinate transaction " + this.coordinatorId);
            }
        } else {
            XTSBARecoveryManager recoveryManager = null;
            boolean isRecoveryScanStarted = false;
            if (this.coordinator == null) {
                recoveryManager = XTSBARecoveryManager.getRecoveryManager();
                isRecoveryScanStarted = recoveryManager.isSubordinateCoordinatorRecoveryStarted();
                this.coordinator = SubordinateBACoordinator.getRecoveredCoordinator(this.coordinatorId);
            }
            if (this.coordinator == null) {
                if (!isRecoveryScanStarted) {
                    throw new SystemException();
                }
            } else {
                if (!this.coordinator.isActivated()) {
                    throw new SystemException();
                }
                int status = this.coordinator.status();
                if (status == 5 || status == 6) {
                    this.coordinator.cancel();
                    SubordinateBACoordinator.removeActiveProxy(this.coordinatorId);
                }
                if (status == 6) {
                    throw new SystemException();
                }
                if (status != 4) {
                    throw new FaultedException();
                }
            }
        }
    }

    @Override
    public void compensate() throws FaultedException, WrongStateException, SystemException {
        if (!this.recovered) {
            int n = this.coordinator.cancel();
        } else {
            XTSBARecoveryManager recoveryManager = null;
            boolean isRecoveryScanStarted = false;
            if (this.coordinator == null) {
                recoveryManager = XTSBARecoveryManager.getRecoveryManager();
                isRecoveryScanStarted = recoveryManager.isSubordinateCoordinatorRecoveryStarted();
                this.coordinator = SubordinateBACoordinator.getRecoveredCoordinator(this.coordinatorId);
            }
            if (this.coordinator == null) {
                if (!isRecoveryScanStarted) {
                    throw new SystemException();
                }
            } else {
                if (!this.coordinator.isActivated()) {
                    throw new SystemException();
                }
                int status = this.coordinator.status();
                if (status == 5 || status == 6) {
                    this.coordinator.cancel();
                    SubordinateBACoordinator.removeActiveProxy(this.coordinatorId);
                    status = this.coordinator.status();
                }
                if (status == 6) {
                    throw new SystemException();
                }
                if (status != 4) {
                    throw new FaultedException();
                }
            }
        }
    }

    @Override
    public String status() throws SystemException {
        return null;
    }

    @Override
    public void unknown() throws SystemException {
    }

    @Override
    public void error() throws SystemException {
    }

    @Override
    public boolean saveState(OutputObjectState oos) {
        try {
            oos.packString(this.coordinatorId);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean restoreState(InputObjectState ios) {
        try {
            this.coordinatorId = ios.unpackString();
            SubordinateBACoordinator.addActiveProxy(this.coordinatorId);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public byte[] getRecoveryState() throws Exception {
        OutputObjectState oos = new OutputObjectState();
        oos.packString(this.getClass().getName());
        this.saveState(oos);
        return oos.buffer();
    }
}

