/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.RegexpQueryFlag;
import org.hibernate.search.engine.search.predicate.spi.RegexpPredicateBuilder;
import org.hibernate.search.util.common.AssertionFailure;

public class ElasticsearchTextRegexpPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor REGEXP_ACCESSOR = JsonAccessor.root().property("regexp").asObject();
    private static final JsonAccessor<JsonElement> VALUE_ACCESSOR = JsonAccessor.root().property("value");
    private static final JsonAccessor<String> FLAGS_ACCESSOR = JsonAccessor.root().property("flags").asString();
    private static final String NO_OPTIONAL_OPERATORS_FLAG_MARK = "NONE";
    private final JsonPrimitive pattern;
    private final Set<RegexpQueryFlag> flags;

    public ElasticsearchTextRegexpPredicate(Builder builder) {
        super(builder);
        this.pattern = builder.pattern;
        this.flags = builder.flags;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        VALUE_ACCESSOR.set(innerObject, (JsonElement)this.pattern);
        FLAGS_ACCESSOR.set(innerObject, ElasticsearchTextRegexpPredicate.toFlagsMask(this.flags));
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        REGEXP_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }

    private static String toFlagsMask(Set<RegexpQueryFlag> flags) {
        if (flags == null || flags.isEmpty()) {
            return NO_OPTIONAL_OPERATORS_FLAG_MARK;
        }
        StringBuilder flagsMask = new StringBuilder();
        for (RegexpQueryFlag flag : flags) {
            if (flagsMask.length() > 0) {
                flagsMask.append("|");
            }
            flagsMask.append(ElasticsearchTextRegexpPredicate.getFlagName(flag));
        }
        return flagsMask.toString();
    }

    private static String getFlagName(RegexpQueryFlag flag) {
        switch (flag) {
            case INTERVAL: {
                return "INTERVAL";
            }
            case INTERSECTION: {
                return "INTERSECTION";
            }
            case ANY_STRING: {
                return "ANYSTRING";
            }
        }
        throw new AssertionFailure("Unexpected flag: " + flag);
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements RegexpPredicateBuilder {
        private JsonPrimitive pattern;
        private Set<RegexpQueryFlag> flags;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<String> field) {
            super(scope, field);
        }

        public void pattern(String pattern) {
            this.pattern = new JsonPrimitive(pattern);
        }

        public void flags(Set<RegexpQueryFlag> flags) {
            this.flags = flags.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(flags);
        }

        public SearchPredicate build() {
            return new ElasticsearchTextRegexpPredicate(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchValueFieldSearchQueryElementFactory<RegexpPredicateBuilder, String> {
        @Override
        public RegexpPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<String> field) {
            return new Builder(scope, field);
        }
    }
}

