/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.csiv2;

import com.sun.corba.se.impl.interceptors.ClientRequestInfoImpl;
import com.sun.corba.se.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.spi.transport.CorbaConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.GSSUP.InitialContextToken;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.wildfly.iiop.openjdk.csiv2.CSIv2Util;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ElytronSASClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final int SAS_CONTEXT_ID = 15;
    private static final String AUTHENTICATION_CONTEXT_CAPABILITY = "org.wildfly.security.authentication-context";
    private static final RuntimeCapability<Void> AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.security.authentication-context", (boolean)true, AuthenticationContext.class).build();
    private static final AuthenticationContextConfigurationClient AUTH_CONFIG_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private static final IdentityToken ABSENT_IDENTITY_TOKEN = new IdentityToken();
    private static final byte[] NO_AUTHENTICATION_TOKEN;
    private static final AuthorizationElement[] NO_AUTHORIZATION_TOKEN;
    private static String authenticationContextName;
    private Codec codec;
    private AuthenticationContext authContext;

    public static void setAuthenticationContextName(String authenticationContextName) {
        ElytronSASClientInterceptor.authenticationContextName = authenticationContextName;
    }

    public ElytronSASClientInterceptor(Codec codec) {
        this.codec = codec;
        ServiceContainer container = this.currentServiceContainer();
        if (authenticationContextName != null) {
            ServiceName authContextServiceName = AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY.getCapabilityServiceName(new String[]{authenticationContextName});
            this.authContext = (AuthenticationContext)container.getRequiredService(authContextServiceName).getValue();
        } else {
            this.authContext = null;
        }
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        try {
            CompoundSecMech secMech = CSIv2Util.getMatchingSecurityMech(ri, this.codec, (short)64, (short)0);
            if (secMech == null) {
                return;
            }
            IdentityToken identityToken = ABSENT_IDENTITY_TOKEN;
            byte[] encodedAuthenticationToken = NO_AUTHENTICATION_TOKEN;
            URI uri = this.getURI(ri);
            if (uri == null) {
                return;
            }
            SecurityDomain domain = ElytronSASClientInterceptor.getCurrentSecurityDomain();
            SecurityIdentity currentIdentity = null;
            if (domain != null) {
                currentIdentity = domain.getCurrentSecurityIdentity();
            }
            AuthenticationContext authContext = this.authContext != null ? this.authContext : (currentIdentity == null || currentIdentity.isAnonymous() ? AuthenticationContext.captureCurrent() : AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useForwardedIdentity(domain)));
            if ((secMech.sas_context_mech.target_supports & 0x400) != 0) {
                AuthenticationConfiguration configuration = AUTH_CONFIG_CLIENT.getAuthenticationConfiguration(uri, authContext, -1, null, null);
                Principal principal = AUTH_CONFIG_CLIENT.getPrincipal(configuration);
                if (principal != null && principal != AnonymousPrincipal.getInstance()) {
                    byte[] encapsulatedEncodedName;
                    Object name = principal.getName();
                    if (((String)name).indexOf(64) < 0) {
                        name = (String)name + "@default";
                    }
                    byte[] principalName = ((String)name).getBytes(StandardCharsets.UTF_8);
                    byte[] encodedName = CSIv2Util.encodeGssExportedName(principalName);
                    Any any = ORB.init().create_any();
                    GSS_NT_ExportedNameHelper.insert((Any)any, (byte[])encodedName);
                    try {
                        encapsulatedEncodedName = this.codec.encode_value(any);
                    }
                    catch (InvalidTypeForEncoding e) {
                        throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
                    }
                    identityToken = new IdentityToken();
                    identityToken.principal_name(encapsulatedEncodedName);
                } else if ((secMech.sas_context_mech.supported_identity_types & 1) != 0) {
                    identityToken = new IdentityToken();
                    identityToken.anonymous(true);
                }
                if ((secMech.as_context_mech.target_requires & 0x40) != 0) {
                    encodedAuthenticationToken = this.createInitialContextToken(uri, secMech);
                }
            } else if ((secMech.as_context_mech.target_supports & 0x40) != 0) {
                encodedAuthenticationToken = this.createInitialContextToken(uri, secMech);
            }
            if (identityToken != ABSENT_IDENTITY_TOKEN || encodedAuthenticationToken != NO_AUTHENTICATION_TOKEN) {
                EstablishContext message = new EstablishContext(0L, NO_AUTHORIZATION_TOKEN, identityToken, encodedAuthenticationToken);
                SASContextBody contextBody = new SASContextBody();
                contextBody.establish_msg(message);
                Any any = ORB.init().create_any();
                SASContextBodyHelper.insert((Any)any, (SASContextBody)contextBody);
                ServiceContext sc = new ServiceContext(15, this.codec.encode_value(any));
                ri.add_request_service_context(sc, true);
            }
        }
        catch (Exception e) {
            throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
        try {
            ServiceContext sc = ri.get_reply_service_context(15);
            Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
            SASContextBody contextBody = SASContextBodyHelper.extract((Any)msg);
            IIOPLogger.ROOT_LOGGER.tracef("receive_reply: got SAS reply, type %d", contextBody.discriminator());
            if (contextBody.discriminator() == 4) {
                throw IIOPLogger.ROOT_LOGGER.unexpectedContextErrorInSASReply(0, CompletionStatus.COMPLETED_YES);
            }
        }
        catch (BAD_PARAM sc) {
        }
        catch (FormatMismatch | TypeMismatch e) {
            throw IIOPLogger.ROOT_LOGGER.errorParsingSASReply((Exception)e, 0, CompletionStatus.COMPLETED_YES);
        }
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        try {
            ServiceContext sc = ri.get_reply_service_context(15);
            Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
            SASContextBody contextBody = SASContextBodyHelper.extract((Any)msg);
            IIOPLogger.ROOT_LOGGER.tracef("receive_exception: got SAS reply, type %d", contextBody.discriminator());
        }
        catch (BAD_PARAM sc) {
        }
        catch (FormatMismatch | TypeMismatch e) {
            throw IIOPLogger.ROOT_LOGGER.errorParsingSASReply((Exception)e, 0, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public String name() {
        return "ElytronSASClientInterceptor";
    }

    public void destroy() {
    }

    private ServiceContainer currentServiceContainer() {
        if (WildFlySecurityManager.isChecking()) {
            return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
        }
        return CurrentServiceContainer.getServiceContainer();
    }

    private URI getURI(ClientRequestInfo clientRequestInfo) throws URISyntaxException {
        StringBuilder builder = new StringBuilder("iiop:");
        if (clientRequestInfo instanceof ClientRequestInfoImpl) {
            ClientRequestInfoImpl infoImpl = (ClientRequestInfoImpl)clientRequestInfo;
            CorbaConnection connection = (CorbaConnection)infoImpl.connection();
            if (connection == null) {
                return null;
            }
            ContactInfo info = connection.getContactInfo();
            if (info instanceof SocketOrChannelContactInfoImpl) {
                int port;
                String hostname = ((SocketOrChannelContactInfoImpl)info).getHost();
                if (hostname != null) {
                    builder.append("//").append(hostname);
                }
                if ((port = ((SocketOrChannelContactInfoImpl)info).getPort()) > 0) {
                    builder.append(":").append(port);
                }
            }
        } else {
            return null;
        }
        return new URI(builder.toString());
    }

    private byte[] createInitialContextToken(URI uri, CompoundSecMech secMech) throws Exception {
        AuthenticationContext authContext = this.authContext == null ? AuthenticationContext.captureCurrent() : this.authContext;
        AuthenticationConfiguration configuration = AUTH_CONFIG_CLIENT.getAuthenticationConfiguration(uri, authContext, -1, null, null);
        CallbackHandler handler = AUTH_CONFIG_CLIENT.getCallbackHandler(configuration);
        NameCallback nameCallback = new NameCallback("Username: ");
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
        try {
            handler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (UnsupportedCallbackException e) {
            return NO_AUTHENTICATION_TOKEN;
        }
        if (nameCallback.getName() != null && !nameCallback.getName().equals(AnonymousPrincipal.getInstance().getName())) {
            byte[] encodedTargetName = secMech.as_context_mech.target_name;
            Object name = nameCallback.getName();
            if (((String)name).indexOf(64) < 0) {
                byte[] decodedTargetName = CSIv2Util.decodeGssExportedName(encodedTargetName);
                String targetName = new String(decodedTargetName, StandardCharsets.UTF_8);
                name = (String)name + "@" + targetName;
            }
            byte[] username = ((String)name).getBytes(StandardCharsets.UTF_8);
            byte[] password = new byte[]{};
            if (passwordCallback.getPassword() != null) {
                password = new String(passwordCallback.getPassword()).getBytes(StandardCharsets.UTF_8);
            }
            InitialContextToken authenticationToken = new InitialContextToken(username, password, encodedTargetName);
            return CSIv2Util.encodeInitialContextToken(authenticationToken, this.codec);
        }
        return NO_AUTHENTICATION_TOKEN;
    }

    private static SecurityDomain getCurrentSecurityDomain() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(SecurityDomain::getCurrent);
        }
        return SecurityDomain.getCurrent();
    }

    static {
        ABSENT_IDENTITY_TOKEN.absent(true);
        NO_AUTHENTICATION_TOKEN = new byte[0];
        NO_AUTHORIZATION_TOKEN = new AuthorizationElement[0];
    }
}

