/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.SerializationFailureHandler;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class KafkaDeadLetterSerializationHandler<T>
implements SerializationFailureHandler<T> {
    @Override
    public byte[] decorateSerialization(Uni<byte[]> serialization, String topic, boolean isKey, String serializer, T data, Headers headers) {
        Header dataHeader;
        if (headers.lastHeader("deserialization-failure-deserializer") != null && (dataHeader = headers.lastHeader("deserialization-failure-data")) != null) {
            if (isKey) {
                Header isKeyHeader = headers.lastHeader("deserialization-failure-key");
                if (isKeyHeader != null && Arrays.equals(isKeyHeader.value(), DeserializationFailureHandler.TRUE_VALUE)) {
                    Header keyDataHeader = headers.lastHeader("deserialization-failure-key-data");
                    return Objects.requireNonNullElse(keyDataHeader, dataHeader).value();
                }
            } else {
                Header valueDataHeader = headers.lastHeader("deserialization-failure-value-data");
                return Objects.requireNonNullElse(valueDataHeader, dataHeader).value();
            }
        }
        return SerializationFailureHandler.super.decorateSerialization(serialization, topic, isKey, serializer, data, headers);
    }
}

