/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.scheduler;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.wildfly.clustering.ee.cache.scheduler.ConcurrentDirectDeque;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;

public class LinkedScheduledEntries<K, V>
implements ScheduledEntries<K, V> {
    private final ConcurrentDirectDeque<Map.Entry<K, V>> queue = ConcurrentDirectDeque.newInstance();
    private final Map<K, Object> tokens = new ConcurrentHashMap<K, Object>();

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public void add(K key, V value) {
        Object token = this.queue.offerLastAndReturnToken(new AbstractMap.SimpleImmutableEntry<K, V>(key, value));
        this.tokens.put(key, token);
    }

    @Override
    public void remove(K key) {
        Object token = this.tokens.remove(key);
        if (token != null) {
            this.queue.removeToken(token);
        }
    }

    @Override
    public boolean contains(K key) {
        return this.tokens.containsKey(key);
    }

    @Override
    public Map.Entry<K, V> peek() {
        return (Map.Entry)this.queue.peekFirst();
    }

    @Override
    public Stream<Map.Entry<K, V>> stream() {
        return this.queue.stream();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        final Iterator iterator = this.queue.iterator();
        final Map<K, Object> tokens = this.tokens;
        return new Iterator<Map.Entry<K, V>>(){
            private K current = null;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry next = (Map.Entry)iterator.next();
                this.current = next.getKey();
                return next;
            }

            @Override
            public void remove() {
                iterator.remove();
                tokens.remove(this.current);
            }
        };
    }

    public String toString() {
        return this.queue.toString();
    }
}

