/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.orchestration.impl.IndexAccessorWorkExecutionContext;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestrator;
import org.hibernate.search.backend.lucene.resources.impl.BackendThreads;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWork;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWorkExecutionContext;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.common.execution.spi.SimpleScheduledExecutor;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneParallelWorkOrchestratorImpl
extends AbstractWorkOrchestrator<WorkExecution<?>>
implements LuceneParallelWorkOrchestrator {
    private static final BiConsumer<WorkExecution<?>, Throwable> ASYNC_FAILURE_REPORTER = WorkExecution::markAsFailed;
    private final IndexAccessor indexAccessor;
    private final IndexAccessorWorkExecutionContext context;
    private final BackendThreads threads;
    private SimpleScheduledExecutor executor;

    public LuceneParallelWorkOrchestratorImpl(String name, EventContext eventContext, IndexAccessor indexAccessor, BackendThreads threads) {
        super(name);
        this.indexAccessor = indexAccessor;
        this.context = new IndexAccessorWorkExecutionContext(eventContext, indexAccessor);
        this.threads = threads;
    }

    @Override
    public <T> void submit(CompletableFuture<T> future, IndexManagementWork<T> work, OperationSubmitter operationSubmitter) {
        this.submit(new WorkExecution<T>(future, work, this.context), operationSubmitter);
    }

    @Override
    public void forceCommitInCurrentThread() {
        try {
            this.indexAccessor.commit();
        }
        catch (Throwable e) {
            this.context.getIndexAccessor().cleanUpAfterFailure(e, "Commit after an index management operation");
            throw e;
        }
    }

    protected void doStart(ConfigurationPropertySource propertySource) {
        this.executor = this.threads.getWriteExecutor();
    }

    protected void doSubmit(WorkExecution<?> workExecution, OperationSubmitter operationSubmitter) throws InterruptedException {
        operationSubmitter.submitToExecutor(this.executor, workExecution, this.blockingRetryProducer, ASYNC_FAILURE_REPORTER);
    }

    protected CompletableFuture<?> completion() {
        return CompletableFuture.completedFuture(null);
    }

    protected void doStop() {
        this.executor = null;
    }

    static class WorkExecution<T>
    implements Runnable {
        private final CompletableFuture<T> result;
        private final IndexManagementWork<T> work;
        private final IndexManagementWorkExecutionContext context;

        WorkExecution(CompletableFuture<T> result, IndexManagementWork<T> work, IndexManagementWorkExecutionContext context) {
            this.result = result;
            this.work = work;
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.result.complete(this.work.execute(this.context));
            }
            catch (Throwable e) {
                this.context.getIndexAccessor().cleanUpAfterFailure(e, this.work.getInfo());
                this.markAsFailed(e);
            }
        }

        public void markAsFailed(Throwable throwable) {
            this.result.completeExceptionally(throwable);
        }
    }
}

