/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import jakarta.persistence.Embedded;
import jakarta.persistence.metamodel.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImpl;
import org.hibernate.bytecode.enhance.internal.bytebuddy.PersistentAttributeTransformer;
import org.hibernate.bytecode.enhance.internal.bytebuddy.UnloadedTypeDescription;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;

class ByteBuddyEnhancementContext {
    private static final ElementMatcher.Junction<MethodDescription> IS_GETTER = ElementMatchers.isGetter();
    private final EnhancementContext enhancementContext;
    private final ConcurrentHashMap<TypeDescription, Map<String, MethodDescription>> getterByTypeMap = new ConcurrentHashMap();

    ByteBuddyEnhancementContext(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
    }

    public ClassLoader getLoadingClassLoader() {
        return this.enhancementContext.getLoadingClassLoader();
    }

    public boolean isEntityClass(TypeDescription classDescriptor) {
        return this.enhancementContext.isEntityClass(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean isCompositeClass(TypeDescription classDescriptor) {
        return this.enhancementContext.isCompositeClass(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean isMappedSuperclassClass(TypeDescription classDescriptor) {
        return this.enhancementContext.isMappedSuperclassClass(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean doDirtyCheckingInline(TypeDescription classDescriptor) {
        return this.enhancementContext.doDirtyCheckingInline(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean doExtendedEnhancement(TypeDescription classDescriptor) {
        return this.enhancementContext.doExtendedEnhancement(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean hasLazyLoadableAttributes(TypeDescription classDescriptor) {
        return this.enhancementContext.hasLazyLoadableAttributes(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean isPersistentField(EnhancerImpl.AnnotatedFieldDescription field) {
        return this.enhancementContext.isPersistentField(field);
    }

    public boolean isCompositeField(EnhancerImpl.AnnotatedFieldDescription field) {
        return this.isCompositeClass(field.getType().asErasure()) || field.hasAnnotation(Embedded.class);
    }

    public EnhancerImpl.AnnotatedFieldDescription[] order(EnhancerImpl.AnnotatedFieldDescription[] persistentFields) {
        return (EnhancerImpl.AnnotatedFieldDescription[])this.enhancementContext.order(persistentFields);
    }

    public boolean isLazyLoadable(EnhancerImpl.AnnotatedFieldDescription field) {
        return this.enhancementContext.isLazyLoadable(field);
    }

    public boolean isMappedCollection(EnhancerImpl.AnnotatedFieldDescription field) {
        return this.enhancementContext.isMappedCollection(field);
    }

    public boolean doBiDirectionalAssociationManagement(EnhancerImpl.AnnotatedFieldDescription field) {
        return this.enhancementContext.doBiDirectionalAssociationManagement(field);
    }

    public boolean isDiscoveredType(TypeDescription typeDescription) {
        return this.enhancementContext.isDiscoveredType(new UnloadedTypeDescription(typeDescription));
    }

    public void registerDiscoveredType(TypeDescription typeDescription, Type.PersistenceType type) {
        this.enhancementContext.registerDiscoveredType(new UnloadedTypeDescription(typeDescription), type);
    }

    public void discoverCompositeTypes(TypeDescription managedCtClass, TypePool typePool) {
        if (this.isDiscoveredType(managedCtClass)) {
            return;
        }
        Type.PersistenceType determinedPersistenceType = this.isEntityClass(managedCtClass) ? Type.PersistenceType.ENTITY : (this.isCompositeClass(managedCtClass) ? Type.PersistenceType.EMBEDDABLE : (this.isMappedSuperclassClass(managedCtClass) ? Type.PersistenceType.MAPPED_SUPERCLASS : Type.PersistenceType.BASIC));
        this.registerDiscoveredType(managedCtClass, determinedPersistenceType);
        if (determinedPersistenceType != Type.PersistenceType.BASIC) {
            EnhancerImpl.AnnotatedFieldDescription[] enhancedFields;
            for (EnhancerImpl.AnnotatedFieldDescription enhancedField : enhancedFields = PersistentAttributeTransformer.collectPersistentFields(managedCtClass, this, typePool).getEnhancedFields()) {
                TypeDescription type = enhancedField.getType().asErasure();
                if (!type.isInterface() && enhancedField.hasAnnotation(Embedded.class)) {
                    this.registerDiscoveredType(type, Type.PersistenceType.EMBEDDABLE);
                }
                this.discoverCompositeTypes(type, typePool);
            }
        }
    }

    Optional<MethodDescription> resolveGetter(FieldDescription fieldDescription) {
        Map getters = this.getterByTypeMap.computeIfAbsent(fieldDescription.getDeclaringType().asErasure(), declaringType -> ((MethodList)MethodGraph.Compiler.DEFAULT.compile(declaringType).listNodes().asMethodList().filter(IS_GETTER)).stream().collect(Collectors.toMap(NamedElement::getActualName, Function.identity())));
        String capitalizedFieldName = Character.toUpperCase(fieldDescription.getName().charAt(0)) + fieldDescription.getName().substring(1);
        MethodDescription getCandidate = (MethodDescription)getters.get("get" + capitalizedFieldName);
        MethodDescription isCandidate = (MethodDescription)getters.get("is" + capitalizedFieldName);
        if (getCandidate != null) {
            if (isCandidate != null) {
                return Optional.empty();
            }
            return Optional.of(getCandidate);
        }
        return Optional.ofNullable(isCandidate);
    }
}

