/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.host;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.discovery.DiscoveryOptionsResource;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.operations.HostAddHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.RootPlatformMBeanResource;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleClassLoader;

public class HostDefinition
extends SimpleResourceDefinition {
    private final ManagementResourceRegistration root;
    private final HostControllerEnvironment environment;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
    private final HostModelUtil.HostModelRegistrar hostModelRegistrar;
    private final ProcessType processType;
    private final DelegatingConfigurableAuthorizer authorizer;
    private final Resource modelControllerResource;
    private final LocalHostControllerInfo localHostControllerInfo;

    public HostDefinition(ManagementResourceRegistration root, HostControllerEnvironment environment, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, HostModelUtil.HostModelRegistrar hostModelRegistrar, ProcessType processType, DelegatingConfigurableAuthorizer authorizer, Resource modelControllerResource, LocalHostControllerInfoImpl localHostControllerInfo) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"host"), (ResourceDescriptionResolver)HostModelUtil.getResourceDescriptionResolver(new String[0])));
        this.root = root;
        this.environment = environment;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
        this.hostModelRegistrar = hostModelRegistrar;
        this.processType = processType;
        this.authorizer = authorizer;
        this.modelControllerResource = modelControllerResource;
        this.localHostControllerInfo = localHostControllerInfo;
    }

    public LocalHostControllerInfo getLocalHostControllerInfo() {
        return this.localHostControllerInfo;
    }

    public void registerHostModel(String hostName) {
        this.hostModelRegistrar.registerHostModel(hostName, this.root);
    }

    public void initCoreModel(ModelNode model) {
        HostDefinition.initCoreModel(model, this.environment);
    }

    public void initModelServices(OperationContext context, PathAddress hostAddress, Resource rootResource) {
        Resource management = context.createResource(hostAddress.append(new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management")}));
        if (this.modelControllerResource != null) {
            management.registerChild(PathElement.pathElement((String)"service", (String)"management-operations"), this.modelControllerResource);
        }
        context.addResource(hostAddress.append(new PathElement[]{PathElement.pathElement((String)"core-service", (String)"host-environment")}), (Resource)PlaceholderResource.INSTANCE);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"module-loading"), (Resource)PlaceholderResource.INSTANCE);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"capability-registry"), (Resource)PlaceholderResource.INSTANCE);
        rootResource.registerChild(PlatformMBeanConstants.ROOT_PATH, (Resource)new RootPlatformMBeanResource());
        Resource.ResourceEntry ignoredRoot = this.ignoredDomainResourceRegistry.getRootResource();
        rootResource.registerChild(ignoredRoot.getPathElement(), (Resource)ignoredRoot);
        context.addResource(hostAddress.append(new PathElement[]{PathElement.pathElement((String)"core-service", (String)"discovery-options")}), (Resource)new DiscoveryOptionsResource());
    }

    public void registerOperations(ManagementResourceRegistration hostDefinition) {
        super.registerOperations(hostDefinition);
        hostDefinition.registerOperationHandler(HostAddHandler.DEFINITION, (OperationStepHandler)new HostAddHandler(this));
    }

    private static void initCoreModel(ModelNode root, HostControllerEnvironment environment) {
        block5: {
            try {
                root.get("release-version").set(Version.AS_VERSION);
                root.get("release-codename").set(Version.AS_RELEASE_CODENAME);
            }
            catch (RuntimeException e) {
                if (!(HostAddHandler.class.getClassLoader() instanceof ModuleClassLoader)) break block5;
                throw e;
            }
        }
        root.get("management-major-version").set(24);
        root.get("management-minor-version").set(0);
        root.get("management-micro-version").set(0);
        ModelNode nameNode = root.get("product-name");
        ModelNode versionNode = root.get("product-version");
        if (environment != null) {
            String productName = environment.getProductConfig().getProductName();
            String productVersion = environment.getProductConfig().getProductVersion();
            if (productName != null) {
                nameNode.set(productName);
            }
            if (productVersion != null) {
                versionNode.set(productVersion);
            }
        }
        root.get("namespaces").setEmptyList();
        root.get("schema-locations").setEmptyList();
    }
}

