/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.capability;

import java.util.List;
import java.util.ListIterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.QuaternaryServiceDescriptor;
import org.wildfly.service.descriptor.ServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

public interface CapabilityReferenceRecorder<T>
extends org.jboss.as.controller.CapabilityReferenceRecorder {
    public RuntimeCapability<Void> getDependent();

    public ServiceDescriptor<T> getRequirement();

    default public String getBaseRequirementName() {
        return this.getRequirement().getName();
    }

    default public String getBaseDependentName() {
        return this.getDependent().getName();
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, UnaryServiceDescriptor<T> requirement) {
        return new CapabilityServiceDescriptorReferenceRecorder<T>(capability, requirement, List.of());
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, BinaryServiceDescriptor<T> requirement) {
        return CapabilityReferenceRecorder.of(capability, requirement, CapabilityServiceDescriptorReferenceRecorder.CHILD_PATH);
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, BinaryServiceDescriptor<T> requirement, Function<PathAddress, PathElement> parentPathResolver) {
        return new CapabilityServiceDescriptorReferenceRecorder<T>(capability, requirement, List.of(parentPathResolver));
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, BinaryServiceDescriptor<T> requirement, AttributeDefinition parentAttribute) {
        return new CapabilityServiceDescriptorReferenceRecorder<T>(capability, requirement, new AttributeDefinition[]{parentAttribute});
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, TernaryServiceDescriptor<T> requirement) {
        return CapabilityReferenceRecorder.of(capability, requirement, CapabilityServiceDescriptorReferenceRecorder.PARENT_PATH, CapabilityServiceDescriptorReferenceRecorder.CHILD_PATH);
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, TernaryServiceDescriptor<T> requirement, Function<PathAddress, PathElement> grandparentPathResolver, Function<PathAddress, PathElement> parentPathResolver) {
        return new CapabilityServiceDescriptorReferenceRecorder<T>(capability, requirement, List.of(grandparentPathResolver, parentPathResolver));
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, TernaryServiceDescriptor<T> requirement, AttributeDefinition grandparentAttribute, AttributeDefinition parentAttribute) {
        return new CapabilityServiceDescriptorReferenceRecorder<T>(capability, requirement, new AttributeDefinition[]{grandparentAttribute, parentAttribute});
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, QuaternaryServiceDescriptor<T> requirement) {
        return CapabilityReferenceRecorder.of(capability, requirement, CapabilityServiceDescriptorReferenceRecorder.GRANDPARENT_PATH, CapabilityServiceDescriptorReferenceRecorder.PARENT_PATH, CapabilityServiceDescriptorReferenceRecorder.CHILD_PATH);
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, QuaternaryServiceDescriptor<T> requirement, Function<PathAddress, PathElement> greatGrandparentPathResolver, Function<PathAddress, PathElement> grandparentPathResolver, Function<PathAddress, PathElement> parentPathResolver) {
        return new CapabilityServiceDescriptorReferenceRecorder<T>(capability, requirement, List.of(greatGrandparentPathResolver, grandparentPathResolver, parentPathResolver));
    }

    public static <T> CapabilityReferenceRecorder<T> of(RuntimeCapability<Void> capability, QuaternaryServiceDescriptor<T> requirement, AttributeDefinition greatGrandparentAttribute, AttributeDefinition grandparentAttribute, AttributeDefinition parentAttribute) {
        return new CapabilityServiceDescriptorReferenceRecorder<T>(capability, requirement, new AttributeDefinition[]{greatGrandparentAttribute, grandparentAttribute, parentAttribute});
    }

    public static class CapabilityServiceDescriptorReferenceRecorder<T>
    extends AbstractCapabilityServiceDescriptorReferenceRecorder<T> {
        private static final Function<PathAddress, PathElement> CHILD_PATH = PathAddress::getLastElement;
        private static final Function<PathAddress, PathElement> PARENT_PATH = CHILD_PATH.compose(PathAddress::getParent);
        private static final Function<PathAddress, PathElement> GRANDPARENT_PATH = PARENT_PATH.compose(PathAddress::getParent);
        private final BiFunction<OperationContext, String, String[]> requirementNameComposer;
        private final BiFunction<PathAddress, String, String[]> requirementPatternComposer;

        CapabilityServiceDescriptorReferenceRecorder(RuntimeCapability<Void> capability, ServiceDescriptor<T> requirement, final List<Function<PathAddress, PathElement>> parentPathResolvers) {
            super(capability, requirement);
            this.requirementNameComposer = new BiFunction<OperationContext, String, String[]>(){

                @Override
                public String[] apply(OperationContext context, String value) {
                    PathAddress address = context.getCurrentAddress();
                    String[] result = new String[parentPathResolvers.size() + 1];
                    ListIterator iterator = parentPathResolvers.listIterator();
                    while (iterator.hasNext()) {
                        result[iterator.nextIndex()] = ((PathElement)((Function)iterator.next()).apply(address)).getValue();
                    }
                    result[parentPathResolvers.size()] = value;
                    return result;
                }
            };
            this.requirementPatternComposer = new BiFunction<PathAddress, String, String[]>(){

                @Override
                public String[] apply(PathAddress address, String name) {
                    String[] result = new String[parentPathResolvers.size() + 1];
                    ListIterator iterator = parentPathResolvers.listIterator();
                    while (iterator.hasNext()) {
                        result[iterator.nextIndex()] = ((PathElement)((Function)iterator.next()).apply(address)).getKey();
                    }
                    result[parentPathResolvers.size()] = name;
                    return result;
                }
            };
        }

        CapabilityServiceDescriptorReferenceRecorder(RuntimeCapability<Void> capability, ServiceDescriptor<T> requirement, final AttributeDefinition ... attributes) {
            super(capability, requirement);
            this.requirementNameComposer = new BiFunction<OperationContext, String, String[]>(){

                @Override
                public String[] apply(OperationContext context, String value) {
                    String[] result = new String[attributes.length + 1];
                    if (attributes.length > 0) {
                        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
                        for (int i = 0; i < attributes.length; ++i) {
                            result[i] = model.get(attributes[i].getName()).asString();
                        }
                    }
                    result[attributes.length] = value;
                    return result;
                }
            };
            this.requirementPatternComposer = new BiFunction<PathAddress, String, String[]>(){

                @Override
                public String[] apply(PathAddress address, String name) {
                    String[] result = new String[attributes.length + 1];
                    for (int i = 0; i < attributes.length; ++i) {
                        result[i] = attributes[i].getName();
                    }
                    result[attributes.length] = name;
                    return result;
                }
            };
        }

        public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
            String dependentName = this.resolveDependentName(context);
            for (String value : values) {
                if (value == null) continue;
                context.registerAdditionalCapabilityRequirement(this.resolveRequirementName(context, value), dependentName, attributeName);
            }
        }

        public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
            String dependentName = this.resolveDependentName(context);
            for (String value : values) {
                if (value == null) continue;
                context.deregisterCapabilityRequirement(this.resolveRequirementName(context, value), dependentName);
            }
        }

        private String resolveRequirementName(OperationContext context, String value) {
            return RuntimeCapability.buildDynamicCapabilityName((String)this.getBaseRequirementName(), (String[])this.requirementNameComposer.apply(context, value));
        }

        public String[] getRequirementPatternSegments(String name, PathAddress address) {
            return this.requirementPatternComposer.apply(address, name);
        }
    }

    public static abstract class AbstractCapabilityServiceDescriptorReferenceRecorder<T>
    implements CapabilityReferenceRecorder<T> {
        private final RuntimeCapability<Void> capability;
        private final ServiceDescriptor<T> requirement;

        AbstractCapabilityServiceDescriptorReferenceRecorder(RuntimeCapability<Void> capability, ServiceDescriptor<T> requirement) {
            this.capability = capability;
            this.requirement = requirement;
        }

        @Override
        public RuntimeCapability<Void> getDependent() {
            return this.capability;
        }

        @Override
        public ServiceDescriptor<T> getRequirement() {
            return this.requirement;
        }

        String resolveDependentName(OperationContext context) {
            return this.getDependent().fromBaseCapability(context.getCurrentAddress()).getName();
        }

        public int hashCode() {
            return this.capability.getName().hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof CapabilityReferenceRecorder ? this.getDependent().equals(((CapabilityReferenceRecorder)object).getDependent()) : false;
        }
    }
}

