/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;
import org.wildfly.extension.messaging.activemq.ManagementUtil;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public class SecurityRoleReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final SecurityRoleReadAttributeHandler INSTANCE = new SecurityRoleReadAttributeHandler();

    private SecurityRoleReadAttributeHandler() {
    }

    protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
        return false;
    }

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String attributeName = operation.require("name").asString();
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String addressName = pathAddress.getElement(pathAddress.size() - 2).getValue();
        String roleName = pathAddress.getLastElement().getValue();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        ActiveMQBroker server = (ActiveMQBroker)ActiveMQBroker.class.cast(service.getValue());
        AddressControl control = (AddressControl)AddressControl.class.cast(server.getResource("address." + addressName));
        if (control == null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
        }
        try {
            ModelNode roles = ManagementUtil.convertRoles(control.getRoles());
            ModelNode matchedRole = this.findRole(roleName, roles);
            if (matchedRole == null || !matchedRole.hasDefined(attributeName)) {
                throw MessagingLogger.ROOT_LOGGER.unsupportedAttribute(attributeName);
            }
            boolean value = matchedRole.get(attributeName).asBoolean();
            context.getResult().set(value);
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
    }

    private ModelNode findRole(String roleName, ModelNode roles) {
        for (ModelNode role : roles.asList()) {
            if (!role.get("name").asString().equals(roleName)) continue;
            return role;
        }
        return null;
    }
}

