/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupRemove;

public class SocketDiscoveryGroupRemove
extends ReloadRequiredRemoveStepHandler {
    public static final SocketDiscoveryGroupRemove INSTANCE = new SocketDiscoveryGroupRemove(true);
    public static final SocketDiscoveryGroupRemove LEGACY_INSTANCE = new SocketDiscoveryGroupRemove(false);
    private final boolean needLegacyCall;

    private SocketDiscoveryGroupRemove(boolean needLegacyCall) {
        this.needLegacyCall = needLegacyCall;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (this.needLegacyCall) {
            PathAddress target = context.getCurrentAddress().getParent().append("discovery-group", context.getCurrentAddressValue());
            try {
                context.readResourceFromRoot(target);
                ModelNode op = operation.clone();
                op.get("address").set(target.toModelNode());
                context.addStep(op, (OperationStepHandler)DiscoveryGroupRemove.LEGACY_INSTANCE, OperationContext.Stage.MODEL, true);
            }
            catch (Resource.NoSuchResourceException noSuchResourceException) {
                // empty catch block
            }
        }
        super.execute(context, operation);
    }
}

