/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DecoratorExternalizer<T>
implements Externalizer<T>,
ParametricPrivilegedAction<T, T> {
    private final Class<T> decoratorClass;
    private final UnaryOperator<T> decorator;
    private final Field field;

    public DecoratorExternalizer(final Class<T> decoratedClass, UnaryOperator<T> decorator, T sample) {
        this.decorator = decorator;
        final Class<?> decoratorClass = decorator.apply(sample).getClass();
        this.decoratorClass = decoratorClass;
        this.field = (Field)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                Field field = DecoratorExternalizer.findDecoratedField(decoratorClass, decoratedClass);
                field.setAccessible(true);
                return field;
            }
        });
    }

    static Field findDecoratedField(Class<?> decoratorClass, Class<?> decoratedClass) {
        LinkedList<Field> assignableFields = new LinkedList<Field>();
        for (Field field : decoratorClass.getDeclaredFields()) {
            Class<?> type = field.getType();
            if (Modifier.isStatic(field.getModifiers()) || type == Object.class || !type.isAssignableFrom(decoratedClass)) continue;
            assignableFields.add(field);
        }
        if (assignableFields.size() > 1) {
            throw new IllegalStateException(((Object)assignableFields).toString());
        }
        if (!assignableFields.isEmpty()) {
            return (Field)assignableFields.get(0);
        }
        Class<?> superClass = decoratorClass.getSuperclass();
        if (superClass == null) {
            throw new IllegalStateException(decoratorClass.getName());
        }
        return DecoratorExternalizer.findDecoratedField(superClass, decoratedClass);
    }

    public Class<T> getTargetClass() {
        return this.decoratorClass;
    }

    public void writeObject(ObjectOutput output, T value) throws IOException {
        Object decorated = WildFlySecurityManager.doUnchecked(value, (ParametricPrivilegedAction)this);
        output.writeObject(decorated);
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object decorated = input.readObject();
        return (T)this.decorator.apply(decorated);
    }

    public T run(T value) {
        try {
            return (T)this.field.get(value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

