/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password.simple;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.as.domain.management.security.password.Keyboard;
import org.wildfly.common.Assert;

public class SimpleKeyboard
implements Keyboard {
    protected Map<Character, Set<Character>> keys = new TreeMap<Character, Set<Character>>();

    public SimpleKeyboard() {
        InputStream is = Keyboard.class.getResourceAsStream("keybord.properties");
        if (is != null) {
            this.init(is);
        }
    }

    public SimpleKeyboard(InputStream is) {
        this.init(is);
    }

    protected void init(InputStream is) {
        try {
            Properties props = new Properties();
            props.load(is);
            for (String string : props.keySet()) {
                String charsString = (String)props.get(string);
                Character key = null;
                key = string.length() > 0 ? Character.valueOf(string.charAt(0)) : Character.valueOf(' ');
                TreeSet<Character> chars = new TreeSet<Character>();
                for (int index = 0; index < charsString.length(); ++index) {
                    Character c = Character.valueOf(charsString.charAt(index));
                    chars.add(c);
                }
                this.keys.put(key, chars);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public boolean siblings(String word, int index) {
        return this.siblings(word, index, index + 1);
    }

    @Override
    public boolean siblings(String word, int index, int isSiblingIndex) {
        Assert.checkNotNullParam((String)"word", (Object)word);
        if (index >= isSiblingIndex) {
            throw new IllegalArgumentException();
        }
        int len = word.length();
        if (index >= len) {
            throw new IllegalArgumentException();
        }
        Character keyId = Character.valueOf(word.charAt(index));
        Character possibleSibling = Character.valueOf(word.charAt(isSiblingIndex));
        Set<Character> chars = this.keys.get(keyId);
        return chars != null && chars.contains(possibleSibling);
    }

    @Override
    public int sequence(String word, int start) {
        int len = word.length();
        if (start >= len) {
            throw new IllegalArgumentException("Start index greater than word length");
        }
        int sequenceLength = 0;
        int index = start;
        while (index + 1 < len) {
            if (this.siblings(word, index)) {
                ++sequenceLength;
            } else {
                return sequenceLength;
            }
            ++index;
        }
        return sequenceLength;
    }
}

