/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.AmqpInterceptor;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPRoutingHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ExtCapability;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionImpl;
import org.apache.activemq.artemis.protocol.amqp.sasl.MechanismFinder;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASLFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.engine.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPConnectionCallback
implements FailureListener,
CloseListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConcurrentMap<Binary, Transaction> transactions = new ConcurrentHashMap<Binary, Transaction>();
    private final ProtonProtocolManager manager;
    private final org.apache.activemq.artemis.spi.core.remoting.Connection connection;
    protected ActiveMQProtonRemotingConnection protonConnectionDelegate;
    protected AMQPConnectionContext amqpConnection;
    private final Executor sessionExecutor;
    private String remoteContainerId;
    private AtomicBoolean registeredConnectionId = new AtomicBoolean(false);
    private ActiveMQServer server;
    private final String[] saslMechanisms;

    public AMQPConnectionCallback(ProtonProtocolManager manager, org.apache.activemq.artemis.spi.core.remoting.Connection connection, Executor sessionExecutor, ActiveMQServer server) {
        this.manager = manager;
        this.connection = connection;
        this.sessionExecutor = sessionExecutor;
        this.server = server;
        this.saslMechanisms = manager.getSaslMechanisms();
    }

    public org.apache.activemq.artemis.spi.core.remoting.Connection getTransportConnection() {
        return this.connection;
    }

    public String[] getSaslMechanisms() {
        return this.saslMechanisms;
    }

    public ServerSASL getServerSASL(String mechanism) {
        ServerSASL result = null;
        if (this.isPermittedMechanism(mechanism)) {
            ServerSASLFactory factory = MechanismFinder.getFactory(mechanism);
            if (factory != null) {
                result = factory.create(this.server, (ProtocolManager<AmqpInterceptor, AMQPRoutingHandler>)this.manager, this.connection, (RemotingConnection)this.protonConnectionDelegate);
            } else {
                logger.debug("Mo matching mechanism found for: {}", (Object)mechanism);
            }
        }
        return result;
    }

    private boolean isPermittedMechanism(String mechanism) {
        if (this.saslMechanisms == null || this.saslMechanisms.length == 0) {
            return "ANONYMOUS".equals(mechanism);
        }
        for (String candidate : this.saslMechanisms) {
            if (!candidate.equals(mechanism)) continue;
            return true;
        }
        return false;
    }

    public boolean isSupportsAnonymous() {
        boolean supportsAnonymous = false;
        try {
            this.server.getSecurityStore().authenticate(null, null, (RemotingConnection)this.protonConnectionDelegate);
            supportsAnonymous = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supportsAnonymous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.registeredConnectionId.getAndSet(false)) {
                this.server.removeClientConnection(this.remoteContainerId);
            }
            this.connection.close();
            this.amqpConnection.close(null);
        }
        finally {
            for (Transaction tx : this.transactions.values()) {
                try {
                    tx.rollback();
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void setConnection(AMQPConnectionContext connection) {
        this.amqpConnection = connection;
    }

    public AMQPConnectionContext getConnection() {
        return this.amqpConnection;
    }

    public ActiveMQProtonRemotingConnection getProtonConnectionDelegate() {
        return this.protonConnectionDelegate;
    }

    public void setProtonConnectionDelegate(ActiveMQProtonRemotingConnection protonConnectionDelegate) {
        this.protonConnectionDelegate = protonConnectionDelegate;
    }

    public void onTransport(ByteBuf byteBuf, AMQPConnectionContext amqpConnection) {
        this.connection.write((ActiveMQBuffer)new ChannelBufferWrapper(byteBuf, true));
    }

    public boolean isWritable(ReadyListener readyListener) {
        return this.connection.isWritable(readyListener);
    }

    public AMQPSessionCallback createSessionCallback(AMQPConnectionContext connection) {
        return new AMQPSessionCallback(this, this.manager, connection, this.connection, this.sessionExecutor, this.server.newOperationContext());
    }

    public void sendSASLSupported() {
        this.connection.write(ActiveMQBuffers.wrappedBuffer((byte[])new byte[]{65, 77, 81, 80, 3, 1, 0, 0}));
    }

    public boolean validateConnection(Connection connection, SASLResult saslResult) {
        this.remoteContainerId = connection.getRemoteContainer();
        boolean idOK = this.server.addClientConnection(this.remoteContainerId, ExtCapability.needUniqueConnection(connection));
        if (!idOK) {
            HashMap<Symbol, String> connProp = new HashMap<Symbol, String>();
            connProp.put(AmqpSupport.CONNECTION_OPEN_FAILED, "true");
            connection.setProperties(connProp);
            connection.getCondition().setCondition(AmqpError.INVALID_FIELD);
            HashMap<Symbol, Symbol> info = new HashMap<Symbol, Symbol>();
            info.put(AmqpSupport.INVALID_FIELD, AmqpSupport.CONTAINER_ID);
            connection.getCondition().setInfo(info);
            return false;
        }
        this.registeredConnectionId.set(true);
        return true;
    }

    public void connectionClosed() {
        this.close();
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        this.close();
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
        this.close();
    }

    public Binary newTransaction() {
        XidImpl xid = this.newXID();
        Binary binary = new Binary(xid.getGlobalTransactionId());
        ProtonTransactionImpl transaction = new ProtonTransactionImpl((Xid)xid, this.server.getStorageManager(), -1, this.amqpConnection);
        this.transactions.put(binary, (Transaction)transaction);
        return binary;
    }

    public Transaction getTransaction(Binary txid, boolean remove) throws ActiveMQAMQPException {
        Transaction tx = remove ? (Transaction)this.transactions.remove(txid) : (Transaction)this.transactions.get(txid);
        if (tx == null) {
            logger.warn("Couldn't find txid = {}", (Object)txid);
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.txNotFound(txid.toString());
        }
        return tx;
    }

    protected XidImpl newXID() {
        return this.newXID(UUIDGenerator.getInstance().generateStringUUID().getBytes());
    }

    protected XidImpl newXID(byte[] bytes) {
        return new XidImpl("amqp".getBytes(), 1, bytes);
    }

    public URI getFailoverList() {
        TopologyMemberImpl member;
        ClusterManager clusterManager = this.server.getClusterManager();
        ClusterConnection clusterConnection = clusterManager.getDefaultConnection(null);
        if (clusterConnection != null && (member = clusterConnection.getTopology().getMember(this.server.getNodeID().toString())) != null) {
            return member.toBackupURI();
        }
        return null;
    }

    public String invokeIncomingInterceptors(AMQPMessage message, ActiveMQProtonRemotingConnection connection) {
        return this.manager.invokeIncoming(message, connection);
    }

    public String invokeOutgoingInterceptors(AMQPMessage message, ActiveMQProtonRemotingConnection connection) {
        return this.manager.invokeOutgoing(message, connection);
    }
}

