/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import org.apache.lucene.index.SortedSetDocValues;

public abstract class TextMultiValues {
    public static final TextMultiValues EMPTY = new TextMultiValues(){

        @Override
        public boolean advanceExact(int doc) {
            return false;
        }

        @Override
        public boolean hasNextValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long nextOrd() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getValueCount() {
            return 0L;
        }
    };

    protected TextMultiValues() {
    }

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract boolean hasNextValue() throws IOException;

    public abstract long nextOrd() throws IOException;

    public abstract long getValueCount();

    public static TextMultiValues fromDocValues(SortedSetDocValues docValues) {
        return new DocValuesTextMultiValues(docValues);
    }

    protected static class DocValuesTextMultiValues
    extends TextMultiValues {
        protected final SortedSetDocValues values;
        private int remaining;

        DocValuesTextMultiValues(SortedSetDocValues values) {
            this.values = values;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            boolean found = this.values.advanceExact(doc);
            this.updateRemaining(found);
            return found;
        }

        protected final void updateRemaining(boolean hasDocValue) {
            this.remaining = hasDocValue ? this.values.docValueCount() : 0;
        }

        @Override
        public boolean hasNextValue() throws IOException {
            return this.remaining > 0;
        }

        @Override
        public long nextOrd() throws IOException {
            --this.remaining;
            return this.values.nextOrd();
        }

        @Override
        public long getValueCount() {
            return this.values.getValueCount();
        }
    }
}

