/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.security;

import jakarta.resource.spi.security.PasswordCredential;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ElytronCallbackHandler
implements CallbackHandler,
Serializable {
    private final SecurityDomain securityDomain;
    private final org.jboss.jca.core.spi.security.Callback mappings;
    private Subject executionSubject;

    public ElytronCallbackHandler(SecurityDomain securityDomain, org.jboss.jca.core.spi.security.Callback mappings) {
        this.securityDomain = securityDomain;
        this.mappings = mappings;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        SecurityIdentity subjectIdentity;
        if (ConnectorLogger.SUBSYSTEM_RA_LOGGER.isTraceEnabled()) {
            ConnectorLogger.SUBSYSTEM_RA_LOGGER.elytronHandlerHandle(Arrays.toString(callbacks));
        }
        if (this.executionSubject != null && (subjectIdentity = this.getPrivateCredential(this.executionSubject, SecurityIdentity.class)) != null && !subjectIdentity.isAnonymous()) {
            return;
        }
        if (callbacks != null && callbacks.length > 0) {
            if (this.mappings != null && this.mappings.isMappingRequired()) {
                callbacks = this.mappings.mapCallbacks(callbacks);
            }
            GroupPrincipalCallback groupPrincipalCallback = null;
            CallerPrincipalCallback callerPrincipalCallback = null;
            PasswordValidationCallback passwordValidationCallback = null;
            for (Callback callback : callbacks) {
                if (callback instanceof GroupPrincipalCallback) {
                    groupPrincipalCallback = (GroupPrincipalCallback)callback;
                    if (this.executionSubject == null) {
                        this.executionSubject = groupPrincipalCallback.getSubject();
                        continue;
                    }
                    if (this.executionSubject.equals(groupPrincipalCallback.getSubject())) continue;
                    continue;
                }
                if (callback instanceof CallerPrincipalCallback) {
                    callerPrincipalCallback = (CallerPrincipalCallback)callback;
                    if (this.executionSubject == null) {
                        this.executionSubject = callerPrincipalCallback.getSubject();
                        continue;
                    }
                    if (this.executionSubject.equals(callerPrincipalCallback.getSubject())) continue;
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    passwordValidationCallback = (PasswordValidationCallback)callback;
                    if (this.executionSubject == null) {
                        this.executionSubject = passwordValidationCallback.getSubject();
                        continue;
                    }
                    if (this.executionSubject.equals(passwordValidationCallback.getSubject())) continue;
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            this.handleInternal(callerPrincipalCallback, groupPrincipalCallback, passwordValidationCallback);
        }
    }

    protected void handleInternal(CallerPrincipalCallback callerPrincipalCallback, GroupPrincipalCallback groupPrincipalCallback, PasswordValidationCallback passwordValidationCallback) throws IOException {
        if (this.executionSubject == null) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.executionSubjectNotSetInHandler();
        }
        SecurityIdentity identity = this.securityDomain.getAnonymousSecurityIdentity();
        NamePrincipal callerPrincipal = null;
        if (callerPrincipalCallback != null) {
            Principal callbackPrincipal = callerPrincipalCallback.getPrincipal();
            Object object = callbackPrincipal != null ? new NamePrincipal(callbackPrincipal.getName()) : (callerPrincipal = callerPrincipalCallback.getName() != null ? new NamePrincipal(callerPrincipalCallback.getName()) : null);
        }
        if (callerPrincipal != null) {
            String[] groups;
            if (passwordValidationCallback != null) {
                String username = passwordValidationCallback.getUsername();
                char[] password = passwordValidationCallback.getPassword();
                try {
                    identity = this.authenticate(username, password);
                    this.addPrivateCredential(this.executionSubject, new PasswordCredential(username, password));
                    passwordValidationCallback.setResult(true);
                }
                catch (SecurityException e) {
                    passwordValidationCallback.setResult(false);
                    return;
                }
            } else {
                PasswordCredential passwordCredential = this.getPrivateCredential(this.executionSubject, PasswordCredential.class);
                if (passwordCredential != null) {
                    try {
                        identity = this.authenticate(passwordCredential.getUserName(), passwordCredential.getPassword());
                    }
                    catch (SecurityException e) {
                        return;
                    }
                } else {
                    identity = this.securityDomain.createAdHocIdentity((Principal)callerPrincipal);
                }
            }
            if (!callerPrincipal.equals(identity.getPrincipal())) {
                identity = identity.createRunAsIdentity(callerPrincipal.getName());
            }
            if (groupPrincipalCallback != null && (groups = groupPrincipalCallback.getGroups()) != null) {
                HashSet<String> roles = new HashSet<String>(Arrays.asList(groups));
                identity = identity.withRoleMapper("ejb", RoleMapper.constant((Roles)Roles.fromSet(roles)));
            }
        }
        this.executionSubject.getPrincipals().add(identity.getPrincipal());
        this.addPrivateCredential(this.executionSubject, identity);
    }

    /*
     * Unable to fully structure code
     */
    private SecurityIdentity authenticate(String username, char[] credential) throws IOException {
        context = this.securityDomain.createNewAuthenticationContext();
        evidence = new PasswordGuessEvidence((char[])(credential != null ? credential : null));
        try {
            context.setAuthenticationName(username);
            if (!context.verifyEvidence((Evidence)evidence)) ** GOTO lbl13
            if (context.authorize()) {
                context.succeed();
                var5_5 = context.getAuthorizedIdentity();
                return var5_5;
            }
            try {
                context.fail();
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.authorizationFailed();
lbl13:
                // 1 sources

                context.fail();
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.authorizationFailed();
            }
            catch (IllegalArgumentException | IllegalStateException | RealmUnavailableException e) {
                context.fail();
                throw e;
            }
        }
        finally {
            if (!context.isDone()) {
                context.fail();
            }
            evidence.destroy();
        }
    }

    protected <T> T getPrivateCredential(Subject subject, Class<T> credentialClass) {
        Set credentialSet;
        T credential = null;
        if (subject != null && !(credentialSet = !WildFlySecurityManager.isChecking() ? subject.getPrivateCredentials(credentialClass) : AccessController.doPrivileged(() -> subject.getPrivateCredentials(credentialClass))).isEmpty()) {
            credential = (T)credentialSet.iterator().next();
        }
        return credential;
    }

    protected void addPrivateCredential(Subject subject, Object credential) {
        if (!WildFlySecurityManager.isChecking()) {
            subject.getPrivateCredentials().add(credential);
        } else {
            AccessController.doPrivileged(() -> {
                subject.getPrivateCredentials().add(credential);
                return null;
            });
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ElytronCallbackHandler@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[mappings=").append(this.mappings);
        sb.append("]");
        return sb.toString();
    }
}

