/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.hibernate.search.backend.elasticsearch.reporting.impl.ElasticsearchEventContexts;
import org.hibernate.search.backend.elasticsearch.reporting.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextElement;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.AssertionFailure;

public final class ValidationErrorCollector {
    private final Deque<ValidationContextElement> currentContext = new ArrayDeque<ValidationContextElement>();
    private final ContextualFailureCollector failureCollector;
    private boolean hasError = false;

    public ValidationErrorCollector() {
        this.failureCollector = null;
    }

    public ValidationErrorCollector(ContextualFailureCollector failureCollector) {
        this.failureCollector = failureCollector;
    }

    void push(ValidationContextType contextType, String name) {
        this.currentContext.addLast(new ValidationContextElement(contextType, name));
    }

    String getCurrentName() {
        return this.currentContext.getLast().getName();
    }

    void pop() {
        this.currentContext.removeLast();
    }

    void addError(String errorMessage) {
        if (this.failureCollector != null) {
            if (!this.hasError) {
                this.failureCollector.add(ElasticsearchValidationMessages.INSTANCE.validationFailed());
            }
            this.appendContext(this.failureCollector, this.currentContext).add(errorMessage);
        }
        this.hasError = true;
    }

    public boolean hasError() {
        return this.hasError;
    }

    private ContextualFailureCollector appendContext(ContextualFailureCollector failureCollector, Iterable<ValidationContextElement> contextElements) {
        Iterator<ValidationContextElement> iterator = contextElements.iterator();
        if (!iterator.hasNext()) {
            return failureCollector;
        }
        ContextualFailureCollector result = failureCollector;
        StringBuilder pathBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            result = this.appendContext(result, iterator.next(), pathBuilder, iterator.hasNext());
        }
        return result;
    }

    private ContextualFailureCollector appendContext(ContextualFailureCollector currentResult, ValidationContextElement element, StringBuilder pathBuilder, boolean hasNext) {
        ValidationContextType type = element.getType();
        String name = element.getName();
        if (ValidationContextType.MAPPING_PROPERTY.equals((Object)type)) {
            if (pathBuilder.length() > 0) {
                pathBuilder.append(".");
            }
            pathBuilder.append(name);
            if (!hasNext) {
                return currentResult.withContext(EventContexts.fromIndexFieldAbsolutePath((String)pathBuilder.toString()));
            }
            return currentResult;
        }
        if (pathBuilder.length() > 0) {
            currentResult = currentResult.withContext(EventContexts.fromIndexFieldAbsolutePath((String)pathBuilder.toString()));
            pathBuilder.setLength(0);
        }
        switch (type) {
            case ALIAS: {
                return currentResult.withContext(ElasticsearchEventContexts.fromAliasDefinition(name));
            }
            case ALIAS_ATTRIBUTE: {
                return currentResult.withContext(ElasticsearchEventContexts.fromAliasDefinitionAttribute(name));
            }
            case MAPPING_ATTRIBUTE: {
                return currentResult.withContext(ElasticsearchEventContexts.fromMappingAttribute(name));
            }
            case ANALYZER: {
                return currentResult.withContext(EventContexts.fromAnalyzer((String)name));
            }
            case NORMALIZER: {
                return currentResult.withContext(EventContexts.fromNormalizer((String)name));
            }
            case CHAR_FILTER: {
                return currentResult.withContext(EventContexts.fromCharFilter((String)name));
            }
            case TOKENIZER: {
                return currentResult.withContext(EventContexts.fromTokenizer((String)name));
            }
            case TOKEN_FILTER: {
                return currentResult.withContext(EventContexts.fromTokenFilter((String)name));
            }
            case ANALYSIS_DEFINITION_PARAMETER: {
                return currentResult.withContext(ElasticsearchEventContexts.fromAnalysisDefinitionParameter(name));
            }
            case DYNAMIC_TEMPLATE: {
                return currentResult.withContext(EventContexts.fromFieldTemplateAbsolutePath((String)name));
            }
            case DYNAMIC_TEMPLATE_ATTRIBUTE: {
                return currentResult.withContext(ElasticsearchEventContexts.fromFieldTemplateAttribute(name));
            }
            case CUSTOM_INDEX_SETTINGS_ATTRIBUTE: {
                return currentResult.withContext(ElasticsearchEventContexts.fromCustomIndexSettingAttribute(name));
            }
            case CUSTOM_INDEX_MAPPING_ATTRIBUTE: {
                return currentResult.withContext(ElasticsearchEventContexts.fromCustomIndexMappingAttribute(name));
            }
        }
        throw new AssertionFailure("Unexpected validation context element type: " + type);
    }
}

