/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.InstMgrOperationStepHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public class InstMgrCleanHandler
extends InstMgrOperationStepHandler {
    static final String OPERATION_NAME = "clean";
    protected static final AttributeDefinition LIST_UPDATES_WORK_DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"work-dir", (ModelType)ModelType.STRING).setRequired(false)).setStorageRuntime()).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("clean", InstMgrResolver.RESOLVER).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY}).addParameter(LIST_UPDATES_WORK_DIR).setRuntimeOnly().build();

    InstMgrCleanHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String listUpdatesWorkDir = LIST_UPDATES_WORK_DIR.resolveModelAttribute(context, operation).asStringOrNull();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.acquireControllerLock();
                try {
                    if (listUpdatesWorkDir != null) {
                        InstMgrCleanHandler.this.imService.deleteTempDir(listUpdatesWorkDir);
                    } else {
                        InstMgrCleanHandler.this.deleteDirIfExits(InstMgrCleanHandler.this.imService.getPreparedServerDir());
                        InstMgrCleanHandler.this.imService.deleteTempDirs();
                        InstMgrCleanHandler.this.imService.resetCandidateStatus();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

