/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.jboss.as.controller.ControlledProcessStateService;

public class ControlledProcessState {
    private final AtomicInteger stamp = new AtomicInteger(0);
    private final AtomicStampedReference<State> state = new AtomicStampedReference<State>(State.STARTING, 0);
    private final boolean reloadSupported;
    private final ControlledProcessStateService service;
    private boolean restartRequiredFlag = false;
    private boolean reloadRequiredOnStarting = false;
    private boolean restartRequiredOnStarting = false;

    public ControlledProcessState(boolean reloadSupported) {
        this.reloadSupported = reloadSupported;
        this.service = new ControlledProcessStateService(State.STOPPED);
    }

    public State getState() {
        return this.state.getReference();
    }

    public boolean isReloadSupported() {
        return this.reloadSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStarting() {
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            this.state.set(State.STARTING, this.stamp.incrementAndGet());
            this.service.stateChanged(State.STARTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning() {
        State was;
        int newStamp = this.stamp.incrementAndGet();
        int[] receiver = new int[1];
        while ((was = this.state.get(receiver)) == State.STARTING) {
            ControlledProcessStateService controlledProcessStateService = this.service;
            synchronized (controlledProcessStateService) {
                int stamp;
                State newState = this.restartRequiredOnStarting ? State.RESTART_REQUIRED : (this.reloadRequiredOnStarting ? State.RELOAD_REQUIRED : (this.restartRequiredFlag ? State.RESTART_REQUIRED : State.RUNNING));
                int n = stamp = this.restartRequiredOnStarting || this.reloadRequiredOnStarting ? receiver[0] : newStamp;
                if (this.state.compareAndSet(was, newState, receiver[0], stamp)) {
                    this.restartRequiredOnStarting = false;
                    this.reloadRequiredOnStarting = false;
                    this.service.stateChanged(newState);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopping() {
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            this.restartRequiredOnStarting = false;
            this.reloadRequiredOnStarting = false;
            this.state.set(State.STOPPING, this.stamp.incrementAndGet());
            this.service.stateChanged(State.STOPPING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopped() {
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            this.restartRequiredOnStarting = false;
            this.reloadRequiredOnStarting = false;
            this.state.set(State.STOPPED, this.stamp.incrementAndGet());
            this.service.stateChanged(State.STOPPED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setReloadRequired() {
        int result;
        if (!this.reloadSupported) {
            return this.setRestartRequired();
        }
        int newStamp = this.stamp.incrementAndGet();
        int[] receiver = new int[1];
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            State was = this.state.get(receiver);
            if (was == State.STARTING) {
                this.reloadRequiredOnStarting = true;
                result = receiver[0];
            } else if (was != State.STOPPING && was != State.RESTART_REQUIRED && this.state.compareAndSet(was, State.RELOAD_REQUIRED, receiver[0], newStamp)) {
                this.service.stateChanged(State.RELOAD_REQUIRED);
                result = newStamp;
            } else {
                result = newStamp;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setRestartRequired() {
        int result;
        int newStamp = this.stamp.incrementAndGet();
        int[] receiver = new int[1];
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            State was = this.state.get(receiver);
            if (was == State.STARTING) {
                this.restartRequiredOnStarting = true;
                this.restartRequiredFlag = true;
                result = receiver[0];
            } else if (was != State.STOPPING && this.state.compareAndSet(was, State.RESTART_REQUIRED, receiver[0], newStamp)) {
                this.restartRequiredFlag = true;
                this.service.stateChanged(State.RESTART_REQUIRED);
                result = newStamp;
            } else {
                result = newStamp;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertReloadRequired(Object stamp) {
        if (!this.reloadSupported) {
            this.revertRestartRequired(stamp);
        }
        Integer theirStamp = (Integer)Integer.class.cast(stamp);
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            if (this.reloadRequiredOnStarting) {
                this.reloadRequiredOnStarting = false;
            } else if (this.state.compareAndSet(State.RELOAD_REQUIRED, State.RUNNING, theirStamp, this.stamp.incrementAndGet())) {
                this.service.stateChanged(State.RUNNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertRestartRequired(Object stamp) {
        Integer theirStamp = (Integer)Integer.class.cast(stamp);
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            if (this.restartRequiredOnStarting) {
                this.restartRequiredOnStarting = false;
                this.restartRequiredFlag = false;
            } else if (this.state.compareAndSet(State.RESTART_REQUIRED, State.RUNNING, theirStamp, this.stamp.incrementAndGet())) {
                this.restartRequiredFlag = false;
                this.service.stateChanged(State.RUNNING);
            }
        }
    }

    ControlledProcessStateService getService() {
        return this.service;
    }

    boolean checkRestartRequired() {
        return this.restartRequiredFlag;
    }

    public static enum State {
        STARTING("starting", false),
        RUNNING("running", true),
        RELOAD_REQUIRED("reload-required", true),
        RESTART_REQUIRED("restart-required", true),
        STOPPING("stopping", false),
        STOPPED("stopped", false);

        private final String stringForm;
        private final boolean running;

        private State(String stringForm, boolean running) {
            this.stringForm = stringForm;
            this.running = running;
        }

        public boolean isRunning() {
            return this.running;
        }

        public String toString() {
            return this.stringForm;
        }
    }
}

