/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.version;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public enum Stability {
    DEFAULT("default"),
    COMMUNITY("community"),
    PREVIEW("preview"),
    EXPERIMENTAL("experimental");

    private final String value;

    public static Stability fromString(String value) {
        return Enum.valueOf(Stability.class, value.toUpperCase(Locale.ENGLISH));
    }

    private Stability(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public boolean enables(Stability stability) {
        return stability.ordinal() <= this.ordinal();
    }

    public static <F> Map<Stability, F> map(Function<Stability, F> features) {
        EnumMap<Stability, Object> map = new EnumMap<Stability, Object>(Stability.class);
        Object lastStability = null;
        for (Stability stability : EnumSet.allOf(Stability.class)) {
            F feature = features.apply(stability);
            if (feature != null) {
                lastStability = feature;
            }
            if (lastStability == null) continue;
            map.put(stability, lastStability);
        }
        return Collections.unmodifiableMap(map);
    }
}

