/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service.descriptor;

import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.ServiceDescriptor;

public interface TernaryServiceDescriptor<T>
extends ServiceDescriptor<T> {
    default public Map.Entry<String, String[]> resolve(String grandparent, String parent, String child) {
        return Map.entry(this.getName(), new String[]{(String)Assert.checkNotNullParamWithNullPointerException((String)"grandparent", (Object)grandparent), (String)Assert.checkNotNullParamWithNullPointerException((String)"parent", (Object)parent), (String)Assert.checkNotNullParamWithNullPointerException((String)"child", (Object)child)});
    }

    @Override
    default public <U extends T> TernaryServiceDescriptor<U> asType(final Class<U> type) {
        return new TernaryServiceDescriptor<U>(){

            @Override
            public String getName() {
                return TernaryServiceDescriptor.this.getName();
            }

            @Override
            public Class<U> getType() {
                return type;
            }

            @Override
            public Map.Entry<String, String[]> resolve(String grandparent, String parent, String child) {
                return TernaryServiceDescriptor.this.resolve(grandparent, parent, child);
            }
        };
    }

    public static <T> TernaryServiceDescriptor<T> of(final String name, final Class<T> type) {
        return new TernaryServiceDescriptor<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Class<T> getType() {
                return type;
            }
        };
    }

    public static <T> TernaryServiceDescriptor<T> of(final String name, final BinaryServiceDescriptor<T> defaultDescriptor) {
        return new TernaryServiceDescriptor<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Class<T> getType() {
                return defaultDescriptor.getType();
            }

            @Override
            public Map.Entry<String, String[]> resolve(String grandparent, String parent, String child) {
                return child != null ? TernaryServiceDescriptor.super.resolve(grandparent, parent, child) : defaultDescriptor.resolve(grandparent, parent);
            }
        };
    }

    public static interface Provider<T>
    extends ServiceDescriptor.Provider<T, TernaryServiceDescriptor<T>>,
    TernaryServiceDescriptor<T> {
        @Override
        default public Map.Entry<String, String[]> resolve(String grandparent, String parent, String child) {
            return ((TernaryServiceDescriptor)this.get()).resolve(grandparent, parent, child);
        }
    }
}

