/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.glassfish.soteria.cdi.AnyAnnotationLiteral;
import org.glassfish.soteria.cdi.CdiExtension;
import org.glassfish.soteria.cdi.DefaultAnnotationLiteral;

public class CdiProducer<T>
implements Bean<T>,
PassivationCapable {
    private String id = this.getClass().getName();
    private String name;
    private Class<?> beanClass = CdiExtension.class;
    private Set<Type> types = Collections.singleton(Object.class);
    private Set<Annotation> qualifiers = Collections.unmodifiableSet(CdiProducer.asSet(new AnnotationLiteral[]{new DefaultAnnotationLiteral(), new AnyAnnotationLiteral()}));
    private Class<? extends Annotation> scope = Dependent.class;
    private Function<CreationalContext<T>, T> create;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public T create(CreationalContext<T> creationalContext) {
        return this.create.apply(creationalContext);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    protected CdiProducer<T> active(boolean active) {
        return this;
    }

    protected CdiProducer<T> name(String name) {
        this.name = name;
        return this;
    }

    protected CdiProducer<T> create(Function<CreationalContext<T>, T> create) {
        this.create = create;
        return this;
    }

    protected CdiProducer<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    protected CdiProducer<T> types(Type ... types) {
        this.types = CdiProducer.asSet(types);
        return this;
    }

    protected CdiProducer<T> beanClassAndType(Class<?> beanClass) {
        this.beanClass(beanClass);
        this.types(beanClass);
        return this;
    }

    protected CdiProducer<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers = CdiProducer.asSet(qualifiers);
        return this;
    }

    protected CdiProducer<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    protected CdiProducer<T> addToId(Object object) {
        this.id = this.id + " " + object.toString();
        return this;
    }

    @SafeVarargs
    protected static <T> Set<T> asSet(T ... a) {
        return new HashSet<T>(Arrays.asList(a));
    }
}

