/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.lang.reflect.Array;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.ConvertedBasicArrayType;
import org.hibernate.type.descriptor.converter.internal.ArrayConverter;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractArrayJavaType<T, E>
extends AbstractClassJavaType<T>
implements BasicPluralJavaType<E> {
    private final JavaType<E> componentJavaType;

    public AbstractArrayJavaType(Class<T> clazz, JavaType<E> baseDescriptor, MutabilityPlan<T> mutabilityPlan) {
        super(clazz, mutabilityPlan);
        this.componentJavaType = baseDescriptor;
    }

    @Override
    public JavaType<E> getElementJavaType() {
        return this.componentJavaType;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getTypeConfiguration().getJdbcTypeRegistry().resolveTypeConstructorDescriptor(indicators.getPreferredSqlTypeCodeForArray(), new BasicTypeImpl<E>(this.componentJavaType, this.componentJavaType.getRecommendedJdbcType(indicators)), ColumnTypeInformation.EMPTY);
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return this == javaType || this.componentJavaType == javaType;
    }

    @Override
    public BasicType<?> resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<E> elementType, ColumnTypeInformation columnTypeInformation, JdbcTypeIndicators stdIndicators) {
        Class<E> elementJavaTypeClass = elementType.getJavaTypeDescriptor().getJavaTypeClass();
        if (elementType instanceof BasicPluralType || elementJavaTypeClass != null && elementJavaTypeClass.isArray()) {
            return null;
        }
        BasicValueConverter<E, ?> valueConverter = elementType.getValueConverter();
        return valueConverter == null ? this.resolveType(typeConfiguration, dialect, this, elementType, columnTypeInformation, stdIndicators) : this.createTypeUsingConverter(typeConfiguration, dialect, elementType, columnTypeInformation, stdIndicators, valueConverter);
    }

    <F> BasicType<T> createTypeUsingConverter(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<E> elementType, ColumnTypeInformation columnTypeInformation, JdbcTypeIndicators stdIndicators, BasicValueConverter<E, F> valueConverter) {
        Class<F> convertedElementClass = valueConverter.getRelationalJavaType().getJavaTypeClass();
        Class<?> convertedArrayClass = Array.newInstance(convertedElementClass, 0).getClass();
        JavaType relationalJavaType = typeConfiguration.getJavaTypeRegistry().getDescriptor(convertedArrayClass);
        return new ConvertedBasicArrayType(elementType, typeConfiguration.getJdbcTypeRegistry().resolveTypeConstructorDescriptor((int)stdIndicators.getExplicitJdbcTypeCode(), elementType, columnTypeInformation), this, new ArrayConverter(valueConverter, this, relationalJavaType));
    }

    BasicType<T> resolveType(TypeConfiguration typeConfiguration, Dialect dialect, AbstractArrayJavaType<T, E> arrayJavaType, BasicType<E> elementType, ColumnTypeInformation columnTypeInformation, JdbcTypeIndicators stdIndicators) {
        JdbcType arrayJdbcType = typeConfiguration.getJdbcTypeRegistry().resolveTypeConstructorDescriptor((int)stdIndicators.getExplicitJdbcTypeCode(), elementType, columnTypeInformation);
        return typeConfiguration.getBasicTypeRegistry().resolve(arrayJavaType, arrayJdbcType, () -> new BasicArrayType(elementType, arrayJdbcType, arrayJavaType));
    }
}

