/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Formatter;
import org.jboss.logmanager.formatters.Formatters;
import org.jboss.logmanager.handlers.UncloseableOutputStream;
import org.jboss.logmanager.handlers.UninterruptibleOutputStream;
import org.jboss.logmanager.handlers.WriterHandler;

public class OutputStreamHandler
extends WriterHandler {
    private OutputStream outputStream;
    private Charset charset;

    public OutputStreamHandler() {
        this.setFormatter(Formatters.nullFormatter());
    }

    public OutputStreamHandler(Formatter formatter) {
        this.setFormatter(formatter);
    }

    public OutputStreamHandler(OutputStream outputStream, Formatter formatter) {
        this.setFormatter(formatter);
        this.setOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncoding() {
        Object object = this.outputLock;
        synchronized (object) {
            return super.getEncoding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        Object object = this.outputLock;
        synchronized (object) {
            this.charset = encoding == null ? null : Charset.forName(encoding);
            super.setEncoding(encoding);
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                super.setWriter(this.getNewWriter(outputStream));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWriter(Writer writer) {
        Object object = this.outputLock;
        synchronized (object) {
            super.setWriter(writer);
            OutputStream oldStream = this.outputStream;
            this.outputStream = null;
            this.safeFlush(oldStream);
            this.safeClose(oldStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            this.setWriter(null);
            return;
        }
        OutputStreamHandler.checkAccess(this);
        try {
            Object object = this.outputLock;
            synchronized (object) {
                OutputStream oldStream = this.outputStream;
                Writer writer = this.getNewWriter(outputStream);
                try {
                    this.outputStream = outputStream;
                    super.setWriter(writer);
                }
                finally {
                    this.safeFlush(oldStream);
                    this.safeClose(oldStream);
                }
            }
        }
        catch (Exception e) {
            this.reportError("Error opening output stream", e, 4);
            return;
        }
    }

    private Writer getNewWriter(OutputStream newOutputStream) {
        if (newOutputStream == null) {
            return null;
        }
        UninterruptibleOutputStream outputStream = new UninterruptibleOutputStream(new UncloseableOutputStream(newOutputStream));
        Charset charset = this.charset;
        return charset == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, charset);
    }
}

