/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceNodeStore;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.apache.activemq.artemis.utils.collections.NodeStoreFactory;

public class ReferenceIDSupplier
implements NodeStoreFactory<MessageReference> {
    final ActiveMQServer server;
    private final String serverID;

    public ReferenceIDSupplier(ActiveMQServer server) {
        this.server = server;
        this.serverID = server.getNodeID().toString();
    }

    public NodeStore<MessageReference> newNodeStore() {
        return new ReferenceNodeStore(this);
    }

    public String getDefaultNodeID() {
        return this.serverID;
    }

    public String getServerID(MessageReference element) {
        return this.getServerID(element.getMessage());
    }

    public String getServerID(Message message) {
        Object nodeID = message.getBrokerProperty(AMQPMirrorControllerSource.INTERNAL_BROKER_ID_EXTRA_PROPERTY);
        if (nodeID != null) {
            return nodeID.toString();
        }
        return null;
    }

    public long getID(MessageReference element) {
        Message message = element.getMessage();
        Long id = this.getID(message);
        if (id == null) {
            return element.getMessageID();
        }
        return id;
    }

    private Long getID(Message message) {
        return (Long)message.getBrokerProperty(AMQPMirrorControllerSource.INTERNAL_ID_EXTRA_PROPERTY);
    }
}

