/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyHandler;

class LocalCacheStatus {
    private final CacheJoinInfo joinInfo;
    private final CacheTopologyHandler handler;
    private final PartitionHandlingManager partitionHandlingManager;
    private final CompletableFuture<Boolean> stable;
    private final int stableMembersSize;
    private volatile List<Address> knownMembers;
    private volatile CacheTopology currentTopology;
    private volatile CacheTopology stableTopology;

    LocalCacheStatus(CacheJoinInfo joinInfo, CacheTopologyHandler handler, PartitionHandlingManager phm, int stableMembersSize) {
        this.joinInfo = joinInfo;
        this.handler = handler;
        this.partitionHandlingManager = phm;
        this.stable = new CompletableFuture();
        this.knownMembers = Collections.emptyList();
        this.stableMembersSize = stableMembersSize;
    }

    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public CacheTopologyHandler getHandler() {
        return this.handler;
    }

    public PartitionHandlingManager getPartitionHandlingManager() {
        return this.partitionHandlingManager;
    }

    CacheTopology getCurrentTopology() {
        return this.currentTopology;
    }

    void setCurrentTopology(CacheTopology currentTopology) {
        this.currentTopology = currentTopology;
    }

    CacheTopology getStableTopology() {
        return this.stableTopology;
    }

    void setStableTopology(CacheTopology stableTopology) {
        this.stableTopology = stableTopology;
        this.partitionHandlingManager.onTopologyUpdate(this.currentTopology);
        if (stableTopology != null) {
            this.stable.complete(true);
        }
    }

    List<Address> knownMembers() {
        return Collections.unmodifiableList(this.knownMembers);
    }

    void setCurrentMembers(List<Address> members) {
        this.knownMembers = members;
    }

    CompletionStage<Boolean> getStableTopologyCompletion() {
        return this.stable;
    }

    boolean isStableTopologyRestored() {
        return this.stableMembersSize < 0 || this.stable.isDone() && this.stableTopology != null;
    }

    boolean needRecovery() {
        return this.stableMembersSize > 0;
    }

    int getStableMembersSize() {
        return this.stableMembersSize;
    }
}

