/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneIntegerDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneMonthDayFieldCodec
extends AbstractLuceneNumericFieldCodec<MonthDay, Integer> {
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);

    public LuceneMonthDayFieldCodec(Indexing indexing, DocValues docValues, Storage storage, MonthDay indexNullAsValue) {
        super(indexing, docValues, storage, indexNullAsValue);
    }

    @Override
    void addStoredToDocument(LuceneDocumentContent documentBuilder, String absoluteFieldPath, MonthDay value, Integer encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
    }

    @Override
    public MonthDay decode(IndexableField field) {
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return MonthDay.parse(value, FORMATTER);
    }

    @Override
    public Integer encode(MonthDay value) {
        if (value == null) {
            return null;
        }
        return 100 * value.getMonthValue() + value.getDayOfMonth();
    }

    @Override
    public MonthDay decode(Integer encoded) {
        return MonthDay.of(encoded / 100, encoded % 100);
    }

    @Override
    public LuceneNumericDomain<Integer> getDomain() {
        return LuceneIntegerDomain.get();
    }
}

