/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.KeyMap;
import io.smallrye.config.common.AbstractConfigSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class DefaultValuesConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -6386021034957868328L;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final KeyMap<String> wildcards = new KeyMap();

    public DefaultValuesConfigSource(Map<String, String> properties) {
        this(properties, "DefaultValuesConfigSource", Integer.MIN_VALUE);
    }

    public DefaultValuesConfigSource(Map<String, String> properties, String name, int ordinal) {
        super(name, ordinal);
        this.addDefaults(properties);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public String getValue(String propertyName) {
        String value = this.properties.get(propertyName);
        return value == null && !this.wildcards.isEmpty() ? this.wildcards.findRootValue(propertyName) : value;
    }

    void addDefaults(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey().indexOf(42) == -1) {
                this.properties.putIfAbsent(entry.getKey(), entry.getValue());
                continue;
            }
            KeyMap<String> key = this.wildcards.findOrAdd(entry.getKey());
            if (key.hasRootValue()) continue;
            key.putRootValue(entry.getValue());
        }
    }
}

