/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import java.text.ParseException;
import java.util.Objects;
import org.glassfish.soteria.mechanisms.openid.controller.TokenClaimsSetVerifier;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;

public class IdTokenClaimsSetVerifier
extends TokenClaimsSetVerifier {
    private final String expectedNonceHash;

    public IdTokenClaimsSetVerifier(String expectedNonceHash, OpenIdConfiguration configuration) {
        super(configuration);
        this.expectedNonceHash = expectedNonceHash;
    }

    @Override
    public void verify(JWTClaimsSet claims) throws BadJWTException {
        if (this.configuration.isUseNonce()) {
            String nonce;
            try {
                nonce = claims.getStringClaim("nonce");
            }
            catch (ParseException ex) {
                throw new IllegalStateException("Invalid nonce claim", ex);
            }
            if (Objects.isNull(nonce)) {
                throw new IllegalStateException("Missing nonce claim");
            }
            if (Objects.isNull(this.expectedNonceHash)) {
                throw new IllegalStateException("Missing expected nonce claim");
            }
            if (!this.expectedNonceHash.equals(nonce)) {
                throw new IllegalStateException("Invalid nonce claim : " + nonce);
            }
        }
    }
}

