/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.context.ContextClassLoaderReference;
import org.wildfly.clustering.context.ContextualThreadFactory;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DefaultThreadFactory
extends ContextualThreadFactory<ClassLoader> {
    public DefaultThreadFactory(final Class<?> targetClass) {
        this(targetClass, new Supplier<ThreadGroup>(){

            @Override
            public ThreadGroup get() {
                return new ThreadGroup(targetClass.getSimpleName());
            }
        });
    }

    DefaultThreadFactory(Class<?> targetClass, Supplier<ThreadGroup> group) {
        this((ThreadFactory)WildFlySecurityManager.doUnchecked(group, (ParametricPrivilegedAction)ThreadPoolFactory.INSTANCE), targetClass);
    }

    public DefaultThreadFactory(ThreadFactory factory) {
        this(factory, factory.getClass());
    }

    private DefaultThreadFactory(ThreadFactory factory, Class<?> targetClass) {
        super(factory, WildFlySecurityManager.getClassLoaderPrivileged(targetClass), ContextClassLoaderReference.INSTANCE);
    }

    private static enum ThreadPoolFactory implements ParametricPrivilegedAction<ThreadFactory, Supplier<ThreadGroup>>
    {
        INSTANCE;


        public ThreadFactory run(Supplier<ThreadGroup> group) {
            return new JBossThreadFactory(group.get(), Boolean.FALSE, null, "%G - %t", null, null);
        }
    }
}

