/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.resources.impl;

import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.work.spi.ElasticsearchWorkExecutorProvider;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.execution.spi.DelegatingSimpleScheduledExecutor;
import org.hibernate.search.engine.common.execution.spi.SimpleScheduledExecutor;

public class DefaultElasticsearchWorkExecutorProvider
implements ElasticsearchWorkExecutorProvider {
    public static final String DEFAULT_BEAN_NAME = "es-built-in";
    private static final OptionalConfigurationProperty<Integer> THREAD_POOL_SIZE = ConfigurationProperty.forKey((String)"thread_pool.size").asIntegerStrictlyPositive().build();

    @Override
    public SimpleScheduledExecutor workExecutor(ElasticsearchWorkExecutorProvider.Context context) {
        int threadPoolSize = ((Optional)THREAD_POOL_SIZE.get(context.propertySource())).orElse(Runtime.getRuntime().availableProcessors());
        return new DelegatingSimpleScheduledExecutor(context.threadPoolProvider().newScheduledExecutor(threadPoolSize, context.recommendedThreadNamePrefix()), context.threadPoolProvider().isScheduledExecutorBlocking());
    }
}

