/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.jwt.smallrye;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.microprofile.jwt.smallrye.JwtDeploymentMarker;

class JwtDependencyProcessor
implements DeploymentUnitProcessor {
    private static final String EE_SECURITY_API = "jakarta.security.enterprise.api";
    private static final String MP_JWT_API = "org.eclipse.microprofile.jwt.auth.api";
    private static final String SMALLRYE_JWT = "io.smallrye.jwt";
    private static final String ELYTRON_JWT = "org.wildfly.security.elytron-jwt";

    JwtDependencyProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JwtDeploymentMarker.isJWTDeployment(deploymentUnit)) {
            return;
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, EE_SECURITY_API, false, false, true, false));
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, "org.wildfly.security.jakarta.security", false, false, true, false));
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, MP_JWT_API, false, false, true, false));
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, SMALLRYE_JWT, false, false, true, false));
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, ELYTRON_JWT, false, false, true, false));
    }
}

