/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.logging;

import jakarta.ejb.ConcurrentAccessTimeoutException;
import jakarta.ejb.EJBAccessException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBTransactionRequiredException;
import jakarta.ejb.EJBTransactionRolledbackException;
import jakarta.ejb.IllegalLoopbackException;
import jakarta.ejb.LockType;
import jakarta.ejb.NoMoreTimeoutsException;
import jakarta.ejb.NoSuchEJBException;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.RemoveException;
import jakarta.ejb.Timer;
import jakarta.ejb.TransactionAttributeType;
import jakarta.interceptor.InvocationContext;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.Context;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBComponentUnavailableException;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.InstalledComponent;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.tx.TimerTransactionRolledBackException;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class EjbLogger_$logger
extends DelegatingBasicLogger
implements EjbLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EjbLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public EjbLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void getTxManagerStatusFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.getTxManagerStatusFailed$str(), new Object[0]);
    }

    protected String getTxManagerStatusFailed$str() {
        return "WFLYEJB0004: failed to get tx manager status; ignoring";
    }

    @Override
    public final void setRollbackOnlyFailed(Throwable se) {
        this.log.logf(FQCN, Logger.Level.ERROR, se, this.setRollbackOnlyFailed$str(), new Object[0]);
    }

    protected String setRollbackOnlyFailed$str() {
        return "WFLYEJB0005: failed to set rollback only; ignoring";
    }

    @Override
    public final void activationConfigPropertyIgnored(Object propName, String resourceAdapterName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.activationConfigPropertyIgnored$str(), propName, (Object)resourceAdapterName);
    }

    protected String activationConfigPropertyIgnored$str() {
        return "WFLYEJB0006: ActivationConfigProperty %s will be ignored since it is not allowed by resource adapter: %s";
    }

    @Override
    public final void discardingStatefulComponent(StatefulSessionComponentInstance component, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.discardingStatefulComponent$str(), (Object)component);
    }

    protected String discardingStatefulComponent$str() {
        return "WFLYEJB0007: Discarding stateful component instance: %s due to exception";
    }

    @Override
    public final void defaultInterceptorClassNotListed(String clazz) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.defaultInterceptorClassNotListed$str(), (Object)clazz);
    }

    protected String defaultInterceptorClassNotListed$str() {
        return "WFLYEJB0010: Default interceptor class %s is not listed in the <interceptors> section of ejb-jar.xml and will not be applied";
    }

    @Override
    public final void unknownTimezoneId(String timezoneId, String id) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownTimezoneId$str(), (Object)timezoneId, (Object)id);
    }

    protected String unknownTimezoneId$str() {
        return "WFLYEJB0015: Unknown timezone id: %s found in schedule expression. Ignoring it and using server's timezone: %s";
    }

    @Override
    public final void timerPersistenceNotEnable() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.timerPersistenceNotEnable$str(), new Object[0]);
    }

    protected String timerPersistenceNotEnable$str() {
        return "WFLYEJB0016: Timer persistence is not enabled, persistent timers will not survive JVM restarts";
    }

    @Override
    public final void nextExpirationIsNull(TimerImpl timer) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.nextExpirationIsNull$str(), (Object)timer);
    }

    protected String nextExpirationIsNull$str() {
        return "WFLYEJB0017: Next expiration is null. No tasks will be scheduled for timer %S";
    }

    @Override
    public final void ignoringException(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.ignoringException$str(), new Object[0]);
    }

    protected String ignoringException$str() {
        return "WFLYEJB0018: Ignoring exception during setRollbackOnly";
    }

    @Override
    public final void errorInvokeTimeout(Timer timer, Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorInvokeTimeout$str(), (Object)timer);
    }

    protected String errorInvokeTimeout$str() {
        return "WFLYEJB0020: Error invoking timeout for timer: %s";
    }

    @Override
    public final void timerRetried(Timer timer) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.timerRetried$str(), (Object)timer);
    }

    protected String timerRetried$str() {
        return "WFLYEJB0021: Timer: %s will be retried";
    }

    @Override
    public final void errorDuringRetryTimeout(Timer timer, Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorDuringRetryTimeout$str(), (Object)timer);
    }

    protected String errorDuringRetryTimeout$str() {
        return "WFLYEJB0022: Error during retrying timeout for timer: %s";
    }

    @Override
    public final void retryingTimeout(Timer timer) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.retryingTimeout$str(), (Object)timer);
    }

    protected String retryingTimeout$str() {
        return "WFLYEJB0023: Retrying timeout for timer: %s";
    }

    @Override
    public final void timerNotActive(Timer timer) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.timerNotActive$str(), (Object)timer);
    }

    protected String timerNotActive$str() {
        return "WFLYEJB0024: Timer is not active, skipping retry of timer: %s";
    }

    @Override
    public final void failToReadTimerInformation(String componentName, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failToReadTimerInformation$str(), (Object)componentName);
    }

    protected String failToReadTimerInformation$str() {
        return "WFLYEJB0026: Could not read timer information for Jakarta Enterprise Beans component %s";
    }

    @Override
    public final void failToRestoreTimers(File file) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failToRestoreTimers$str(), (Object)file);
    }

    protected String failToRestoreTimers$str() {
        return "WFLYEJB0028: %s is not a directory, could not restore timers";
    }

    @Override
    public final void failToRestoreTimersFromFile(File timerFile, Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failToRestoreTimersFromFile$str(), (Object)timerFile);
    }

    protected String failToRestoreTimersFromFile$str() {
        return "WFLYEJB0029: Could not restore timer from %s";
    }

    @Override
    public final void failToCloseFile(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failToCloseFile$str(), new Object[0]);
    }

    protected String failToCloseFile$str() {
        return "WFLYEJB0030: error closing file ";
    }

    @Override
    public final void failToRestoreTimersForObjectId(String timedObjectId, Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failToRestoreTimersForObjectId$str(), (Object)timedObjectId);
    }

    protected String failToRestoreTimersForObjectId$str() {
        return "WFLYEJB0031: Could not restore timers for %s";
    }

    @Override
    public final void failToCreateDirectoryForPersistTimers(File file) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failToCreateDirectoryForPersistTimers$str(), (Object)file);
    }

    protected String failToCreateDirectoryForPersistTimers$str() {
        return "WFLYEJB0032: Could not create directory %s to persist Jakarta Enterprise Beans timers.";
    }

    @Override
    public final void invocationFailed(String component, Method method, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.invocationFailed2$str(), (Object)component, (Object)method);
    }

    protected String invocationFailed2$str() {
        return "WFLYEJB0034: Jakarta Enterprise Beans Invocation failed on component %s for method %s";
    }

    @Override
    public final void couldNotFindEjbForLocatorIIOP(EJBLocator<?> locator) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.couldNotFindEjbForLocatorIIOP$str(), locator);
    }

    protected String couldNotFindEjbForLocatorIIOP$str() {
        return "WFLYEJB0035: Could not find Jakarta Enterprise Beans for locator %s, Jakarta Enterprise Beans client proxy will not be replaced";
    }

    @Override
    public final void ejbNotExposedOverIIOP(EJBLocator<?> locator) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ejbNotExposedOverIIOP$str(), locator);
    }

    protected String ejbNotExposedOverIIOP$str() {
        return "WFLYEJB0036: Jakarta Enterprise Beans %s is not being replaced with a Stub as it is not exposed over IIOP";
    }

    @Override
    public final void dynamicStubCreationFailed(String clazz, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.dynamicStubCreationFailed$str(), (Object)clazz);
    }

    protected String dynamicStubCreationFailed$str() {
        return "WFLYEJB0037: Dynamic stub creation failed for class %s";
    }

    @Override
    public final void logMDBStart(String mdbName, String raName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.logMDBStart$str(), (Object)mdbName, (Object)raName);
    }

    protected String logMDBStart$str() {
        return "WFLYEJB0042: Started message driven bean '%s' with '%s' resource adapter";
    }

    @Override
    public final void skipOverlappingInvokeTimeout(Timer timer, Date scheduledTime) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.skipOverlappingInvokeTimeout$str(), (Object)timer, (Object)scheduledTime);
    }

    protected String skipOverlappingInvokeTimeout$str() {
        return "WFLYEJB0043: A previous execution of timer %s is still in progress, skipping this overlapping scheduled execution at: %s.";
    }

    protected String resourceAdapterRepositoryUnAvailable$str() {
        return "WFLYEJB0044: Resource adapter repository is not available";
    }

    @Override
    public final IllegalStateException resourceAdapterRepositoryUnAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.resourceAdapterRepositoryUnAvailable$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String noSuchEndpointException$str() {
        return "WFLYEJB0045: Could not find an Endpoint for resource adapter %s";
    }

    @Override
    public final IllegalArgumentException noSuchEndpointException(String resourceAdapterName, NotFoundException notFoundException) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSuchEndpointException$str(), resourceAdapterName), (Throwable)notFoundException);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String endpointUnAvailable$str() {
        return "WFLYEJB0046: Endpoint is not available for message driven component %s";
    }

    @Override
    public final IllegalStateException endpointUnAvailable(String componentName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.endpointUnAvailable$str(), componentName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureDuringEndpointDeactivation$str() {
        return "WFLYEJB0047: Could not deactivate endpoint for message driven component %s";
    }

    @Override
    public final RuntimeException failureDuringEndpointDeactivation(String componentName, ResourceException cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failureDuringEndpointDeactivation$str(), componentName), (Throwable)cause);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureDuringLoadOfClusterNodeSelector$str() {
        return "WFLYEJB0049: Could not create an instance of cluster node selector %s for cluster %s";
    }

    @Override
    public final RuntimeException failureDuringLoadOfClusterNodeSelector(String clusterNodeSelectorName, String clusterName, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failureDuringLoadOfClusterNodeSelector$str(), clusterNodeSelectorName, clusterName), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToCreateOptionForProperty(String propertyName, String reason) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToCreateOptionForProperty$str(), (Object)propertyName, (Object)reason);
    }

    protected String failedToCreateOptionForProperty$str() {
        return "WFLYEJB0050: Failed to parse property %s due to %s";
    }

    protected String viewNotFound$str() {
        return "WFLYEJB0051: Could not find view %s for Jakarta Enterprise Beans %s";
    }

    @Override
    public final IllegalStateException viewNotFound(String viewClass, String ejbName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.viewNotFound$str(), viewClass, ejbName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String asyncInvocationOnlyApplicableForSessionBeans$str() {
        return "WFLYEJB0052: Cannot perform asynchronous local invocation for component that is not a session bean";
    }

    @Override
    public final RuntimeException asyncInvocationOnlyApplicableForSessionBeans() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.asyncInvocationOnlyApplicableForSessionBeans$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notStatefulSessionBean$str() {
        return "WFLYEJB0053: %s is not a Stateful Session bean in app: %s module: %s distinct-name: %s";
    }

    @Override
    public final IllegalArgumentException notStatefulSessionBean(String ejbName, String appName, String moduleName, String distinctName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notStatefulSessionBean$str(), ejbName, appName, moduleName, distinctName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToMarshalEjbParameters$str() {
        return "WFLYEJB0054: Failed to marshal Jakarta Enterprise Beans parameters";
    }

    @Override
    public final RuntimeException failedToMarshalEjbParameters(Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToMarshalEjbParameters$str(), new Object[0]), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownDeployment$str() {
        return "WFLYEJB0055: No matching deployment for Jakarta Enterprise Beans: %s";
    }

    @Override
    public final NoSuchEJBException unknownDeployment(EJBLocator<?> locator) {
        NoSuchEJBException result = new NoSuchEJBException(String.format(this.getLoggingLocale(), this.unknownDeployment$str(), locator));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ejbNotFoundInDeployment$str() {
        return "WFLYEJB0056: Could not find Jakarta Enterprise Beans in matching deployment: %s";
    }

    @Override
    public final NoSuchEJBException ejbNotFoundInDeployment(EJBLocator<?> locator) {
        NoSuchEJBException result = new NoSuchEJBException(String.format(this.getLoggingLocale(), this.ejbNotFoundInDeployment$str(), locator));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String annotationApplicableOnlyForMethods$str() {
        return "WFLYEJB0057: %s annotation is only valid on method targets";
    }

    @Override
    public final IllegalArgumentException annotationApplicableOnlyForMethods(String annotationName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.annotationApplicableOnlyForMethods$str(), annotationName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String aroundTimeoutMethodExpectedWithInvocationContextParam$str() {
        return "WFLYEJB0058: Method %s, on class %s, annotated with @jakarta.interceptor.AroundTimeout is expected to accept a single param of type jakarta.interceptor.InvocationContext";
    }

    @Override
    public final IllegalArgumentException aroundTimeoutMethodExpectedWithInvocationContextParam(String methodName, String className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.aroundTimeoutMethodExpectedWithInvocationContextParam$str(), methodName, className));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String aroundTimeoutMethodMustReturnObjectType$str() {
        return "WFLYEJB0059: Method %s, on class %s, annotated with @jakarta.interceptor.AroundTimeout must return Object type";
    }

    @Override
    public final IllegalArgumentException aroundTimeoutMethodMustReturnObjectType(String methodName, String className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.aroundTimeoutMethodMustReturnObjectType$str(), methodName, className));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wrongTxOnThread$str() {
        return "WFLYEJB0060: Wrong tx on thread: expected %s, actual %s";
    }

    @Override
    public final IllegalStateException wrongTxOnThread(Transaction expected, Transaction actual) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.wrongTxOnThread$str(), expected, actual));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownTxAttributeOnInvocation$str() {
        return "WFLYEJB0061: Unknown transaction attribute %s on invocation %s";
    }

    @Override
    public final IllegalStateException unknownTxAttributeOnInvocation(TransactionAttributeType txAttr, InterceptorContext invocation) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownTxAttributeOnInvocation$str(), txAttr, invocation));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String txRequiredForInvocation$str() {
        return "WFLYEJB0062: Transaction is required for invocation %s";
    }

    @Override
    public final EJBTransactionRequiredException txRequiredForInvocation(InterceptorContext invocation) {
        EJBTransactionRequiredException result = new EJBTransactionRequiredException(String.format(this.getLoggingLocale(), this.txRequiredForInvocation$str(), invocation));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String txPresentForNeverTxAttribute$str() {
        return "WFLYEJB0063: Transaction present on server in Never call (Enterprise Beans 3 13.6.2.6)";
    }

    @Override
    public final EJBException txPresentForNeverTxAttribute() {
        EJBException result = new EJBException(String.format(this.getLoggingLocale(), this.txPresentForNeverTxAttribute$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToSetRollbackOnly(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failedToSetRollbackOnly$str(), new Object[0]);
    }

    protected String failedToSetRollbackOnly$str() {
        return "WFLYEJB0064: Failed to set transaction for rollback only";
    }

    protected String viewInterfaceCannotBeNull$str() {
        return "WFLYEJB0065: View interface cannot be null";
    }

    @Override
    public final IllegalArgumentException viewInterfaceCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.viewInterfaceCannotBeNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadViewClassForComponent$str() {
        return "WFLYEJB0068: Could not load view class for component %s";
    }

    @Override
    public final RuntimeException failedToLoadViewClassForComponent(Exception e, String componentName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToLoadViewClassForComponent$str(), componentName), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalCallToEjbHomeRemove$str() {
        return "WFLYEJB0073: Illegal call to EJBHome.remove(Object) on a session bean";
    }

    @Override
    public final RemoveException illegalCallToEjbHomeRemove() {
        RemoveException result = new RemoveException(String.format(this.getLoggingLocale(), this.illegalCallToEjbHomeRemove$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String setRollbackOnlyNotAllowedForSupportsTxAttr$str() {
        return "WFLYEJB0074: Enterprise Beans 3.1 FR 13.6.2.8 setRollbackOnly is not allowed with SUPPORTS transaction attribute";
    }

    @Override
    public final IllegalStateException setRollbackOnlyNotAllowedForSupportsTxAttr() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.setRollbackOnlyNotAllowedForSupportsTxAttr$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCallGetPKOnSessionBean$str() {
        return "WFLYEJB0075: Cannot call getPrimaryKey on a session bean";
    }

    @Override
    public final EJBException cannotCallGetPKOnSessionBean() {
        EJBException result = new EJBException(String.format(this.getLoggingLocale(), this.cannotCallGetPKOnSessionBean$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ejb2xViewNotApplicableForSingletonBeans$str() {
        return "WFLYEJB0076: Singleton beans cannot have Enterprise Beans 2.x views";
    }

    @Override
    public final RuntimeException ejb2xViewNotApplicableForSingletonBeans() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.ejb2xViewNotApplicableForSingletonBeans$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ejbLocalObjectUnavailable$str() {
        return "WFLYEJB0078: Bean %s does not have an EJBLocalObject";
    }

    @Override
    public final IllegalStateException ejbLocalObjectUnavailable(String beanName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ejbLocalObjectUnavailable$str(), beanName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotBeApplicationExceptionBecauseNotAnExceptionType$str() {
        return "WFLYEJB0079: [Enterprise Beans 3.1 spec, section 14.1.1] Class: %s cannot be marked as an application exception because it is not of type java.lang.Exception";
    }

    @Override
    public final IllegalArgumentException cannotBeApplicationExceptionBecauseNotAnExceptionType(Class<?> klass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotBeApplicationExceptionBecauseNotAnExceptionType$str(), klass));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rmiRemoteExceptionCannotBeApplicationException$str() {
        return "WFLYEJB0080: [Enterprise Beans 3.1 spec, section 14.1.1] Exception class: %s cannot be marked as an application exception because it is of type java.rmi.RemoteException";
    }

    @Override
    public final IllegalArgumentException rmiRemoteExceptionCannotBeApplicationException(Class<?> klass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.rmiRemoteExceptionCannotBeApplicationException$str(), klass));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String annotationOnlyAllowedOnClass$str() {
        return "WFLYEJB0081: %s annotation is allowed only on classes. %s is not a class";
    }

    @Override
    public final RuntimeException annotationOnlyAllowedOnClass(String annotationName, AnnotationTarget incorrectTarget) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.annotationOnlyAllowedOnClass$str(), annotationName, incorrectTarget));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beanWithRemoteAnnotationImplementsMoreThanOneInterface$str() {
        return "WFLYEJB0082: Bean %s specifies @Remote annotation, but does not implement 1 interface";
    }

    @Override
    public final DeploymentUnitProcessingException beanWithRemoteAnnotationImplementsMoreThanOneInterface(Class<?> beanClass) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.beanWithRemoteAnnotationImplementsMoreThanOneInterface$str(), beanClass));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String beanWithLocalAnnotationImplementsMoreThanOneInterface$str() {
        return "WFLYEJB0083: Bean %s specifies @Local annotation, but does not implement 1 interface";
    }

    @Override
    public final DeploymentUnitProcessingException beanWithLocalAnnotationImplementsMoreThanOneInterface(Class<?> beanClass) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.beanWithLocalAnnotationImplementsMoreThanOneInterface$str(), beanClass));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToAnalyzeRemoteInterface$str() {
        return "WFLYEJB0084: Could not analyze remote interface for %s";
    }

    @Override
    public final RuntimeException failedToAnalyzeRemoteInterface(Exception e, String beanName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToAnalyzeRemoteInterface$str(), beanName), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToParse$str() {
        return "WFLYEJB0085: Exception while parsing %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToParse(Exception e, String filePath) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToParse$str(), filePath), (Throwable)e);
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToInstallManagementResource$str() {
        return "WFLYEJB0086: Failed to install management resources for %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToInstallManagementResource(Exception e, String componentName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToInstallManagementResource$str(), componentName), (Throwable)e);
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToLoadViewClass$str() {
        return "WFLYEJB0087: Could not load view %s";
    }

    @Override
    public final RuntimeException failedToLoadViewClass(Exception e, String viewClassName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToLoadViewClass$str(), viewClassName), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotDetermineEjbRefForInjectionTarget$str() {
        return "WFLYEJB0088: Could not determine type of ejb-ref %s for injection target %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotDetermineEjbRefForInjectionTarget(String ejbRefName, ResourceInjectionTarget injectionTarget) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotDetermineEjbRefForInjectionTarget$str(), ejbRefName, injectionTarget));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotDetermineEjbLocalRefForInjectionTarget$str() {
        return "WFLYEJB0089: Could not determine type of ejb-local-ref %s for injection target %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotDetermineEjbLocalRefForInjectionTarget(String ejbLocalRefName, ResourceInjectionTarget injectionTarget) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotDetermineEjbLocalRefForInjectionTarget$str(), ejbLocalRefName, injectionTarget));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String onlySetterMethodsAllowedToHaveEJBAnnotation$str() {
        return "WFLYEJB0090: @EJB injection target %s is invalid. Only setter methods are allowed";
    }

    @Override
    public final IllegalArgumentException onlySetterMethodsAllowedToHaveEJBAnnotation(MethodInfo methodInfo) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.onlySetterMethodsAllowedToHaveEJBAnnotation$str(), methodInfo));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nameAttributeRequiredForEJBAnnotationOnClass$str() {
        return "WFLYEJB0091: @EJB attribute 'name' is required for class level annotations. Class: %s";
    }

    @Override
    public final DeploymentUnitProcessingException nameAttributeRequiredForEJBAnnotationOnClass(String className) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.nameAttributeRequiredForEJBAnnotationOnClass$str(), className));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String beanInterfaceAttributeRequiredForEJBAnnotationOnClass$str() {
        return "WFLYEJB0092: @EJB attribute 'beanInterface' is required for class level annotations. Class: %s";
    }

    @Override
    public final DeploymentUnitProcessingException beanInterfaceAttributeRequiredForEJBAnnotationOnClass(String className) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.beanInterfaceAttributeRequiredForEJBAnnotationOnClass$str(), className));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String moduleNotAttachedToDeploymentUnit$str() {
        return "WFLYEJB0093: Module hasn't been attached to deployment unit %s";
    }

    @Override
    public final IllegalStateException moduleNotAttachedToDeploymentUnit(DeploymentUnit deploymentUnit) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.moduleNotAttachedToDeploymentUnit$str(), deploymentUnit));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mdbDoesNotImplementNorSpecifyMessageListener$str() {
        return "WFLYEJB0094: Enterprise Beans 3.1 FR 5.4.2 MessageDrivenBean %s does not implement 1 interface nor specifies message listener interface";
    }

    @Override
    public final DeploymentUnitProcessingException mdbDoesNotImplementNorSpecifyMessageListener(ClassInfo beanClass) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.mdbDoesNotImplementNorSpecifyMessageListener$str(), beanClass));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownSessionBeanType$str() {
        return "WFLYEJB0095: Unknown session bean type %s";
    }

    @Override
    public final IllegalArgumentException unknownSessionBeanType(String sessionType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownSessionBeanType$str(), sessionType));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String moreThanOneMethodWithSameNameOnComponent$str() {
        return "WFLYEJB0096: More than one method found with name %s on %s";
    }

    @Override
    public final DeploymentUnitProcessingException moreThanOneMethodWithSameNameOnComponent(String methodName, Class<?> componentClass) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.moreThanOneMethodWithSameNameOnComponent$str(), methodName, componentClass));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownEJBLocatorType$str() {
        return "WFLYEJB0097: Unknown Jakarta Enterprise Beans locator type %s";
    }

    @Override
    public final RuntimeException unknownEJBLocatorType(EJBLocator<?> locator) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unknownEJBLocatorType$str(), locator));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateCorbaObject$str() {
        return "WFLYEJB0098: Could not create CORBA object for %s";
    }

    @Override
    public final RuntimeException couldNotCreateCorbaObject(Exception cause, EJBLocator<?> locator) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotCreateCorbaObject$str(), locator), cause);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incorrectEJBLocatorForBean$str() {
        return "WFLYEJB0099: Provided locator %s was not for Jakarta Enterprise Beans %s";
    }

    @Override
    public final IllegalArgumentException incorrectEJBLocatorForBean(EJBLocator<?> locator, String beanName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.incorrectEJBLocatorForBean$str(), locator, beanName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLookupORB$str() {
        return "WFLYEJB0100: Failed to lookup java:comp/ORB";
    }

    @Override
    public final IOException failedToLookupORB() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.failedToLookupORB$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAnObjectImpl$str() {
        return "WFLYEJB0101: %s is not an ObjectImpl";
    }

    @Override
    public final IOException notAnObjectImpl(Class<?> type) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.notAnObjectImpl$str(), type));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String messageEndpointAlreadyReleased$str() {
        return "WFLYEJB0102: Message endpoint %s has already been released";
    }

    @Override
    public final UnavailableException messageEndpointAlreadyReleased(MessageEndpoint messageEndpoint) {
        UnavailableException result = new UnavailableException(String.format(this.getLoggingLocale(), this.messageEndpointAlreadyReleased$str(), messageEndpoint));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String timerInvocationFailedDueToInvokerNotBeingStarted$str() {
        return "WFLYEJB0107: Timer invocation failed, invoker is not started";
    }

    @Override
    public final IllegalStateException timerInvocationFailedDueToInvokerNotBeingStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.timerInvocationFailedDueToInvokerNotBeingStarted$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidValueForSecondInScheduleExpression$str() {
        return "WFLYEJB0109: Invalid value for second: %s";
    }

    @Override
    public final IllegalArgumentException invalidValueForSecondInScheduleExpression(String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidValueForSecondInScheduleExpression$str(), value));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerInvocationRolledBack$str() {
        return "WFLYEJB0110: Timer invocation failed, transaction rolled back";
    }

    @Override
    public final TimerTransactionRolledBackException timerInvocationRolledBack() {
        TimerTransactionRolledBackException result = new TimerTransactionRolledBackException(String.format(this.getLoggingLocale(), this.timerInvocationRolledBack$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noJNDIBindingsForSessionBean(String beanName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.noJNDIBindingsForSessionBean$str(), (Object)beanName);
    }

    protected String noJNDIBindingsForSessionBean$str() {
        return "WFLYEJB0111: No jndi bindings will be created for Jakarta Enterprise Beans %s since no views are exposed";
    }

    @Override
    public final void sessionBeanClassCannotBeAnInterface(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.sessionBeanClassCannotBeAnInterface$str(), (Object)className);
    }

    protected String sessionBeanClassCannotBeAnInterface$str() {
        return "WFLYEJB0118: [Enterprise Beans 3.1 spec, section 4.9.2] Session bean implementation class MUST NOT be a interface - %s is an interface, hence won't be considered as a session bean";
    }

    @Override
    public final void sessionBeanClassMustBePublicNonAbstractNonFinal(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.sessionBeanClassMustBePublicNonAbstractNonFinal$str(), (Object)className);
    }

    protected String sessionBeanClassMustBePublicNonAbstractNonFinal$str() {
        return "WFLYEJB0119: [Enterprise Beans 3.1 spec, section 4.9.2] Session bean implementation class MUST be public, not abstract and not final - %s won't be considered as a session bean, since it doesn't meet that requirement";
    }

    @Override
    public final void mdbClassCannotBeAnInterface(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mdbClassCannotBeAnInterface$str(), (Object)className);
    }

    protected String mdbClassCannotBeAnInterface$str() {
        return "WFLYEJB0120: [Enterprise Beans 3.1 spec, section 5.6.2] Message driven bean implementation class MUST NOT be a interface - %s is an interface, hence won't be considered as a message driven bean";
    }

    @Override
    public final void mdbClassMustBePublicNonAbstractNonFinal(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mdbClassMustBePublicNonAbstractNonFinal$str(), (Object)className);
    }

    protected String mdbClassMustBePublicNonAbstractNonFinal$str() {
        return "WFLYEJB0121: [Enterprise Beans 3.1 spec, section 5.6.2] Message driven bean implementation class MUST be public, not abstract and not final - %s won't be considered as a message driven bean, since it doesn't meet that requirement";
    }

    protected String failedToCreateDeploymentNodeSelector$str() {
        return "WFLYEJB0125: Could not create an instance of deployment node selector %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToCreateDeploymentNodeSelector(Exception e, String deploymentNodeSelectorClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToCreateDeploymentNodeSelector$str(), deploymentNodeSelectorClassName), (Throwable)e);
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String ejbMustHavePublicDefaultConstructor$str() {
        return "WFLYEJB0127: Jakarta Enterprise Beans %s of type %s must have public default constructor";
    }

    @Override
    public final DeploymentUnitProcessingException ejbMustHavePublicDefaultConstructor(String componentName, String componentClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.ejbMustHavePublicDefaultConstructor$str(), componentName, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String ejbMustNotBeInnerClass$str() {
        return "WFLYEJB0128: Jakarta Enterprise Beans %s of type %s must not be inner class";
    }

    @Override
    public final DeploymentUnitProcessingException ejbMustNotBeInnerClass(String componentName, String componentClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.ejbMustNotBeInnerClass$str(), componentName, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String ejbMustBePublicClass$str() {
        return "WFLYEJB0129: Jakarta Enterprise Beans %s of type %s must be declared public";
    }

    @Override
    public final DeploymentUnitProcessingException ejbMustBePublicClass(String componentName, String componentClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.ejbMustBePublicClass$str(), componentName, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String ejbMustNotBeFinalClass$str() {
        return "WFLYEJB0130: Jakarta Enterprise Beans %s of type %s must not be declared final";
    }

    @Override
    public final DeploymentUnitProcessingException ejbMustNotBeFinalClass(String componentName, String componentClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.ejbMustNotBeFinalClass$str(), componentName, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void ejbMethodMustNotBeFinalNorStatic(String ejbName, String methodName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ejbMethodMustNotBeFinalNorStatic$str(), (Object)ejbName, (Object)methodName);
    }

    protected String ejbMethodMustNotBeFinalNorStatic$str() {
        return "WFLYEJB0131: Jakarta Enterprise Beans %s should not have a final or static method (%s)";
    }

    protected String reentrantSingletonCreation$str() {
        return "WFLYEJB0132: @PostConstruct method of Jakarta Enterprise Beans singleton %s of type %s has been recursively invoked";
    }

    @Override
    public final IllegalStateException reentrantSingletonCreation(String componentName, String componentClassName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.reentrantSingletonCreation$str(), componentName, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unauthorizedAccessToUserTransaction$str() {
        return "WFLYEJB0137: Only session and message-driven beans with bean-managed transaction demarcation are allowed to access UserTransaction";
    }

    @Override
    public final IllegalStateException unauthorizedAccessToUserTransaction() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unauthorizedAccessToUserTransaction$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerServiceIsNotActive$str() {
        return "WFLYEJB0139: The timer service has been disabled. Please add a <timer-service> entry into the Jakarta Enterprise Beans section of the server configuration to enable it.";
    }

    @Override
    public final String timerServiceIsNotActive() {
        return String.format(this.getLoggingLocale(), this.timerServiceIsNotActive$str(), new Object[0]);
    }

    protected String ejbHasNoTimerMethods$str() {
        return "WFLYEJB0140: This Jakarta Enterprise Beans does not have any timeout methods";
    }

    @Override
    public final String ejbHasNoTimerMethods() {
        return String.format(this.getLoggingLocale(), this.ejbHasNoTimerMethods$str(), new Object[0]);
    }

    @Override
    public final void deploymentAddListenerException(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.deploymentAddListenerException$str(), new Object[0]);
    }

    protected String deploymentAddListenerException$str() {
        return "WFLYEJB0141: Exception calling deployment added listener";
    }

    @Override
    public final void deploymentRemoveListenerException(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.deploymentRemoveListenerException$str(), new Object[0]);
    }

    protected String deploymentRemoveListenerException$str() {
        return "WFLYEJB0142: Exception calling deployment removal listener";
    }

    @Override
    public final void failedToRemoveManagementResources(InstalledComponent component, String cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToRemoveManagementResources$str(), (Object)component, (Object)cause);
    }

    protected String failedToRemoveManagementResources$str() {
        return "WFLYEJB0143: Failed to remove management resources for %s -- %s";
    }

    @Override
    public final void cobraInterfaceRepository(String repo, String object) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.cobraInterfaceRepository$str(), (Object)repo, (Object)object);
    }

    protected String cobraInterfaceRepository$str() {
        return "WFLYEJB0144: CORBA interface repository for %s: %s";
    }

    @Override
    public final void cannotUnregisterEJBHomeFromCobra(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.cannotUnregisterEJBHomeFromCobra$str(), new Object[0]);
    }

    protected String cannotUnregisterEJBHomeFromCobra$str() {
        return "WFLYEJB0145: Cannot unregister EJBHome from CORBA naming service";
    }

    @Override
    public final void cannotDeactivateHomeServant(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.cannotDeactivateHomeServant$str(), new Object[0]);
    }

    protected String cannotDeactivateHomeServant$str() {
        return "WFLYEJB0146: Cannot deactivate home servant";
    }

    @Override
    public final void cannotDeactivateBeanServant(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.cannotDeactivateBeanServant$str(), new Object[0]);
    }

    protected String cannotDeactivateBeanServant$str() {
        return "WFLYEJB0147: Cannot deactivate bean servant";
    }

    @Override
    public final void couldNotWriteMethodInvocation(Throwable cause, Method invokedMethod, String beanName, String appName, String moduleName, String distinctName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.couldNotWriteMethodInvocation$str(), new Object[]{invokedMethod, beanName, appName, moduleName, distinctName});
    }

    protected String couldNotWriteMethodInvocation$str() {
        return "WFLYEJB0150: Could not write method invocation failure for method %s on bean named %s for appname %s modulename %s distinctname %s due to";
    }

    @Override
    public final void exceptionGeneratingSessionId(Throwable cause, String componentName, Object invocationInformation) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.exceptionGeneratingSessionId$str(), (Object)componentName, invocationInformation);
    }

    protected String exceptionGeneratingSessionId$str() {
        return "WFLYEJB0151: Exception while generating session id for component %s with invocation %s";
    }

    @Override
    public final void failedToGetStatus(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToGetStatus$str(), new Object[0]);
    }

    protected String failedToGetStatus$str() {
        return "WFLYEJB0157: Failed to get status";
    }

    @Override
    public final void failedToRollback(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToRollback$str(), new Object[0]);
    }

    protected String failedToRollback$str() {
        return "WFLYEJB0158: Failed to rollback";
    }

    @Override
    public final void transactionNotComplete(String componentName, String status) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.transactionNotComplete2$str(), (Object)componentName, (Object)status);
    }

    protected String transactionNotComplete2$str() {
        return "WFLYEJB0159: BMT stateful bean '%s' did not complete user transaction properly status=%s";
    }

    @Override
    public final void timerReinstatementFailed(String timedObjectId, String timerId, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.timerReinstatementFailed$str(), (Object)timedObjectId, (Object)timerId);
    }

    protected String timerReinstatementFailed$str() {
        return "WFLYEJB0161: Failed to reinstate timer '%s' (id=%s) from its persistent state";
    }

    @Override
    public final void skipInvokeTimeoutDuringRetry(Timer timer, Date scheduledTime) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.skipInvokeTimeoutDuringRetry$str(), (Object)timer, (Object)scheduledTime);
    }

    protected String skipInvokeTimeoutDuringRetry$str() {
        return "WFLYEJB0162: A previous execution of timer %s is being retried, skipping this scheduled execution at: %s";
    }

    @Override
    public final void couldNotCreateTable(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.couldNotCreateTable$str(), new Object[0]);
    }

    protected String couldNotCreateTable$str() {
        return "WFLYEJB0163: Cannot create table for timer persistence";
    }

    @Override
    public final void exceptionRunningTimerTask(Timer timer, String timedObjectId, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.exceptionRunningTimerTask$str(), (Object)timer, (Object)timedObjectId);
    }

    protected String exceptionRunningTimerTask$str() {
        return "WFLYEJB0164: Exception running timer task for timer %s on Jakarta Enterprise Beans %s";
    }

    @Override
    public final void deprecatedAnnotation(String annotation) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedAnnotation$str(), (Object)annotation);
    }

    protected String deprecatedAnnotation$str() {
        return "WFLYEJB0166: The @%s annotation is deprecated and will be ignored.";
    }

    @Override
    public final void deprecatedNamespace(String namespace, String element) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedNamespace$str(), (Object)namespace, (Object)element);
    }

    protected String deprecatedNamespace$str() {
        return "WFLYEJB0167: The <%2$s xmlns=\"%1$s\"/> element will be ignored.";
    }

    protected String couldNotFindEjb$str() {
        return "WFLYEJB0168: Could not find Jakarta Enterprise Beans with id %s";
    }

    @Override
    public final NoSuchEJBException couldNotFindEjb(String sessionId) {
        NoSuchEJBException result = new NoSuchEJBException(String.format(this.getLoggingLocale(), this.couldNotFindEjb$str(), sessionId));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentNotSetInInterceptor$str() {
        return "WFLYEJB0169: Component not set in InterceptorContext: %s";
    }

    @Override
    public final IllegalStateException componentNotSetInInterceptor(InterceptorContext context) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.componentNotSetInInterceptor$str(), context));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String methodNameIsNull$str() {
        return "WFLYEJB0170: Method name cannot be null";
    }

    @Override
    public final IllegalArgumentException methodNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.methodNameIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beanHomeInterfaceIsNull$str() {
        return "WFLYEJB0171: Bean %s does not have a Home interface";
    }

    @Override
    public final IllegalStateException beanHomeInterfaceIsNull(String componentName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.beanHomeInterfaceIsNull$str(), componentName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beanLocalHomeInterfaceIsNull$str() {
        return "WFLYEJB0172: Bean %s does not have a Local Home interface";
    }

    @Override
    public final IllegalStateException beanLocalHomeInterfaceIsNull(String componentName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.beanLocalHomeInterfaceIsNull$str(), componentName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToCallgetRollbackOnly$str() {
        return "WFLYEJB0173: Enterprise Beans 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use getRollbackOnly.";
    }

    @Override
    public final IllegalStateException failToCallgetRollbackOnly() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToCallgetRollbackOnly$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToCallgetRollbackOnlyOnNoneTransaction$str() {
        return "WFLYEJB0174: getRollbackOnly() not allowed without a transaction.";
    }

    @Override
    public final IllegalStateException failToCallgetRollbackOnlyOnNoneTransaction() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToCallgetRollbackOnlyOnNoneTransaction$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToCallgetRollbackOnlyAfterTxcompleted$str() {
        return "WFLYEJB0175: getRollbackOnly() not allowed after transaction is completed (EJBTHREE-1445)";
    }

    @Override
    public final IllegalStateException failToCallgetRollbackOnlyAfterTxcompleted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToCallgetRollbackOnlyAfterTxcompleted$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jndiNameCannotBeNull$str() {
        return "WFLYEJB0177: jndi name cannot be null during lookup";
    }

    @Override
    public final IllegalArgumentException jndiNameCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.jndiNameCannotBeNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noNamespaceContextSelectorAvailable$str() {
        return "WFLYEJB0178: No NamespaceContextSelector available, cannot lookup %s";
    }

    @Override
    public final IllegalArgumentException noNamespaceContextSelectorAvailable(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noNamespaceContextSelectorAvailable$str(), name));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToLookupJNDI$str() {
        return "WFLYEJB0179:  Could not lookup jndi name: %s";
    }

    @Override
    public final RuntimeException failToLookupJNDI(String name, Throwable e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failToLookupJNDI$str(), name), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToLookupJNDINameSpace$str() {
        return "WFLYEJB0180: Cannot lookup jndi name: %s since it doesn't belong to java:app, java:module, java:comp or java:global namespace";
    }

    @Override
    public final IllegalArgumentException failToLookupJNDINameSpace(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failToLookupJNDINameSpace$str(), name));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToLookupStrippedJNDI$str() {
        return "WFLYEJB0181: Could not lookup jndi name: %s in context: %s";
    }

    @Override
    public final IllegalArgumentException failToLookupStrippedJNDI(NamespaceContextSelector namespaceContextSelector, Context jndiContext, Throwable ne) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failToLookupStrippedJNDI$str(), namespaceContextSelector, jndiContext), ne);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToCallSetRollbackOnlyOnNoneCMB$str() {
        return "WFLYEJB0182: Enterprise Beans 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use setRollbackOnly.";
    }

    @Override
    public final IllegalStateException failToCallSetRollbackOnlyOnNoneCMB() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToCallSetRollbackOnlyOnNoneCMB$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToCallSetRollbackOnlyWithNoTx$str() {
        return "WFLYEJB0183: setRollbackOnly() not allowed without a transaction.";
    }

    @Override
    public final IllegalStateException failToCallSetRollbackOnlyWithNoTx() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToCallSetRollbackOnlyWithNoTx$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String EjbJarConfigurationIsNull$str() {
        return "WFLYEJB0184: EjbJarConfiguration cannot be null";
    }

    @Override
    public final IllegalArgumentException EjbJarConfigurationIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.EjbJarConfigurationIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String SecurityRolesIsNull$str() {
        return "WFLYEJB0185: Cannot set security roles to null";
    }

    @Override
    public final IllegalArgumentException SecurityRolesIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.SecurityRolesIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToLinkFromEmptySecurityRole$str() {
        return "WFLYEJB0193: Cannot link from a null or empty security role: %s";
    }

    @Override
    public final IllegalArgumentException failToLinkFromEmptySecurityRole(String fromRole) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failToLinkFromEmptySecurityRole$str(), fromRole));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToLinkToEmptySecurityRole$str() {
        return "WFLYEJB0194: Cannot link to a null or empty security role: %s";
    }

    @Override
    public final IllegalArgumentException failToLinkToEmptySecurityRole(String toRole) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failToLinkToEmptySecurityRole$str(), toRole));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ejbJarConfigNotFound$str() {
        return "WFLYEJB0195: EjbJarConfiguration not found as an attachment in deployment unit: %s";
    }

    @Override
    public final DeploymentUnitProcessingException ejbJarConfigNotFound(DeploymentUnit deploymentUnit) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.ejbJarConfigNotFound$str(), deploymentUnit));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String componentViewNotAvailableInContext$str() {
        return "WFLYEJB0196: ComponentViewInstance not available in interceptor context: %s";
    }

    @Override
    public final IllegalStateException componentViewNotAvailableInContext(InterceptorContext context) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.componentViewNotAvailableInContext$str(), context));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownResourceAdapter$str() {
        return "WFLYEJB0199: No resource adapter registered with resource adapter name %s";
    }

    @Override
    public final IllegalStateException unknownResourceAdapter(String resourceAdapterName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownResourceAdapter$str(), resourceAdapterName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToCompleteTaskBeforeTimeOut$str() {
        return "WFLYEJB0202: Task did not complete in %s  %S";
    }

    @Override
    public final TimeoutException failToCompleteTaskBeforeTimeOut(long timeout, TimeUnit unit) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.failToCompleteTaskBeforeTimeOut$str(), new Object[]{timeout, unit}));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String taskWasCancelled$str() {
        return "WFLYEJB0203: Task was cancelled";
    }

    @Override
    public final CancellationException taskWasCancelled() {
        CancellationException result = new CancellationException(String.format(this.getLoggingLocale(), this.taskWasCancelled$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String methodNotImplemented$str() {
        return "WFLYEJB0206: Not implemented yet";
    }

    @Override
    public final IllegalStateException methodNotImplemented() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.methodNotImplemented$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedComponent$str() {
        return "WFLYEJB0213: Unexpected component: %s component Expected %s";
    }

    @Override
    public final IllegalStateException unexpectedComponent(Component component, Class<?> entityBeanComponentClass) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedComponent$str(), component, entityBeanComponentClass));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ejbJarConfigNotBeenSet$str() {
        return "WFLYEJB0214: EjbJarConfiguration hasn't been set in %s Cannot create component create service for Jakarta Enterprise Beans %S";
    }

    @Override
    public final IllegalStateException ejbJarConfigNotBeenSet(ComponentCreateServiceFactory serviceFactory, String componentName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ejbJarConfigNotBeenSet$str(), serviceFactory, componentName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String poolConfigIsEmpty$str() {
        return "WFLYEJB0218: PoolConfig cannot be null or empty";
    }

    @Override
    public final IllegalStateException poolConfigIsEmpty() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.poolConfigIsEmpty$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToAddClassToLocalView$str() {
        return "WFLYEJB0220: [Enterprise Beans 3.1 spec, section 4.9.7] - Can't add view class: %s as local view since it's already marked as remote view for bean: %s";
    }

    @Override
    public final IllegalStateException failToAddClassToLocalView(String viewClassName, String ejbName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToAddClassToLocalView$str(), viewClassName, ejbName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String businessInterfaceIsNull$str() {
        return "WFLYEJB0221: Business interface type cannot be null";
    }

    @Override
    public final IllegalStateException businessInterfaceIsNull() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.businessInterfaceIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beanComponentMissingEjbObject$str() {
        return "WFLYEJB0222: Bean %s does not have an %s";
    }

    @Override
    public final IllegalStateException beanComponentMissingEjbObject(String componentName, String ejbLocalObject) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.beanComponentMissingEjbObject$str(), componentName, ejbLocalObject));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String getRollBackOnlyIsNotAllowWithSupportsAttribute$str() {
        return "WFLYEJB0223: Jakarta Enterprise Beans 3.1 FR 13.6.2.9 getRollbackOnly is not allowed with SUPPORTS attribute";
    }

    @Override
    public final IllegalStateException getRollBackOnlyIsNotAllowWithSupportsAttribute() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.getRollBackOnlyIsNotAllowWithSupportsAttribute$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToCallBusinessOnNonePublicMethod$str() {
        return "WFLYEJB0224: Not a business method %s. Do not call non-public methods on Jakarta Enterprise Beans's";
    }

    @Override
    public final EJBException failToCallBusinessOnNonePublicMethod(Method method) {
        EJBException result = new EJBException(String.format(this.getLoggingLocale(), this.failToCallBusinessOnNonePublicMethod$str(), method));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentInstanceNotAvailable$str() {
        return "WFLYEJB0225: Component instance isn't available for invocation: %s";
    }

    @Override
    public final Exception componentInstanceNotAvailable(InterceptorContext interceptorContext) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.componentInstanceNotAvailable$str(), interceptorContext));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToObtainLock$str() {
        return "WFLYEJB0228: Enterprise Beans 3.1 FR 4.3.14.1 concurrent access timeout on %s - could not obtain lock within %s %s";
    }

    @Override
    public final ConcurrentAccessTimeoutException failToObtainLock(String ejb, long value, TimeUnit timeUnit) {
        ConcurrentAccessTimeoutException result = new ConcurrentAccessTimeoutException(String.format(this.getLoggingLocale(), this.failToObtainLock$str(), new Object[]{ejb, value, timeUnit}));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String statefulSessionIdIsNull$str() {
        return "WFLYEJB0234: Session id hasn't been set for stateful component: %s";
    }

    @Override
    public final IllegalStateException statefulSessionIdIsNull(String componentName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.statefulSessionIdIsNull$str(), componentName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String removeMethodIsNull$str() {
        return "WFLYEJB0235: @Remove method identifier cannot be null";
    }

    @Override
    public final IllegalArgumentException removeMethodIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.removeMethodIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentNotInstanceOfSessionComponent$str() {
        return "WFLYEJB0236: Component %s with component class: %s%n isn't a %s component";
    }

    @Override
    public final IllegalArgumentException componentNotInstanceOfSessionComponent(Component component, Class<?> componentClass, String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.componentNotInstanceOfSessionComponent$str(), component, componentClass, type));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bothMethodIntAndClassNameSet$str() {
        return "WFLYEJB0237: both methodIntf and className are set on %s";
    }

    @Override
    public final IllegalArgumentException bothMethodIntAndClassNameSet(String componentName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.bothMethodIntAndClassNameSet$str(), componentName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToUpgradeToWriteLock$str() {
        return "WFLYEJB0238: Enterprise Beans 3.1 PFD2 4.8.5.1.1 upgrading from read to write lock is not allowed";
    }

    @Override
    public final IllegalLoopbackException failToUpgradeToWriteLock() {
        IllegalLoopbackException result = new IllegalLoopbackException(String.format(this.getLoggingLocale(), this.failToUpgradeToWriteLock$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String componentIsNull$str() {
        return "WFLYEJB0239: %s cannot be null";
    }

    @Override
    public final IllegalArgumentException componentIsNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.componentIsNull$str(), name));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invocationNotApplicableForMethodInvocation$str() {
        return "WFLYEJB0240: Invocation context: %s cannot be processed because it's not applicable for a method invocation";
    }

    @Override
    public final IllegalArgumentException invocationNotApplicableForMethodInvocation(InvocationContext invocationContext) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invocationNotApplicableForMethodInvocation$str(), invocationContext));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String concurrentAccessTimeoutException$str() {
        return "WFLYEJB0241: Enterprise Beans 3.1 PFD2 4.8.5.5.1 concurrent access timeout on %s - could not obtain lock within %s";
    }

    @Override
    public final ConcurrentAccessTimeoutException concurrentAccessTimeoutException(String ejb, String s) {
        ConcurrentAccessTimeoutException result = new ConcurrentAccessTimeoutException(String.format(this.getLoggingLocale(), this.concurrentAccessTimeoutException$str(), ejb, s));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToObtainLockIllegalType$str() {
        return "WFLYEJB0242: Illegal lock type %s on %s for component %s";
    }

    @Override
    public final IllegalStateException failToObtainLockIllegalType(LockType lockType, Method method, SingletonComponent lockableComponent) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToObtainLockIllegalType$str(), new Object[]{lockType, method, lockableComponent}));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCall2$str() {
        return "WFLYEJB0243: Cannot call %s, no %s is present for this invocation";
    }

    @Override
    public final IllegalStateException cannotCall(String methodName, String missing) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCall2$str(), methodName, missing));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noAsynchronousInvocationInProgress$str() {
        return "WFLYEJB0244: No asynchronous invocation in progress";
    }

    @Override
    public final IllegalStateException noAsynchronousInvocationInProgress() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noAsynchronousInvocationInProgress$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String roleNamesIsNull$str() {
        return "WFLYEJB0255: <role-name> cannot be null or empty in <security-role-ref>%nfor bean: %s";
    }

    @Override
    public final DeploymentUnitProcessingException roleNamesIsNull(String ejbName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.roleNamesIsNull$str(), ejbName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String defaultInterceptorsNotBindToMethod$str() {
        return "WFLYEJB0256: Default interceptors cannot specify a method to bind to in ejb-jar.xml";
    }

    @Override
    public final DeploymentUnitProcessingException defaultInterceptorsNotBindToMethod() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.defaultInterceptorsNotBindToMethod$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String twoEjbBindingsSpecifyAbsoluteOrder$str() {
        return "WFLYEJB0258: Two ejb-jar.xml bindings for %s specify an absolute order";
    }

    @Override
    public final DeploymentUnitProcessingException twoEjbBindingsSpecifyAbsoluteOrder(String component) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.twoEjbBindingsSpecifyAbsoluteOrder$str(), component));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToFindMethodInEjbJarXml$str() {
        return "WFLYEJB0259: Could not find method %s.%s referenced in ejb-jar.xml";
    }

    @Override
    public final DeploymentUnitProcessingException failToFindMethodInEjbJarXml(String name, String methodName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failToFindMethodInEjbJarXml$str(), name, methodName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleMethodReferencedInEjbJarXml$str() {
        return "WFLYEJB0260: More than one method %s found on class %s referenced in ejb-jar.xml. Specify the parameter types to resolve the ambiguity";
    }

    @Override
    public final DeploymentUnitProcessingException multipleMethodReferencedInEjbJarXml(String methodName, String name) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.multipleMethodReferencedInEjbJarXml$str(), methodName, name));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToFindMethodWithParameterTypes$str() {
        return "WFLYEJB0261: Could not find method %s.%s with parameter types %s referenced in ejb-jar.xml";
    }

    @Override
    public final DeploymentUnitProcessingException failToFindMethodWithParameterTypes(String name, String methodName, MethodParametersMetaData methodParams) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failToFindMethodWithParameterTypes$str(), name, methodName, methodParams));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToLoadComponentClass$str() {
        return "WFLYEJB0262: Could not load component class for component %s";
    }

    @Override
    public final DeploymentUnitProcessingException failToLoadComponentClass(Throwable t, String componentName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failToLoadComponentClass$str(), componentName), t);
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToMergeData$str() {
        return "WFLYEJB0264: Could not merge data for %s";
    }

    @Override
    public final DeploymentUnitProcessingException failToMergeData(String componentName, Throwable e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failToMergeData$str(), componentName), e);
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToLoadEjbClass$str() {
        return "WFLYEJB0265: Could not load Jakarta Enterprise Beans class %s";
    }

    @Override
    public final DeploymentUnitProcessingException failToLoadEjbClass(String ejbClassName, Throwable e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failToLoadEjbClass$str(), ejbClassName), e);
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleAnnotationsOnBean$str() {
        return "WFLYEJB0266: Only one %s method is allowed on bean %s";
    }

    @Override
    public final RuntimeException multipleAnnotationsOnBean(String annotationType, String ejbClassName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.multipleAnnotationsOnBean$str(), annotationType, ejbClassName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleCreateMethod$str() {
        return "WFLYEJB0267: Could not determine type of corresponding implied Enterprise Beans 2.x local interface (see Enterprise Beans 3.1 21.4.5)%n due to multiple create* methods with different return types on home %s";
    }

    @Override
    public final DeploymentUnitProcessingException multipleCreateMethod(Class<?> localHomeClass) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.multipleCreateMethod$str(), localHomeClass));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToFindEjbRefByDependsOn$str() {
        return "WFLYEJB0268: Could not find Jakarta Enterprise Beans %s referenced by @DependsOn annotation in %s";
    }

    @Override
    public final DeploymentUnitProcessingException failToFindEjbRefByDependsOn(String annotationValue, String componentClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failToFindEjbRefByDependsOn$str(), annotationValue, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToCallEjbRefByDependsOn$str() {
        return "WFLYEJB0269: More than one Jakarta Enterprise Beans called %s referenced by @DependsOn annotation in %s Components:%s";
    }

    @Override
    public final DeploymentUnitProcessingException failToCallEjbRefByDependsOn(String annotationValue, String componentClassName, Set<ComponentDescription> components) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failToCallEjbRefByDependsOn$str(), annotationValue, componentClassName, components));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String wrongReturnTypeForAsyncMethod$str() {
        return "WFLYEJB0270: Async method %s does not return void or Future";
    }

    @Override
    public final DeploymentUnitProcessingException wrongReturnTypeForAsyncMethod(Method method) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.wrongReturnTypeForAsyncMethod$str(), method));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToLoadAppExceptionClassInEjbJarXml$str() {
        return "WFLYEJB0271: Could not load application exception class %s in ejb-jar.xml";
    }

    @Override
    public final DeploymentUnitProcessingException failToLoadAppExceptionClassInEjbJarXml(String exceptionClassName, Throwable e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failToLoadAppExceptionClassInEjbJarXml$str(), exceptionClassName), e);
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidEjbEntityTimeout$str() {
        return "WFLYEJB0272: Jakarta Enterprise Beans %s entity bean %s implemented TimedObject, but has a different timeout method specified either via annotations or via the deployment descriptor";
    }

    @Override
    public final DeploymentUnitProcessingException invalidEjbEntityTimeout(String versionId, Class<?> componentClass) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.invalidEjbEntityTimeout$str(), versionId, componentClass));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidEjbLocalInterface$str() {
        return "WFLYEJB0273: %s does not have an Enterprise Beans 2.x local interface";
    }

    @Override
    public final RuntimeException invalidEjbLocalInterface(String componentName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidEjbLocalInterface$str(), componentName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String localHomeNotAllow$str() {
        return "WFLYEJB0274: Local Home not allowed for %s";
    }

    @Override
    public final DeploymentUnitProcessingException localHomeNotAllow(EJBComponentDescription description) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.localHomeNotAllow$str(), new Object[]{description}));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToCallEjbCreateForHomeInterface$str() {
        return "WFLYEJB0275: Could not resolve corresponding ejbCreate or @Init method for home interface method %s on Jakarta Enterprise Beans %s";
    }

    @Override
    public final DeploymentUnitProcessingException failToCallEjbCreateForHomeInterface(Method method, String ejbClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failToCallEjbCreateForHomeInterface$str(), method, ejbClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToGetEjbComponent$str() {
        return "WFLYEJB0276: EJBComponent has not been set in the current invocation context %s";
    }

    @Override
    public final IllegalStateException failToGetEjbComponent(InterceptorContext currentInvocationContext) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToGetEjbComponent$str(), currentInvocationContext));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidScheduleValue$str() {
        return "WFLYEJB0286: Invalid schedule %s value: %s";
    }

    @Override
    public final IllegalArgumentException invalidScheduleValue(String type, String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidScheduleValue$str(), type, value));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidScheduleExpressionType$str() {
        return "WFLYEJB0291: Invalid value: %s since %s doesn't support values of types %s";
    }

    @Override
    public final IllegalArgumentException invalidScheduleExpressionType(String value, String name, String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidScheduleExpressionType$str(), value, name, type));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidListValue$str() {
        return "WFLYEJB0292: A list value can only contain either a range or an individual value. Invalid value: %s";
    }

    @Override
    public final IllegalArgumentException invalidListValue(String listItem) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidListValue$str(), listItem));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidValuesRange$str() {
        return "WFLYEJB0294: Invalid value: %s Valid values are between %s and %s";
    }

    @Override
    public final IllegalArgumentException invalidValuesRange(Integer value, int min, int max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidValuesRange$str(), value, min, max));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invokerIsNull$str() {
        return "WFLYEJB0303: Invoker cannot be null";
    }

    @Override
    public final IllegalArgumentException invokerIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invokerIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String executorIsNull$str() {
        return "WFLYEJB0305: Executor cannot be null";
    }

    @Override
    public final IllegalArgumentException executorIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.executorIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTimerParameter$str() {
        return "WFLYEJB0306: Invalid timer parameter: %s = %s";
    }

    @Override
    public final IllegalArgumentException invalidTimerParameter(String name, String valueAsString) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidTimerParameter$str(), name, valueAsString));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToInvokeTimerServiceDoLifecycle$str() {
        return "WFLYEJB0325: Cannot invoke timer service methods in lifecycle callback of non-singleton beans";
    }

    @Override
    public final IllegalStateException failToInvokeTimerServiceDoLifecycle() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToInvokeTimerServiceDoLifecycle$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerIsNull$str() {
        return "WFLYEJB0326: Timer cannot be null";
    }

    @Override
    public final IllegalStateException timerIsNull() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.timerIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTimerHandlersForPersistentTimers$str() {
        return "WFLYEJB0327: %s Timer handles are only available for persistent timers.";
    }

    @Override
    public final IllegalStateException invalidTimerHandlersForPersistentTimers(String s) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidTimerHandlersForPersistentTimers$str(), s));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMoreTimeoutForTimer$str() {
        return "WFLYEJB0328: No more timeouts for timer %s";
    }

    @Override
    public final NoMoreTimeoutsException noMoreTimeoutForTimer(Timer timer) {
        NoMoreTimeoutsException result = new NoMoreTimeoutsException(String.format(this.getLoggingLocale(), this.noMoreTimeoutForTimer$str(), timer));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTimerNotCalendarBaseTimer$str() {
        return "WFLYEJB0329: Timer %s is not a calendar based timer";
    }

    @Override
    public final IllegalStateException invalidTimerNotCalendarBaseTimer(Timer timer) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidTimerNotCalendarBaseTimer$str(), timer));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerHasExpired$str() {
        return "WFLYEJB0330: Timer %s has expired";
    }

    @Override
    public final NoSuchObjectLocalException timerHasExpired(String id) {
        NoSuchObjectLocalException result = new NoSuchObjectLocalException(String.format(this.getLoggingLocale(), this.timerHasExpired$str(), id));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerWasCanceled$str() {
        return "WFLYEJB0331: Timer %s was canceled";
    }

    @Override
    public final NoSuchObjectLocalException timerWasCanceled(String id) {
        NoSuchObjectLocalException result = new NoSuchObjectLocalException(String.format(this.getLoggingLocale(), this.timerWasCanceled$str(), id));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerServiceWithIdNotRegistered$str() {
        return "WFLYEJB0338: Timerservice with timedObjectId: %s is not registered";
    }

    @Override
    public final EJBException timerServiceWithIdNotRegistered(String timedObjectId) {
        EJBException result = new EJBException(String.format(this.getLoggingLocale(), this.timerServiceWithIdNotRegistered$str(), timedObjectId));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerHandleIsNotActive$str() {
        return "WFLYEJB0339: Timer for handle with timer id: %s, timedObjectId: %s is not active";
    }

    @Override
    public final NoSuchObjectLocalException timerHandleIsNotActive(String timerId, String timedObjectId) {
        NoSuchObjectLocalException result = new NoSuchObjectLocalException(String.format(this.getLoggingLocale(), this.timerHandleIsNotActive$str(), timerId, timedObjectId));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToInvokegetTimeoutMethod$str() {
        return "WFLYEJB0341: Cannot invoke getTimeoutMethod on a timer which is not an auto-timer";
    }

    @Override
    public final IllegalStateException failToInvokegetTimeoutMethod() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failToInvokegetTimeoutMethod$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToLoadDeclaringClassOfTimeOut$str() {
        return "WFLYEJB0342: Could not load declaring class: %s of timeout method";
    }

    @Override
    public final RuntimeException failToLoadDeclaringClassOfTimeOut(String declaringClass) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failToLoadDeclaringClassOfTimeOut$str(), declaringClass));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToInvokeTimeout$str() {
        return "WFLYEJB0343: Cannot invoke timeout method because method %s is not a timeout method";
    }

    @Override
    public final RuntimeException failToInvokeTimeout(Method method) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failToInvokeTimeout$str(), method));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToCreateTimerFileStoreDir$str() {
        return "WFLYEJB0344: Could not create timer file store directory %s";
    }

    @Override
    public final RuntimeException failToCreateTimerFileStoreDir(File baseDir) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failToCreateTimerFileStoreDir$str(), baseDir));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerFileStoreDirNotExist$str() {
        return "WFLYEJB0345: Timer file store directory %s does not exist";
    }

    @Override
    public final RuntimeException timerFileStoreDirNotExist(File baseDir) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.timerFileStoreDirNotExist$str(), baseDir));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTimerFileStoreDir$str() {
        return "WFLYEJB0346: Timer file store directory %s is not a directory";
    }

    @Override
    public final RuntimeException invalidTimerFileStoreDir(File baseDir) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidTimerFileStoreDir$str(), baseDir));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSecurityForDomainSet$str() {
        return "WFLYEJB0347: Jakarta Enterprise Beans %s are enabled for security but doesn't have a security domain set";
    }

    @Override
    public final IllegalStateException invalidSecurityForDomainSet(String componentName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidSecurityForDomainSet$str(), componentName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidComponentConfiguration$str() {
        return "WFLYEJB0348: %s is not an Jakarta Enterprise Beans component";
    }

    @Override
    public final IllegalArgumentException invalidComponentConfiguration(String componentName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidComponentConfiguration$str(), componentName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToLoadViewClassEjb$str() {
        return "WFLYEJB0349: Could not load view class for ejb %s";
    }

    @Override
    public final RuntimeException failToLoadViewClassEjb(String beanName, Throwable e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failToLoadViewClassEjb$str(), beanName), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEjbComponent$str() {
        return "WFLYEJB0350: Component named %s with component class %s is not an Jakarta Enterprise Beans component";
    }

    @Override
    public final IllegalArgumentException invalidEjbComponent(String componentName, Class<?> componentClass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidEjbComponent$str(), componentName, componentClass));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resourceBundleDescriptionsNotSupported$str() {
        return "WFLYEJB0353: ResourceBundle based descriptions of %s are not supported";
    }

    @Override
    public final UnsupportedOperationException resourceBundleDescriptionsNotSupported(String name) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.resourceBundleDescriptionsNotSupported$str(), name));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String runtimeAttributeNotMarshallable$str() {
        return "WFLYEJB0354: Runtime attribute %s is not marshallable";
    }

    @Override
    public final UnsupportedOperationException runtimeAttributeNotMarshallable(String name) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.runtimeAttributeNotMarshallable$str(), name));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidComponentType$str() {
        return "WFLYEJB0356: Jakarta Enterprise Beans component type %s does not support pools";
    }

    @Override
    public final IllegalStateException invalidComponentType(String simpleName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidComponentType$str(), simpleName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownComponentType$str() {
        return "WFLYEJB0357: Unknown Jakarta Enterprise Beans Component type %s";
    }

    @Override
    public final IllegalStateException unknownComponentType(EJBComponentType ejbComponentType) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownComponentType$str(), new Object[]{ejbComponentType}));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ejbMethodSecurityMetaDataIsNull$str() {
        return "WFLYEJB0360: Jakarta Enterprise Beans method security metadata cannot be null";
    }

    @Override
    public final IllegalArgumentException ejbMethodSecurityMetaDataIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.ejbMethodSecurityMetaDataIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String viewClassNameIsNull$str() {
        return "WFLYEJB0361: View classname cannot be null or empty";
    }

    @Override
    public final IllegalArgumentException viewClassNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.viewClassNameIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String viewMethodIsNull$str() {
        return "WFLYEJB0362: View method cannot be null";
    }

    @Override
    public final IllegalArgumentException viewMethodIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.viewMethodIsNull$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failProcessInvocation$str() {
        return "WFLYEJB0363: %s cannot handle method %s of view class %s.Expected view method to be %s on view class %s";
    }

    @Override
    public final IllegalStateException failProcessInvocation(String name, Method invokedMethod, String viewClassOfInvokedMethod, Method viewMethod, String viewClassName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failProcessInvocation$str(), name, invokedMethod, viewClassOfInvokedMethod, viewMethod, viewClassName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invocationOfMethodNotAllowed$str() {
        return "WFLYEJB0364: Invocation on method: %s of bean: %s is not allowed";
    }

    @Override
    public final EJBAccessException invocationOfMethodNotAllowed(Method invokedMethod, String componentName) {
        EJBAccessException result = new EJBAccessException(String.format(this.getLoggingLocale(), this.invocationOfMethodNotAllowed$str(), invokedMethod, componentName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownComponentDescriptionType$str() {
        return "WFLYEJB0365: Unknown Jakarta Enterprise Beans Component description type %s";
    }

    @Override
    public final IllegalArgumentException unknownComponentDescriptionType(Class<?> aClass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownComponentDescriptionType$str(), aClass));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownAttribute$str() {
        return "WFLYEJB0366: Unknown attribute %s";
    }

    @Override
    public final IllegalStateException unknownAttribute(String attributeName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownAttribute$str(), attributeName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownOperations$str() {
        return "WFLYEJB0367: Unknown operation %s";
    }

    @Override
    public final IllegalStateException unknownOperations(String opName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownOperations$str(), opName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noComponentRegisteredForAddress$str() {
        return "WFLYEJB0368: No Jakarta Enterprise Beans component registered for address %s";
    }

    @Override
    public final String noComponentRegisteredForAddress(PathAddress operationAddress) {
        return String.format(this.getLoggingLocale(), this.noComponentRegisteredForAddress$str(), operationAddress);
    }

    protected String noComponentAvailableForAddress$str() {
        return "WFLYEJB0369: No Jakarta Enterprise Beans component is available for address %s";
    }

    @Override
    public final String noComponentAvailableForAddress(PathAddress operationAddress) {
        return String.format(this.getLoggingLocale(), this.noComponentAvailableForAddress$str(), operationAddress);
    }

    protected String invalidComponentState$str() {
        return "WFLYEJB0370: Jakarta Enterprise Beans component for address %s is in %n state %s, must be in state %s";
    }

    @Override
    public final String invalidComponentState(PathAddress operationAddress, ServiceController.State controllerState, ServiceController.State up) {
        return String.format(this.getLoggingLocale(), this.invalidComponentState$str(), operationAddress, controllerState, up);
    }

    protected String componentClassHasMultipleTimeoutAnnotations$str() {
        return "WFLYEJB0372: Component class %s has multiple @Timeout annotations";
    }

    @Override
    public final DeploymentUnitProcessingException componentClassHasMultipleTimeoutAnnotations(Class<?> componentClass) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.componentClassHasMultipleTimeoutAnnotations$str(), componentClass));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String currentComponentNotAEjb$str() {
        return "WFLYEJB0373: Current component is not an Jakarta Enterprise Beans %s";
    }

    @Override
    public final IllegalStateException currentComponentNotAEjb(ComponentInstance component) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.currentComponentNotAEjb$str(), component));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String lifecycleMethodNotAllowed$str() {
        return "WFLYEJB0374: %s not allowed in lifecycle methods";
    }

    @Override
    public final IllegalStateException lifecycleMethodNotAllowed(String methodName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.lifecycleMethodNotAllowed$str(), methodName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCall3$str() {
        return "WFLYEJB0376: Cannot call %s when invoking through %s or %s";
    }

    @Override
    public final IllegalStateException cannotCall(String methodName, String name, String localName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCall3$str(), methodName, name, localName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAllowedFromStatefulBeans$str() {
        return "WFLYEJB0377: %s is not allowed from stateful beans";
    }

    @Override
    public final IllegalStateException notAllowedFromStatefulBeans(String method) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notAllowedFromStatefulBeans$str(), method));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToAcquirePermit$str() {
        return "WFLYEJB0378: Failed to acquire a permit within %s %s";
    }

    @Override
    public final EJBException failedToAcquirePermit(long timeout, TimeUnit timeUnit) {
        EJBException result = new EJBException(String.format(this.getLoggingLocale(), this.failedToAcquirePermit$str(), new Object[]{timeout, timeUnit}));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String acquireSemaphoreInterrupted$str() {
        return "WFLYEJB0379: Acquire semaphore was interrupted";
    }

    @Override
    public final EJBException acquireSemaphoreInterrupted() {
        EJBException result = new EJBException(String.format(this.getLoggingLocale(), this.acquireSemaphoreInterrupted$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotFindClassLoaderForStub$str() {
        return "WFLYEJB0382: Could not determine ClassLoader for stub %s";
    }

    @Override
    public final RuntimeException couldNotFindClassLoaderForStub(String stub) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotFindClassLoaderForStub$str(), stub));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownMessageListenerType$str() {
        return "WFLYEJB0383: No message listener of type %s found in resource adapter %s";
    }

    @Override
    public final IllegalStateException unknownMessageListenerType(String resourceAdapterName, String messageListenerType) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownMessageListenerType$str(), resourceAdapterName, messageListenerType));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotFindViewMethodOnEjb$str() {
        return "WFLYEJB0384: Could not find method %s from view %s on Jakarta Enterprise Beans class %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotFindViewMethodOnEjb(Method method, String viewClass, String ejb) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotFindViewMethodOnEjb$str(), method, viewClass, ejb));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String stringParamCannotBeNullOrEmpty$str() {
        return "WFLYEJB0385: %s cannot be null or empty";
    }

    @Override
    public final IllegalArgumentException stringParamCannotBeNullOrEmpty(String paramName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.stringParamCannotBeNullOrEmpty$str(), paramName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveWhileParticipatingInTransaction$str() {
        return "WFLYEJB0386: Jakarta Enterprise Beans 4.6.4 Cannot remove Jakarta Enterprise Beans via Enterprise Beans 2.x remove() method while participating in a transaction";
    }

    @Override
    public final RemoveException cannotRemoveWhileParticipatingInTransaction() {
        RemoveException result = new RemoveException(String.format(this.getLoggingLocale(), this.cannotRemoveWhileParticipatingInTransaction$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String transactionPropagationNotSupported$str() {
        return "WFLYEJB0387: Transaction propagation over IIOP is not supported";
    }

    @Override
    public final RemoteException transactionPropagationNotSupported() {
        RemoteException result = new RemoteException(String.format(this.getLoggingLocale(), this.transactionPropagationNotSupported$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCallMethodInAfterCompletion$str() {
        return "WFLYEJB0388: Cannot call method %s in afterCompletion callback";
    }

    @Override
    public final IllegalStateException cannotCallMethodInAfterCompletion(String methodName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCallMethodInAfterCompletion$str(), methodName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCallMethod$str() {
        return "WFLYEJB0389: Cannot call %s when state is %s";
    }

    @Override
    public final IllegalStateException cannotCallMethod(String methodName, String state) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCallMethod$str(), methodName, state));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String existingSerializationGroup$str() {
        return "WFLYEJB0390: %s is already associated with serialization group %s";
    }

    @Override
    public final IllegalStateException existingSerializationGroup(Object key, Object group) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.existingSerializationGroup$str(), key, group));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatibleSerializationGroup$str() {
        return "WFLYEJB0391: %s is not compatible with serialization group %s";
    }

    @Override
    public final IllegalStateException incompatibleSerializationGroup(Object object, Object group) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.incompatibleSerializationGroup$str(), object, group));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheEntryInUse$str() {
        return "WFLYEJB0392: Cache entry %s is in use";
    }

    @Override
    public final IllegalStateException cacheEntryInUse(Object entry) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cacheEntryInUse$str(), entry));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheEntryNotInUse$str() {
        return "WFLYEJB0393: Cache entry %s is not in use";
    }

    @Override
    public final IllegalStateException cacheEntryNotInUse(Object entry) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cacheEntryNotInUse$str(), entry));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String lockAcquisitionInterrupted$str() {
        return "WFLYEJB0394: Failed to acquire lock on %s";
    }

    @Override
    public final RuntimeException lockAcquisitionInterrupted(Throwable cause, Object id) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.lockAcquisitionInterrupted$str(), id), cause);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateSerializationGroupMember$str() {
        return "WFLYEJB0395: %s is already a member of serialization group %s";
    }

    @Override
    public final IllegalStateException duplicateSerializationGroupMember(Object id, Object groupId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.duplicateSerializationGroupMember$str(), id, groupId));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingSerializationGroupMember$str() {
        return "WFLYEJB0396: %s is not a member of serialization group %s";
    }

    @Override
    public final IllegalStateException missingSerializationGroupMember(Object id, Object groupId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingSerializationGroupMember$str(), id, groupId));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateCacheEntry$str() {
        return "WFLYEJB0397: %s already exists in cache";
    }

    @Override
    public final IllegalStateException duplicateCacheEntry(Object id) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.duplicateCacheEntry$str(), id));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingCacheEntry$str() {
        return "WFLYEJB0398: %s is missing from cache";
    }

    @Override
    public final IllegalStateException missingCacheEntry(Object id) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingCacheEntry$str(), id));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatibleCaches$str() {
        return "WFLYEJB0399: Incompatible cache implementations in nested hierarchy";
    }

    @Override
    public final IllegalStateException incompatibleCaches() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.incompatibleCaches$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passivationFailed$str() {
        return "WFLYEJB0400: Failed to passivate %s";
    }

    @Override
    public final RuntimeException passivationFailed(Throwable cause, Object id) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.passivationFailed$str(), id), cause);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String activationFailed$str() {
        return "WFLYEJB0401: Failed to activate %s";
    }

    @Override
    public final RuntimeException activationFailed(Throwable cause, Object id) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.activationFailed$str(), id), cause);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passivationDirectoryCreationFailed$str() {
        return "WFLYEJB0402: Failed to create passivation directory: %s";
    }

    @Override
    public final RuntimeException passivationDirectoryCreationFailed(String path) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.passivationDirectoryCreationFailed$str(), path));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passivationPathNotADirectory$str() {
        return "WFLYEJB0403: Failed to create passivation directory: %s";
    }

    @Override
    public final RuntimeException passivationPathNotADirectory(String path) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.passivationPathNotADirectory$str(), path));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String groupCreationContextAlreadyExists$str() {
        return "WFLYEJB0404: Group creation context already exists";
    }

    @Override
    public final IllegalStateException groupCreationContextAlreadyExists() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.groupCreationContextAlreadyExists$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ejbNotFound3$str() {
        return "WFLYEJB0405: No Jakarta Enterprise Beans found with interface of type '%s' and name '%s' for binding %s";
    }

    @Override
    public final String ejbNotFound(String typeName, String beanName, String binding) {
        return String.format(this.getLoggingLocale(), this.ejbNotFound3$str(), typeName, beanName, binding);
    }

    protected String ejbNotFound2$str() {
        return "WFLYEJB0406: No Jakarta Enterprise Beans found with interface of type '%s' for binding %s";
    }

    @Override
    public final String ejbNotFound(String typeName, String binding) {
        return String.format(this.getLoggingLocale(), this.ejbNotFound2$str(), typeName, binding);
    }

    protected String moreThanOneEjbFound4$str() {
        return "WFLYEJB0407: More than one Jakarta Enterprise Beans found with interface of type '%s' and name '%s' for binding %s. Found: %s";
    }

    @Override
    public final String moreThanOneEjbFound(String typeName, String beanName, String binding, Set<EJBViewDescription> componentViews) {
        return String.format(this.getLoggingLocale(), this.moreThanOneEjbFound4$str(), typeName, beanName, binding, componentViews);
    }

    protected String moreThanOneEjbFound3$str() {
        return "WFLYEJB0408: More than one Jakarta Enterprise Beans found with interface of type '%s' for binding %s. Found: %s";
    }

    @Override
    public final String moreThanOneEjbFound(String typeName, String binding, Set<EJBViewDescription> componentViews) {
        return String.format(this.getLoggingLocale(), this.moreThanOneEjbFound3$str(), typeName, binding, componentViews);
    }

    protected String clusteredAnnotationIsNotApplicableForMDB$str() {
        return "WFLYEJB0409: @Clustered annotation cannot be used with message driven beans. %s failed since %s bean is marked with @Clustered on class %s";
    }

    @Override
    public final DeploymentUnitProcessingException clusteredAnnotationIsNotApplicableForMDB(DeploymentUnit unit, String componentName, String componentClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.clusteredAnnotationIsNotApplicableForMDB$str(), unit, componentName, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String clusteredAnnotationIsNotApplicableForEntityBean$str() {
        return "WFLYEJB0410: @Clustered annotation cannot be used with entity beans. %s failed since %s bean is marked with @Clustered on class %s";
    }

    @Override
    public final DeploymentUnitProcessingException clusteredAnnotationIsNotApplicableForEntityBean(DeploymentUnit unit, String componentName, String componentClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.clusteredAnnotationIsNotApplicableForEntityBean$str(), unit, componentName, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String clusteredAnnotationNotYetImplementedForSingletonBean$str() {
        return "WFLYEJB0411: @Clustered annotation is currently not supported for singleton Jakarta Enterprise Beans. %s failed since %s bean is marked with @Clustered on class %s";
    }

    @Override
    public final DeploymentUnitProcessingException clusteredAnnotationNotYetImplementedForSingletonBean(DeploymentUnit unit, String componentName, String componentClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.clusteredAnnotationNotYetImplementedForSingletonBean$str(), unit, componentName, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String clusteredAnnotationIsNotApplicableForBean$str() {
        return "WFLYEJB0412: %s failed since @Clustered annotation cannot be used for %s bean on class %s";
    }

    @Override
    public final DeploymentUnitProcessingException clusteredAnnotationIsNotApplicableForBean(DeploymentUnit unit, String componentName, String componentClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.clusteredAnnotationIsNotApplicableForBean$str(), unit, componentName, componentClassName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sessionTypeNotSpecified$str() {
        return "WFLYEJB0413: <session-type> not specified for Jakarta Enterprise Beans %s. This must be present in ejb-jar.xml";
    }

    @Override
    public final DeploymentUnitProcessingException sessionTypeNotSpecified(String bean) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.sessionTypeNotSpecified$str(), bean));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String defaultInterceptorsNotSpecifyOrder$str() {
        return "WFLYEJB0414: Default interceptors cannot specify an <interceptor-order> element in ejb-jar.xml";
    }

    @Override
    public final DeploymentUnitProcessingException defaultInterceptorsNotSpecifyOrder() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.defaultInterceptorsNotSpecifyOrder$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String paramCannotBeNull$str() {
        return "WFLYEJB0416: %s cannot be null";
    }

    @Override
    public final IllegalArgumentException paramCannotBeNull(String paramName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.paramCannotBeNull$str(), paramName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String poolNameCannotBeEmptyString$str() {
        return "WFLYEJB0419: Pool name cannot be empty string for bean %s";
    }

    @Override
    public final IllegalArgumentException poolNameCannotBeEmptyString(String ejbName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.poolNameCannotBeEmptyString$str(), ejbName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noEjbContextAvailable$str() {
        return "WFLYEJB0420: No EjbContext available as no Jakarta Enterprise Beans invocation is active";
    }

    @Override
    public final IllegalStateException noEjbContextAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noEjbContextAvailable$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentIsShuttingDown$str() {
        return "WFLYEJB0421: Invocation cannot proceed as component is shutting down";
    }

    @Override
    public final EJBComponentUnavailableException componentIsShuttingDown() {
        EJBComponentUnavailableException result = new EJBComponentUnavailableException(String.format(this.getLoggingLocale(), this.componentIsShuttingDown$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String failedToCreateSessionForStatefulBean$str() {
        return "WFLYEJB0423: Could not create session for stateful bean %s";
    }

    @Override
    public final RuntimeException failedToCreateSessionForStatefulBean(Exception e, String beanName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToCreateSessionForStatefulBean$str(), beanName), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownChannelCreationOptionType$str() {
        return "WFLYEJB0436: Unknown channel creation option type %s";
    }

    @Override
    public final IllegalArgumentException unknownChannelCreationOptionType(String optionType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownChannelCreationOptionType$str(), optionType));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotDetermineRemoteInterfaceFromHome$str() {
        return "WFLYEJB0437: Could not determine remote interface from home interface %s for bean %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotDetermineRemoteInterfaceFromHome(String homeClass, String beanName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotDetermineRemoteInterfaceFromHome$str(), homeClass, beanName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotDetermineLocalInterfaceFromLocalHome$str() {
        return "WFLYEJB0438: Could not determine local interface from local home interface %s for bean %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotDetermineLocalInterfaceFromLocalHome(String localHomeClass, String beanName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotDetermineLocalInterfaceFromLocalHome$str(), localHomeClass, beanName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedError$str() {
        return "WFLYEJB0442: Unexpected Error";
    }

    @Override
    public final EJBException unexpectedError(Throwable cause) {
        EJBException result = new EJBException(String.format(this.getLoggingLocale(), this.unexpectedError$str(), new Object[0]));
        result.initCause(cause);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionNotComplete1$str() {
        return "WFLYEJB0443: Enterprise Beans 3.1 FR 13.3.3: BMT bean %s should complete transaction before returning.";
    }

    @Override
    public final String transactionNotComplete(String componentName) {
        return String.format(this.getLoggingLocale(), this.transactionNotComplete1$str(), componentName);
    }

    protected String asymmetricCacheUsage$str() {
        return "WFLYEJB0445: Detected asymmetric usage of cache";
    }

    @Override
    public final IllegalStateException asymmetricCacheUsage() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.asymmetricCacheUsage$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerIsActive$str() {
        return "WFLYEJB0446: The timer %s is already active.";
    }

    @Override
    public final IllegalStateException timerIsActive(Timer timer) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.timerIsActive$str(), timer));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionAlreadyRolledBack$str() {
        return "WFLYEJB0447: Transaction '%s' was already rolled back";
    }

    @Override
    public final RollbackException transactionAlreadyRolledBack(Transaction tx) {
        RollbackException result = new RollbackException(String.format(this.getLoggingLocale(), this.transactionAlreadyRolledBack$str(), tx));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionInUnexpectedState$str() {
        return "WFLYEJB0448: Transaction '%s' is in unexpected state (%s)";
    }

    @Override
    public final EJBException transactionInUnexpectedState(Transaction tx, String txStatus) {
        EJBException result = new EJBException(String.format(this.getLoggingLocale(), this.transactionInUnexpectedState$str(), tx, txStatus));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timerServiceMethodNotAllowedForSFSB$str() {
        return "WFLYEJB0449: Timerservice API is not allowed on stateful session bean %s";
    }

    @Override
    public final String timerServiceMethodNotAllowedForSFSB(String ejbComponent) {
        return String.format(this.getLoggingLocale(), this.timerServiceMethodNotAllowedForSFSB$str(), ejbComponent);
    }

    protected String entityBeansAreNotSupported$str() {
        return "WFLYEJB0450: Entity Beans are no longer supported, beans %s cannot be deployed";
    }

    @Override
    public final DeploymentUnitProcessingException entityBeansAreNotSupported(String beanName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.entityBeansAreNotSupported$str(), beanName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String inconsistentAttributeNotSupported$str() {
        return "WFLYEJB0451: Attribute '%s' is not supported on current version servers; it is only allowed if its value matches '%s'";
    }

    @Override
    public final OperationFailedException inconsistentAttributeNotSupported(String attributeName, String mustMatch) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.inconsistentAttributeNotSupported$str(), attributeName, mustMatch));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToPersistTimer(Timer timerid, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToPersistTimer$str(), (Object)timerid);
    }

    protected String failedToPersistTimer$str() {
        return "WFLYEJB0453: Failed to persist timer %s";
    }

    protected String mustOnlyBeSingleContainerTransactionElementWithWildcard$str() {
        return "WFLYEJB0454: Only one instance on <container-transaction> with an ejb-name of * can be present.";
    }

    @Override
    public final DeploymentUnitProcessingException mustOnlyBeSingleContainerTransactionElementWithWildcard() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.mustOnlyBeSingleContainerTransactionElementWithWildcard$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String wildcardContainerTransactionElementsMustHaveWildcardMethodName$str() {
        return "WFLYEJB0455: <container-transaction> elements that use the wildcard Jakarta Enterprise Beans name * can only use a method name of *";
    }

    @Override
    public final DeploymentUnitProcessingException wildcardContainerTransactionElementsMustHaveWildcardMethodName() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.wildcardContainerTransactionElementsMustHaveWildcardMethodName$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void failedToRefreshTimers(String timedObjectId) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToRefreshTimers$str(), (Object)timedObjectId);
    }

    protected String failedToRefreshTimers$str() {
        return "WFLYEJB0456: Failed to refresh timers for %s";
    }

    protected String unexpectedErrorRolledBack$str() {
        return "WFLYEJB0457: Unexpected Error";
    }

    @Override
    public final EJBTransactionRolledbackException unexpectedErrorRolledBack(Error error) {
        EJBTransactionRolledbackException result = new EJBTransactionRolledbackException(String.format(this.getLoggingLocale(), this.unexpectedErrorRolledBack$str(), new Object[0]));
        result.initCause((Throwable)error);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String relativeResourceAdapterNameInStandaloneModule$str() {
        return "WFLYEJB0459: Module %s containing bean %s is not deployed in ear but it specifies resource adapter name '%s' in a relative format.";
    }

    @Override
    public final DeploymentUnitProcessingException relativeResourceAdapterNameInStandaloneModule(String module, String bean, String adapterName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.relativeResourceAdapterNameInStandaloneModule$str(), module, bean, adapterName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void wrongTransactionIsolationConfiguredForTimer() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.wrongTransactionIsolationConfiguredForTimer$str(), new Object[0]);
    }

    protected String wrongTransactionIsolationConfiguredForTimer$str() {
        return "WFLYEJB0460: The transaction isolation need to be equal or stricter than READ_COMMITTED to ensure that the timer run once-and-only-once";
    }

    @Override
    public final void timerUpdateFailedAndRollbackNotPossible(Throwable rbe) {
        this.log.logf(FQCN, Logger.Level.ERROR, rbe, this.timerUpdateFailedAndRollbackNotPossible$str(), new Object[0]);
    }

    protected String timerUpdateFailedAndRollbackNotPossible$str() {
        return "WFLYEJB0461: Update timer failed and it was not possible to rollback the transaction!";
    }

    @Override
    public final void databaseDialectNotConfiguredOrDetected() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.databaseDialectNotConfiguredOrDetected$str(), new Object[0]);
    }

    protected String databaseDialectNotConfiguredOrDetected$str() {
        return "WFLYEJB0462: Timer service database-data-store database attribute is not configured, and is not detected from connection metadata or JDBC driver name.";
    }

    @Override
    public final void invalidTransactionTypeForSfsbLifecycleMethod(TransactionAttributeType txAttr, MethodIdentifier method, Class<?> clazz) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidTransactionTypeForSfsbLifecycleMethod$str(), (Object)txAttr, (Object)method, clazz);
    }

    protected String invalidTransactionTypeForSfsbLifecycleMethod$str() {
        return "WFLYEJB0463: Invalid transaction attribute type %s on SFSB lifecycle method %s of class %s, valid types are REQUIRES_NEW and NOT_SUPPORTED. Method will be treated as NOT_SUPPORTED.";
    }

    protected String disableDefaultEjbPermissionsCannotBeTrue$str() {
        return "WFLYEJB0464: The \"disable-default-ejb-permissions\" attribute may not be set to true";
    }

    @Override
    public final OperationFailedException disableDefaultEjbPermissionsCannotBeTrue() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.disableDefaultEjbPermissionsCannotBeTrue$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String profileAndRemotingEjbReceiversUsedTogether$str() {
        return "WFLYEJB0465: Invalid client descriptor configuration: 'profile' and 'remoting-ejb-receivers' cannot be used together";
    }

    @Override
    public final DeploymentUnitProcessingException profileAndRemotingEjbReceiversUsedTogether() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.profileAndRemotingEjbReceiversUsedTogether$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToProcessBusinessInterfaces$str() {
        return "WFLYEJB0466: Failed to process business interfaces for Jakarta Enterprise Beans class %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToProcessBusinessInterfaces(Class<?> ejbClass, Exception e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToProcessBusinessInterfaces$str(), ejbClass), (Throwable)e);
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String containerSuspended$str() {
        return "WFLYEJB0467: The request was rejected as the container is suspended";
    }

    @Override
    public final EJBComponentUnavailableException containerSuspended() {
        EJBComponentUnavailableException result = new EJBComponentUnavailableException(String.format(this.getLoggingLocale(), this.containerSuspended$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String timerInvocationFailed$str() {
        return "WFLYEJB0468: Timer invocation failed";
    }

    @Override
    public final OperationFailedException timerInvocationFailed(Exception e) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.timerInvocationFailed$str(), new Object[0]), (Throwable)e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return "WFLYEJB0469: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    }

    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement address) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.indexedChildResourceRegistrationNotAvailable$str(), address));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rmiIiopVoliation$str() {
        return "WFLYEJB0471: RMI/IIOP Violation: %s%n";
    }

    @Override
    public final RuntimeException rmiIiopVoliation(String violation) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.rmiIiopVoliation$str(), violation));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String exceptionRepositoryNotFound$str() {
        return "WFLYEJB0472: Cannot obtain exception repository id for %s:%n%s";
    }

    @Override
    public final RuntimeException exceptionRepositoryNotFound(String name, String message) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.exceptionRepositoryNotFound$str(), name, message));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void jndiBindings(String ejbName, DeploymentUnit deploymentUnit, StringBuilder bindings) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jndiBindings$str(), (Object)ejbName, (Object)deploymentUnit, (Object)bindings);
    }

    protected String jndiBindings$str() {
        return "WFLYEJB0473: JNDI bindings for session bean named '%s' in deployment unit '%s' are as follows:%s";
    }

    @Override
    public final void logInconsistentAttributeNotSupported(String attributeName, String mustMatch) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.logInconsistentAttributeNotSupported$str(), (Object)attributeName, (Object)mustMatch);
    }

    protected String logInconsistentAttributeNotSupported$str() {
        return "WFLYEJB0474: Attribute '%s' is not supported on current version servers; it is only allowed if its value matches '%s'. This attribute should be removed.";
    }

    @Override
    public final void mdbDeliveryStarted(String appName, String componentName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.mdbDeliveryStarted$str(), (Object)appName, (Object)componentName);
    }

    protected String mdbDeliveryStarted$str() {
        return "WFLYEJB0475: MDB delivery started: %s,%s";
    }

    @Override
    public final void mdbDeliveryStopped(String appName, String componentName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.mdbDeliveryStopped$str(), (Object)appName, (Object)componentName);
    }

    protected String mdbDeliveryStopped$str() {
        return "WFLYEJB0476: MDB delivery stopped: %s,%s";
    }

    protected String missingMdbDeliveryGroup$str() {
        return "WFLYEJB0477: MDB delivery group is missing: %s";
    }

    @Override
    public final DeploymentUnitProcessingException missingMdbDeliveryGroup(String deliveryGroupName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.missingMdbDeliveryGroup$str(), deliveryGroupName));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void loadedPersistentTimerInTimeout(String timer, String timedObject) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.loadedPersistentTimerInTimeout$str(), (Object)timer, (Object)timedObject);
    }

    protected String loadedPersistentTimerInTimeout$str() {
        return "WFLYEJB0480: Loaded timer (%s) for Jakarta Enterprise Beans (%s) and this node that is marked as being in a timeout. The original timeout may not have been processed. Please use graceful shutdown to ensure timeout tasks are finished before shutting down.";
    }

    @Override
    public final void strictPoolDerivedFromWorkers(String name, int max) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.strictPoolDerivedFromWorkers$str(), (Object)name, (Object)max);
    }

    protected String strictPoolDerivedFromWorkers$str() {
        return "WFLYEJB0481: Strict pool %s is using a max instance size of %d (per class), which is derived from thread worker pool sizing.";
    }

    @Override
    public final void strictPoolDerivedFromCPUs(String name, int max) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.strictPoolDerivedFromCPUs$str(), (Object)name, (Object)max);
    }

    protected String strictPoolDerivedFromCPUs$str() {
        return "WFLYEJB0482: Strict pool %s is using a max instance size of %d (per class), which is derived from the number of CPUs on this host.";
    }

    protected String mutuallyExclusiveAttributes$str() {
        return "WFLYEJB0483: Attributes are mutually exclusive: %s, %s";
    }

    @Override
    public final XMLStreamException mutuallyExclusiveAttributes(Location location, String attribute1, String attribute2) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.mutuallyExclusiveAttributes$str(), attribute1, attribute2), location);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void invalidTransactionTypeForMDB(TransactionAttributeType transactionAttributeType, String methond, String componentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidTransactionTypeForMDB$str(), (Object)transactionAttributeType, (Object)methond, (Object)componentName);
    }

    protected String invalidTransactionTypeForMDB$str() {
        return "WFLYEJB0485: Transaction type %s is unspecified for the %s method of the %s message-driven bean. It will be handled as NOT_SUPPORTED.";
    }

    @Override
    public final void remappingCacheAttributes(String address, ModelNode defClustered, ModelNode passivationDisabled) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.remappingCacheAttributes$str(), (Object)address, (Object)defClustered, (Object)passivationDisabled);
    }

    protected String remappingCacheAttributes$str() {
        return "WFLYEJB0486: Parameter 'default-clustered-sfsb-cache' was defined for the 'add' operation for resource '%s'. This parameter is deprecated and its previous behavior has been remapped to attribute 'default-sfsb-cache'. As a result the 'default-sfsb-cache' attribute has been set to '%s' and the 'default-sfsb-passivation-disabled-cache' attribute has been set to '%s'.";
    }

    @Override
    public final void unexpectedInvocationState(int state) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unexpectedInvocationState$str(), (Object)state);
    }

    protected String unexpectedInvocationState$str() {
        return "WFLYEJB0487: Unexpected invocation state %s";
    }

    @Override
    public final void timerNotRunning(NotSupportedException e, TimerImpl timer) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.timerNotRunning$str(), (Object)timer);
    }

    protected String timerNotRunning$str() {
        return "WFLYEJB0489: Timer %s not running as transaction could not be started";
    }

    protected String multipleSecurityDomainsDetected$str() {
        return "WFLYEJB0490: Multiple security domains not supported";
    }

    @Override
    public final DeploymentUnitProcessingException multipleSecurityDomainsDetected() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.multipleSecurityDomainsDetected$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotBeginUserTransaction$str() {
        return "WFLYEJB0491: The transaction begin request was rejected as the container is suspended";
    }

    @Override
    public final EJBException cannotBeginUserTransaction() {
        EJBException result = new EJBException(String.format(this.getLoggingLocale(), this.cannotBeginUserTransaction$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void suspensionWaitingActiveTransactions(int activeTransactionCount) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.suspensionWaitingActiveTransactions$str(), (Object)activeTransactionCount);
    }

    protected String suspensionWaitingActiveTransactions$str() {
        return "WFLYEJB0492: Jakarta Enterprise Beans subsystem suspension waiting for active transactions, %d transaction(s) remaining";
    }

    @Override
    public final void suspensionComplete() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.suspensionComplete$str(), new Object[0]);
    }

    protected String suspensionComplete$str() {
        return "WFLYEJB0493: Jakarta Enterprise Beans subsystem suspension complete";
    }

    protected String failedToObtainSSLContext$str() {
        return "WFLYEJB0494: Failed to obtain SSLContext";
    }

    @Override
    public final RuntimeException failedToObtainSSLContext(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToObtainSSLContext$str(), new Object[0]), cause);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void scheduleExpressionDateFromTimerPersistenceInvalid(String timerId, String parserMessage) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.scheduleExpressionDateFromTimerPersistenceInvalid$str(), (Object)timerId, (Object)parserMessage);
    }

    protected String scheduleExpressionDateFromTimerPersistenceInvalid$str() {
        return "WFLYEJB0495: Ignoring the persisted start or end date for scheduled expression of timer ID:%s as it is not valid : %s.";
    }

    protected String failedToCreateEJBClientInterceptor$str() {
        return "WFLYEJB0496: Could not create an instance of Jakarta Enterprise Beans client interceptor %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToCreateEJBClientInterceptor(Exception e, String ejbClientInterceptorClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToCreateEJBClientInterceptor$str(), ejbClientInterceptorClassName), (Throwable)e);
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void failedToPersistTimerOnStartup(TimerImpl activeTimer, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToPersistTimerOnStartup$str(), (Object)activeTimer);
    }

    protected String failedToPersistTimerOnStartup$str() {
        return "WFLYEJB0497: Failed to persist timer %s on startup. This is likely due to another cluster member making the same change, and should not affect operation.";
    }

    protected String cannotReadStrictMaxPoolDerivedSize$str() {
        return "WFLYEJB0499: Cannot read derived size - service %s unreachable";
    }

    @Override
    public final OperationFailedException cannotReadStrictMaxPoolDerivedSize(ServiceName serviceName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotReadStrictMaxPoolDerivedSize$str(), serviceName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void legacySecurityDomainAnnotationIsUsed(String cls) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.legacySecurityDomainAnnotationIsUsed$str(), (Object)cls);
    }

    protected String legacySecurityDomainAnnotationIsUsed$str() {
        return "WFLYEJB0500: Legacy org.jboss.security.annotation.SecurityDomain annotation is used in class: %s, please use org.jboss.ejb3.annotation.SecurityDomain instead.";
    }

    protected String failedToActivateMdb$str() {
        return "WFLYEJB0501: Failed to activate MDB %s";
    }

    @Override
    public final RuntimeException failedToActivateMdb(String componentName, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToActivateMdb$str(), componentName), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void exceptionCheckingIfTimerShouldRun(Timer timer, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.exceptionCheckingIfTimerShouldRun$str(), (Object)timer);
    }

    protected String exceptionCheckingIfTimerShouldRun$str() {
        return "WFLYEJB0502: Exception checking if timer %s should run";
    }

    @Override
    public final void mdbOnMessageMethodCantBeFinal(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mdbOnMessageMethodCantBeFinal$str(), (Object)className);
    }

    protected String mdbOnMessageMethodCantBeFinal$str() {
        return "WFLYEJB0503: [Jakarta Enterprise Beans 3.2 spec, section 5.6.4] Message Driven Bean 'onMessage' method can not be final (MDB: %s).";
    }

    @Override
    public final void mdbOnMessageMethodCantBePrivate(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mdbOnMessageMethodCantBePrivate$str(), (Object)className);
    }

    protected String mdbOnMessageMethodCantBePrivate$str() {
        return "WFLYEJB0504: [Jakarta Enterprise Beans 3.2 spec, section 5.6.4] Message Driven Bean 'onMessage' method can not be private (MDB: %s).";
    }

    @Override
    public final void mdbOnMessageMethodCantBeStatic(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mdbOnMessageMethodCantBeStatic$str(), (Object)className);
    }

    protected String mdbOnMessageMethodCantBeStatic$str() {
        return "WFLYEJB0505: [Jakarta Enterprise Beans 3.2 spec, section 5.6.4] Message Driven Bean 'onMessage' method can not be static (MDB: %s).";
    }

    @Override
    public final void mdbCantHaveFinalizeMethod(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mdbCantHaveFinalizeMethod$str(), (Object)className);
    }

    protected String mdbCantHaveFinalizeMethod$str() {
        return "WFLYEJB0506: [Jakarta Enterprise Beans 3.2 spec, section 5.6.2] Message Driven Bean can not have a 'finalize' method. (MDB: %s)";
    }

    @Override
    public final void exceptionPersistPostTimerState(Timer timer, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.exceptionPersistPostTimerState$str(), (Object)timer);
    }

    protected String exceptionPersistPostTimerState$str() {
        return "WFLYEJB0507: Failed to persist timer's state %s. Timer has to be restored manually";
    }

    @Override
    public final void exceptionPersistTimerState(Timer timer, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.exceptionPersistTimerState$str(), (Object)timer, (Object)e);
    }

    protected String exceptionPersistTimerState$str() {
        return "WFLYEJB0508: Failed to persist timer's state %s due to %s";
    }

    @Override
    public final void clusteredEJBsBoundToINADDRANY(String nodeName, String ip) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.clusteredEJBsBoundToINADDRANY$str(), (Object)nodeName, (Object)ip);
    }

    protected String clusteredEJBsBoundToINADDRANY$str() {
        return "WFLYEJB0509: Clustered Jakarta Enterprise Beans in Node: %s are bound to INADDR_ANY(%s). Either use a non-wildcard server bind address or add client-mapping entries to the relevant socket-binding for the Remoting connector";
    }

    @Override
    public final void missingRunAsAnnotation(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.missingRunAsAnnotation$str(), (Object)className);
    }

    protected String missingRunAsAnnotation$str() {
        return "WFLYEJB0510: @RunAs annotation is required when using @RunAsPrincipal on class %s";
    }

    protected String cannotBuildIndexForServerInterceptor$str() {
        return "WFLYEJB0511: Cannot build reflection index for server interceptor class %s";
    }

    @Override
    public final RuntimeException cannotBuildIndexForServerInterceptor(String interceptorClass, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotBuildIndexForServerInterceptor$str(), interceptorClass), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverInterceptorNoEmptyConstructor$str() {
        return "WFLYEJB0512: Server interceptor class %s does not have a no parameter constructor";
    }

    @Override
    public final RuntimeException serverInterceptorNoEmptyConstructor(String interceptorClass, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.serverInterceptorNoEmptyConstructor$str(), interceptorClass), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverInterceptorInvalidMethod$str() {
        return "WFLYEJB0513: Method %s in server interceptor %s annotated with %s has invalid signature";
    }

    @Override
    public final RuntimeException serverInterceptorInvalidMethod(String methodName, String interceptorClass, String annotationClass, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.serverInterceptorInvalidMethod$str(), methodName, interceptorClass, annotationClass), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotLoadServerInterceptorModule$str() {
        return "WFLYEJB0514: Cannot load server interceptor module %s";
    }

    @Override
    public final RuntimeException cannotLoadServerInterceptorModule(String moduleId, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotLoadServerInterceptorModule$str(), moduleId), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void singletonCantImplementSessionBean(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.singletonCantImplementSessionBean$str(), (Object)className);
    }

    protected String singletonCantImplementSessionBean$str() {
        return "WFLYEJB0515: [Jakarta Enterprise Beans 3.2 spec, section 4.9.2] Singleton session beans are not allowed to implement 'jakarta.ejb.SessionBean' interface. This interface on bean '%s' is going to be ignored and should be removed.";
    }

    @Override
    public final void iiopBindings(String componentName, String moduleName, String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.iiopBindings$str(), (Object)componentName, (Object)moduleName, (Object)name);
    }

    protected String iiopBindings$str() {
        return "WFLYEJB0516: IIOP bindings for session bean named '%s' in deployment unit '%s' are as follows: %s";
    }

    @Override
    public final void typeSpecViolation(String className) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.typeSpecViolation$str(), (Object)className);
    }

    protected String typeSpecViolation$str() {
        return "WFLYEJB0517: [Jakarta Enterprise Beans 3.2 spec, section 4.1] Spec violation for class %s. Session Jakarta Enterprise Beans should have only one of the following types : Stateful, Stateless, Singleton.";
    }

    protected String cannotResolveFilteredClass$str() {
        return "WFLYEJB0518: Exception resolving class %s for unmarshalling; it has either been blocklisted or not allowlisted";
    }

    @Override
    public final InvalidClassException cannotResolveFilteredClass(String clazz) {
        InvalidClassException result = new InvalidClassException(String.format(this.getLoggingLocale(), this.cannotResolveFilteredClass$str(), clazz));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFilterSpec$str() {
        return "WFLYEJB0519: Invalid unmarshalling filter specfication %s; specifications must describe class or package name matching patterns";
    }

    @Override
    public final IllegalArgumentException invalidFilterSpec(String spec) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidFilterSpec$str(), spec));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingClassInAnnotation$str() {
        return "WFLYEJB0521: Some classes referenced by annotation: %s in class: %s are missing.";
    }

    @Override
    public final DeploymentUnitProcessingException missingClassInAnnotation(String anCls, String resCls) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.missingClassInAnnotation$str(), anCls, resCls));
        EjbLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void defaultPoolExpressionCouldNotBeResolved(String defaultPoolName, String defaultPoolValue) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.defaultPoolExpressionCouldNotBeResolved$str(), (Object)defaultPoolName, (Object)defaultPoolValue);
    }

    protected String defaultPoolExpressionCouldNotBeResolved$str() {
        return "WFLYEJB0522: The default pool name %s could not be resolved from its value: %s";
    }

    @Override
    public final void timerNotDeployed(String timer) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.timerNotDeployed$str(), (Object)timer);
    }

    protected String timerNotDeployed$str() {
        return "WFLYEJB0523: Timer %s has not been deployed";
    }

    protected String timerCannotBeAdded$str() {
        return "WFLYEJB0524: Timer %s cannot be added";
    }

    @Override
    public final RuntimeException timerCannotBeAdded(TimerImpl timer) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.timerCannotBeAdded$str(), timer));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void mappedNameNotSupported(String mappedName, String ejb) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mappedNameNotSupported$str(), (Object)mappedName, (Object)ejb);
    }

    protected String mappedNameNotSupported$str() {
        return "WFLYEJB0525: The 'mappedName' in Jakarta Enterprise Beans  annotations is not supported. Value of '%s' for Jakarta Enterprise Beans '%s' will be ignored.";
    }

    protected String timerNotFound$str() {
        return "WFLYEJB0526: Timer %s does not exist";
    }

    @Override
    public final OperationFailedException timerNotFound(String timerId) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.timerNotFound$str(), timerId));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void connectorNotConfiguredForEJBClientInvocations(String address, int port) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.connectorNotConfiguredForEJBClientInvocations$str(), (Object)address, (Object)port);
    }

    protected String connectorNotConfiguredForEJBClientInvocations$str() {
        return "WFLYEJB0527: Remoting connector (address %s, port %s) is not correctly configured for EJB client invocations, the connector must be listed in <remote/> 'connectors' attribute to receive EJB client invocations";
    }

    @Override
    public final void ejbBusinessMethodMustBePublic(Method method) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.ejbBusinessMethodMustBePublic$str(), (Object)method);
    }

    protected String ejbBusinessMethodMustBePublic$str() {
        return "WFLYEJB0528: Jakarta Enterprise Beans business method %s must be public";
    }

    @Override
    public final void failedToRetrieveTimerInfo(TimerImpl timer, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToRetrieveTimerInfo$str(), (Object)timer);
    }

    protected String failedToRetrieveTimerInfo$str() {
        return "WFLYEJB0529: Failed to retrieve info from database for timer: %s";
    }

    protected String legacySecurityUnsupported$str() {
        return "WFLYEJB0530: The deployment is configured to use a legacy security domain '%s' which is no longer supported.";
    }

    @Override
    public final IllegalStateException legacySecurityUnsupported(String domainName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.legacySecurityUnsupported$str(), domainName));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void legacyClientMappingsRegistryProviderInUse(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.legacyClientMappingsRegistryProviderInUse$str(), (Object)name);
    }

    protected String legacyClientMappingsRegistryProviderInUse$str() {
        return "WFLYEJB0531: No client mappings registry provider found for %s; using legacy provider based on static configuration";
    }

    @Override
    public final void unknownDatabaseName(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownDatabaseName$str(), (Object)name);
    }

    protected String unknownDatabaseName$str() {
        return "WFLYEJB0532: Database detected from configuration is: '%s'. If this is incorrect, please specify the correct database.";
    }

    protected String invocationFailed0$str() {
        return "WFLYEJB0533: Invocation failed";
    }

    @Override
    public final RemoteException invocationFailed(Exception e) {
        RemoteException result = new RemoteException(String.format(this.getLoggingLocale(), this.invocationFailed0$str(), new Object[0]), e);
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String authenticationFailed$str() {
        return "WFLYEJB0534: Authentication failed";
    }

    @Override
    public final SecurityException authenticationFailed() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.authenticationFailed$str(), new Object[0]));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String messageEndpointAlreadyReleasedISE$str() {
        return "WFLYEJB0535: Message endpoint %s has already been released";
    }

    @Override
    public final IllegalStateException messageEndpointAlreadyReleasedISE(MessageEndpoint messageEndpoint) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.messageEndpointAlreadyReleasedISE$str(), messageEndpoint));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedEJBReceiverProtocol$str() {
        return "WFLYEJB0536: Unsupported EJB receiver protocol %s";
    }

    @Override
    public final IllegalArgumentException unsupportedEJBReceiverProtocol(String uriScheme) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedEJBReceiverProtocol$str(), uriScheme));
        EjbLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

