/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.OffsetFetcherUtils;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.PartitionStates;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class SubscriptionState {
    private static final String SUBSCRIPTION_EXCEPTION_MESSAGE = "Subscription to topics, partitions and pattern are mutually exclusive";
    private final Logger log;
    private SubscriptionType subscriptionType;
    private Pattern subscribedPattern;
    private Set<String> subscription;
    private Set<String> groupSubscription;
    private final PartitionStates<TopicPartitionState> assignment;
    private final OffsetResetStrategy defaultResetStrategy;
    private Optional<ConsumerRebalanceListener> rebalanceListener;
    private int assignmentId = 0;

    public synchronized String toString() {
        return "SubscriptionState{type=" + (Object)((Object)this.subscriptionType) + ", subscribedPattern=" + this.subscribedPattern + ", subscription=" + String.join((CharSequence)",", this.subscription) + ", groupSubscription=" + String.join((CharSequence)",", this.groupSubscription) + ", defaultResetStrategy=" + (Object)((Object)this.defaultResetStrategy) + ", assignment=" + this.assignment.partitionStateValues() + " (id=" + this.assignmentId + ")}";
    }

    public synchronized String prettyString() {
        switch (this.subscriptionType) {
            case NONE: {
                return "None";
            }
            case AUTO_TOPICS: {
                return "Subscribe(" + String.join((CharSequence)",", this.subscription) + ")";
            }
            case AUTO_PATTERN: {
                return "Subscribe(" + this.subscribedPattern + ")";
            }
            case USER_ASSIGNED: {
                return "Assign(" + this.assignedPartitions() + " , id=" + this.assignmentId + ")";
            }
        }
        throw new IllegalStateException("Unrecognized subscription type: " + (Object)((Object)this.subscriptionType));
    }

    public SubscriptionState(LogContext logContext, OffsetResetStrategy defaultResetStrategy) {
        this.log = logContext.logger(this.getClass());
        this.defaultResetStrategy = defaultResetStrategy;
        this.subscription = new TreeSet<String>();
        this.assignment = new PartitionStates();
        this.groupSubscription = new HashSet<String>();
        this.subscribedPattern = null;
        this.subscriptionType = SubscriptionType.NONE;
    }

    synchronized int assignmentId() {
        return this.assignmentId;
    }

    private void setSubscriptionType(SubscriptionType type) {
        if (this.subscriptionType == SubscriptionType.NONE) {
            this.subscriptionType = type;
        } else if (this.subscriptionType != type) {
            throw new IllegalStateException(SUBSCRIPTION_EXCEPTION_MESSAGE);
        }
    }

    public synchronized boolean subscribe(Set<String> topics, Optional<ConsumerRebalanceListener> listener) {
        this.registerRebalanceListener(listener);
        this.setSubscriptionType(SubscriptionType.AUTO_TOPICS);
        return this.changeSubscription(topics);
    }

    public synchronized void subscribe(Pattern pattern, Optional<ConsumerRebalanceListener> listener) {
        this.registerRebalanceListener(listener);
        this.setSubscriptionType(SubscriptionType.AUTO_PATTERN);
        this.subscribedPattern = pattern;
    }

    public synchronized boolean subscribeFromPattern(Set<String> topics) {
        if (this.subscriptionType != SubscriptionType.AUTO_PATTERN) {
            throw new IllegalArgumentException("Attempt to subscribe from pattern while subscription type set to " + (Object)((Object)this.subscriptionType));
        }
        return this.changeSubscription(topics);
    }

    private boolean changeSubscription(Set<String> topicsToSubscribe) {
        if (this.subscription.equals(topicsToSubscribe)) {
            return false;
        }
        this.subscription = topicsToSubscribe;
        return true;
    }

    synchronized boolean groupSubscribe(Collection<String> topics) {
        if (!this.hasAutoAssignedPartitions()) {
            throw new IllegalStateException(SUBSCRIPTION_EXCEPTION_MESSAGE);
        }
        this.groupSubscription = new HashSet<String>(topics);
        return !this.subscription.containsAll(this.groupSubscription);
    }

    synchronized void resetGroupSubscription() {
        this.groupSubscription = Collections.emptySet();
    }

    public synchronized boolean assignFromUser(Set<TopicPartition> partitions) {
        this.setSubscriptionType(SubscriptionType.USER_ASSIGNED);
        if (this.assignment.partitionSet().equals(partitions)) {
            return false;
        }
        ++this.assignmentId;
        HashSet<String> manualSubscribedTopics = new HashSet<String>();
        HashMap<TopicPartition, TopicPartitionState> partitionToState = new HashMap<TopicPartition, TopicPartitionState>();
        for (TopicPartition partition : partitions) {
            TopicPartitionState state = this.assignment.stateValue(partition);
            if (state == null) {
                state = new TopicPartitionState();
            }
            partitionToState.put(partition, state);
            manualSubscribedTopics.add(partition.topic());
        }
        this.assignment.set(partitionToState);
        return this.changeSubscription(manualSubscribedTopics);
    }

    public synchronized boolean checkAssignmentMatchedSubscription(Collection<TopicPartition> assignments) {
        for (TopicPartition topicPartition : assignments) {
            if (this.subscribedPattern != null) {
                if (this.subscribedPattern.matcher(topicPartition.topic()).matches()) continue;
                this.log.info("Assigned partition {} for non-subscribed topic regex pattern; subscription pattern is {}", (Object)topicPartition, (Object)this.subscribedPattern);
                return false;
            }
            if (this.subscription.contains(topicPartition.topic())) continue;
            this.log.info("Assigned partition {} for non-subscribed topic; subscription is {}", (Object)topicPartition, this.subscription);
            return false;
        }
        return true;
    }

    public synchronized void assignFromSubscribed(Collection<TopicPartition> assignments) {
        if (!this.hasAutoAssignedPartitions()) {
            throw new IllegalArgumentException("Attempt to dynamically assign partitions while manual assignment in use");
        }
        HashMap<TopicPartition, TopicPartitionState> assignedPartitionStates = new HashMap<TopicPartition, TopicPartitionState>(assignments.size());
        for (TopicPartition tp : assignments) {
            TopicPartitionState state = this.assignment.stateValue(tp);
            if (state == null) {
                state = new TopicPartitionState();
            }
            assignedPartitionStates.put(tp, state);
        }
        ++this.assignmentId;
        this.assignment.set(assignedPartitionStates);
    }

    private void registerRebalanceListener(Optional<ConsumerRebalanceListener> listener) {
        this.rebalanceListener = Objects.requireNonNull(listener, "RebalanceListener cannot be null");
    }

    synchronized boolean hasPatternSubscription() {
        return this.subscriptionType == SubscriptionType.AUTO_PATTERN;
    }

    public synchronized boolean hasNoSubscriptionOrUserAssignment() {
        return this.subscriptionType == SubscriptionType.NONE;
    }

    public synchronized void unsubscribe() {
        this.subscription = Collections.emptySet();
        this.groupSubscription = Collections.emptySet();
        this.assignment.clear();
        this.subscribedPattern = null;
        this.subscriptionType = SubscriptionType.NONE;
        ++this.assignmentId;
    }

    synchronized boolean matchesSubscribedPattern(String topic) {
        Pattern pattern = this.subscribedPattern;
        if (this.hasPatternSubscription() && pattern != null) {
            return pattern.matcher(topic).matches();
        }
        return false;
    }

    public synchronized Set<String> subscription() {
        if (this.hasAutoAssignedPartitions()) {
            return this.subscription;
        }
        return Collections.emptySet();
    }

    public synchronized Set<TopicPartition> pausedPartitions() {
        return this.collectPartitions(rec$ -> ((TopicPartitionState)rec$).isPaused());
    }

    synchronized Set<String> metadataTopics() {
        if (this.groupSubscription.isEmpty()) {
            return this.subscription;
        }
        if (this.groupSubscription.containsAll(this.subscription)) {
            return this.groupSubscription;
        }
        HashSet<String> topics = new HashSet<String>(this.groupSubscription);
        topics.addAll(this.subscription);
        return topics;
    }

    synchronized boolean needsMetadata(String topic) {
        return this.subscription.contains(topic) || this.groupSubscription.contains(topic);
    }

    private TopicPartitionState assignedState(TopicPartition tp) {
        TopicPartitionState state = this.assignment.stateValue(tp);
        if (state == null) {
            throw new IllegalStateException("No current assignment for partition " + tp);
        }
        return state;
    }

    private TopicPartitionState assignedStateOrNull(TopicPartition tp) {
        return this.assignment.stateValue(tp);
    }

    public synchronized void seekValidated(TopicPartition tp, FetchPosition position) {
        this.assignedState(tp).seekValidated(position);
    }

    public void seek(TopicPartition tp, long offset) {
        this.seekValidated(tp, new FetchPosition(offset));
    }

    public void seekUnvalidated(TopicPartition tp, FetchPosition position) {
        this.assignedState(tp).seekUnvalidated(position);
    }

    synchronized void maybeSeekUnvalidated(TopicPartition tp, FetchPosition position, OffsetResetStrategy requestedResetStrategy) {
        TopicPartitionState state = this.assignedStateOrNull(tp);
        if (state == null) {
            this.log.debug("Skipping reset of partition {} since it is no longer assigned", (Object)tp);
        } else if (!state.awaitingReset()) {
            this.log.debug("Skipping reset of partition {} since reset is no longer needed", (Object)tp);
        } else if (requestedResetStrategy != state.resetStrategy) {
            this.log.debug("Skipping reset of partition {} since an alternative reset has been requested", (Object)tp);
        } else {
            this.log.info("Resetting offset for partition {} to position {}.", (Object)tp, (Object)position);
            state.seekUnvalidated(position);
        }
    }

    public synchronized Set<TopicPartition> assignedPartitions() {
        return new HashSet<TopicPartition>(this.assignment.partitionSet());
    }

    public synchronized List<TopicPartition> assignedPartitionsList() {
        return new ArrayList<TopicPartition>(this.assignment.partitionSet());
    }

    synchronized int numAssignedPartitions() {
        return this.assignment.size();
    }

    public synchronized List<TopicPartition> fetchablePartitions(Predicate<TopicPartition> isAvailable) {
        ArrayList<TopicPartition> result = new ArrayList<TopicPartition>();
        this.assignment.forEach((topicPartition, topicPartitionState) -> {
            if (((TopicPartitionState)topicPartitionState).isFetchable() && isAvailable.test((TopicPartition)topicPartition)) {
                result.add((TopicPartition)topicPartition);
            }
        });
        return result;
    }

    public synchronized boolean hasAutoAssignedPartitions() {
        return this.subscriptionType == SubscriptionType.AUTO_TOPICS || this.subscriptionType == SubscriptionType.AUTO_PATTERN;
    }

    public synchronized void position(TopicPartition tp, FetchPosition position) {
        this.assignedState(tp).position(position);
    }

    public synchronized boolean maybeValidatePositionForCurrentLeader(ApiVersions apiVersions, TopicPartition tp, Metadata.LeaderAndEpoch leaderAndEpoch) {
        TopicPartitionState state = this.assignedStateOrNull(tp);
        if (state == null) {
            this.log.debug("Skipping validating position for partition {} which is not currently assigned.", (Object)tp);
            return false;
        }
        if (leaderAndEpoch.leader.isPresent()) {
            NodeApiVersions nodeApiVersions = apiVersions.get(leaderAndEpoch.leader.get().idString());
            if (nodeApiVersions == null || OffsetFetcherUtils.hasUsableOffsetForLeaderEpochVersion(nodeApiVersions)) {
                return state.maybeValidatePosition(leaderAndEpoch);
            }
            state.updatePositionLeaderNoValidation(leaderAndEpoch);
            return false;
        }
        return state.maybeValidatePosition(leaderAndEpoch);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized Optional<LogTruncation> maybeCompleteValidation(TopicPartition tp, FetchPosition requestPosition, OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset) {
        TopicPartitionState state = this.assignedStateOrNull(tp);
        if (state == null) {
            this.log.debug("Skipping completed validation for partition {} which is not currently assigned.", (Object)tp);
            return Optional.empty();
        }
        if (!state.awaitingValidation()) {
            this.log.debug("Skipping completed validation for partition {} which is no longer expecting validation.", (Object)tp);
            return Optional.empty();
        }
        FetchPosition currentPosition = state.position;
        if (!currentPosition.equals(requestPosition)) {
            this.log.debug("Skipping completed validation for partition {} since the current position {} no longer matches the position {} when the request was sent", new Object[]{tp, currentPosition, requestPosition});
            return Optional.empty();
        }
        if (epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
            if (this.hasDefaultOffsetResetPolicy()) {
                this.log.info("Truncation detected for partition {} at offset {}, resetting offset", (Object)tp, (Object)currentPosition);
                this.requestOffsetReset(tp);
                return Optional.empty();
            }
            this.log.warn("Truncation detected for partition {} at offset {}, but no reset policy is set", (Object)tp, (Object)currentPosition);
            return Optional.of(new LogTruncation(tp, requestPosition, Optional.empty()));
        }
        if (epochEndOffset.endOffset() >= currentPosition.offset) {
            state.completeValidation();
            return Optional.empty();
        }
        if (this.hasDefaultOffsetResetPolicy()) {
            FetchPosition newPosition = new FetchPosition(epochEndOffset.endOffset(), Optional.of(epochEndOffset.leaderEpoch()), currentPosition.currentLeader);
            this.log.info("Truncation detected for partition {} at offset {}, resetting offset to the first offset known to diverge {}", new Object[]{tp, currentPosition, newPosition});
            state.seekValidated(newPosition);
            return Optional.empty();
        }
        OffsetAndMetadata divergentOffset = new OffsetAndMetadata(epochEndOffset.endOffset(), Optional.of(epochEndOffset.leaderEpoch()), null);
        this.log.warn("Truncation detected for partition {} at offset {} (the end offset from the broker is {}), but no reset policy is set", new Object[]{tp, currentPosition, divergentOffset});
        return Optional.of(new LogTruncation(tp, requestPosition, Optional.of(divergentOffset)));
    }

    public synchronized boolean awaitingValidation(TopicPartition tp) {
        return this.assignedState(tp).awaitingValidation();
    }

    public synchronized void completeValidation(TopicPartition tp) {
        this.assignedState(tp).completeValidation();
    }

    public synchronized FetchPosition validPosition(TopicPartition tp) {
        return this.assignedState(tp).validPosition();
    }

    public synchronized FetchPosition position(TopicPartition tp) {
        return this.assignedState(tp).position;
    }

    public synchronized Long partitionLag(TopicPartition tp, IsolationLevel isolationLevel) {
        TopicPartitionState topicPartitionState = this.assignedState(tp);
        if (topicPartitionState.position == null) {
            return null;
        }
        if (isolationLevel == IsolationLevel.READ_COMMITTED) {
            return topicPartitionState.lastStableOffset == null ? null : Long.valueOf(topicPartitionState.lastStableOffset - ((TopicPartitionState)topicPartitionState).position.offset);
        }
        return topicPartitionState.highWatermark == null ? null : Long.valueOf(topicPartitionState.highWatermark - ((TopicPartitionState)topicPartitionState).position.offset);
    }

    public synchronized Long partitionEndOffset(TopicPartition tp, IsolationLevel isolationLevel) {
        TopicPartitionState topicPartitionState = this.assignedState(tp);
        if (isolationLevel == IsolationLevel.READ_COMMITTED) {
            return topicPartitionState.lastStableOffset;
        }
        return topicPartitionState.highWatermark;
    }

    public synchronized void requestPartitionEndOffset(TopicPartition tp) {
        TopicPartitionState topicPartitionState = this.assignedState(tp);
        topicPartitionState.requestEndOffset();
    }

    public synchronized boolean partitionEndOffsetRequested(TopicPartition tp) {
        TopicPartitionState topicPartitionState = this.assignedState(tp);
        return topicPartitionState.endOffsetRequested();
    }

    synchronized Long partitionLead(TopicPartition tp) {
        TopicPartitionState topicPartitionState = this.assignedState(tp);
        return topicPartitionState.logStartOffset == null ? null : Long.valueOf(((TopicPartitionState)topicPartitionState).position.offset - topicPartitionState.logStartOffset);
    }

    synchronized void updateHighWatermark(TopicPartition tp, long highWatermark) {
        this.assignedState(tp).highWatermark(highWatermark);
    }

    synchronized void updateLogStartOffset(TopicPartition tp, long logStartOffset) {
        this.assignedState(tp).logStartOffset(logStartOffset);
    }

    synchronized void updateLastStableOffset(TopicPartition tp, long lastStableOffset) {
        this.assignedState(tp).lastStableOffset(lastStableOffset);
    }

    public synchronized void updatePreferredReadReplica(TopicPartition tp, int preferredReadReplicaId, LongSupplier timeMs) {
        this.assignedState(tp).updatePreferredReadReplica(preferredReadReplicaId, timeMs);
    }

    public synchronized Optional<Integer> preferredReadReplica(TopicPartition tp, long timeMs) {
        TopicPartitionState topicPartitionState = this.assignedStateOrNull(tp);
        if (topicPartitionState == null) {
            return Optional.empty();
        }
        return topicPartitionState.preferredReadReplica(timeMs);
    }

    public synchronized Optional<Integer> clearPreferredReadReplica(TopicPartition tp) {
        TopicPartitionState topicPartitionState = this.assignedStateOrNull(tp);
        if (topicPartitionState == null) {
            return Optional.empty();
        }
        return topicPartitionState.clearPreferredReadReplica();
    }

    public synchronized Map<TopicPartition, OffsetAndMetadata> allConsumed() {
        HashMap<TopicPartition, OffsetAndMetadata> allConsumed = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.assignment.forEach((topicPartition, partitionState) -> {
            if (((TopicPartitionState)partitionState).hasValidPosition()) {
                allConsumed.put((TopicPartition)topicPartition, new OffsetAndMetadata(((TopicPartitionState)partitionState).position.offset, ((TopicPartitionState)partitionState).position.offsetEpoch, ""));
            }
        });
        return allConsumed;
    }

    public synchronized void requestOffsetReset(TopicPartition partition, OffsetResetStrategy offsetResetStrategy) {
        this.assignedState(partition).reset(offsetResetStrategy);
    }

    public synchronized void requestOffsetReset(Collection<TopicPartition> partitions, OffsetResetStrategy offsetResetStrategy) {
        partitions.forEach(tp -> {
            this.log.info("Seeking to {} offset of partition {}", (Object)offsetResetStrategy, tp);
            this.assignedState((TopicPartition)tp).reset(offsetResetStrategy);
        });
    }

    public void requestOffsetReset(TopicPartition partition) {
        this.requestOffsetReset(partition, this.defaultResetStrategy);
    }

    synchronized void setNextAllowedRetry(Set<TopicPartition> partitions, long nextAllowResetTimeMs) {
        for (TopicPartition partition : partitions) {
            this.assignedState(partition).setNextAllowedRetry(nextAllowResetTimeMs);
        }
    }

    boolean hasDefaultOffsetResetPolicy() {
        return this.defaultResetStrategy != OffsetResetStrategy.NONE;
    }

    public synchronized boolean isOffsetResetNeeded(TopicPartition partition) {
        return this.assignedState(partition).awaitingReset();
    }

    public synchronized OffsetResetStrategy resetStrategy(TopicPartition partition) {
        return this.assignedState(partition).resetStrategy();
    }

    public synchronized boolean hasAllFetchPositions() {
        Iterator<TopicPartitionState> it = this.assignment.stateIterator();
        while (it.hasNext()) {
            if (it.next().hasValidPosition()) continue;
            return false;
        }
        return true;
    }

    public synchronized Set<TopicPartition> initializingPartitions() {
        return this.collectPartitions(state -> ((TopicPartitionState)state).fetchState.equals(FetchStates.INITIALIZING));
    }

    private Set<TopicPartition> collectPartitions(Predicate<TopicPartitionState> filter) {
        HashSet<TopicPartition> result = new HashSet<TopicPartition>();
        this.assignment.forEach((topicPartition, topicPartitionState) -> {
            if (filter.test((TopicPartitionState)topicPartitionState)) {
                result.add((TopicPartition)topicPartition);
            }
        });
        return result;
    }

    public synchronized void resetInitializingPositions() {
        HashSet<TopicPartition> partitionsWithNoOffsets = new HashSet<TopicPartition>();
        this.assignment.forEach((tp, partitionState) -> {
            if (((TopicPartitionState)partitionState).fetchState.equals(FetchStates.INITIALIZING)) {
                if (this.defaultResetStrategy == OffsetResetStrategy.NONE) {
                    partitionsWithNoOffsets.add((TopicPartition)tp);
                } else {
                    this.requestOffsetReset((TopicPartition)tp);
                }
            }
        });
        if (!partitionsWithNoOffsets.isEmpty()) {
            throw new NoOffsetForPartitionException(partitionsWithNoOffsets);
        }
    }

    public synchronized Set<TopicPartition> partitionsNeedingReset(long nowMs) {
        return this.collectPartitions(state -> ((TopicPartitionState)state).awaitingReset() && !((TopicPartitionState)state).awaitingRetryBackoff(nowMs));
    }

    public synchronized Set<TopicPartition> partitionsNeedingValidation(long nowMs) {
        return this.collectPartitions(state -> ((TopicPartitionState)state).awaitingValidation() && !((TopicPartitionState)state).awaitingRetryBackoff(nowMs));
    }

    public synchronized boolean isAssigned(TopicPartition tp) {
        return this.assignment.contains(tp);
    }

    public synchronized boolean isPaused(TopicPartition tp) {
        TopicPartitionState assignedOrNull = this.assignedStateOrNull(tp);
        return assignedOrNull != null && assignedOrNull.isPaused();
    }

    synchronized boolean isFetchable(TopicPartition tp) {
        TopicPartitionState assignedOrNull = this.assignedStateOrNull(tp);
        return assignedOrNull != null && assignedOrNull.isFetchable();
    }

    public synchronized boolean hasValidPosition(TopicPartition tp) {
        TopicPartitionState assignedOrNull = this.assignedStateOrNull(tp);
        return assignedOrNull != null && assignedOrNull.hasValidPosition();
    }

    public synchronized void pause(TopicPartition tp) {
        this.assignedState(tp).pause();
    }

    public synchronized void markPendingRevocation(Set<TopicPartition> tps) {
        tps.forEach(tp -> this.assignedState((TopicPartition)tp).markPendingRevocation());
    }

    public synchronized void resume(TopicPartition tp) {
        this.assignedState(tp).resume();
    }

    synchronized void requestFailed(Set<TopicPartition> partitions, long nextRetryTimeMs) {
        for (TopicPartition partition : partitions) {
            TopicPartitionState state = this.assignedStateOrNull(partition);
            if (state == null) continue;
            state.requestFailed(nextRetryTimeMs);
        }
    }

    synchronized void movePartitionToEnd(TopicPartition tp) {
        this.assignment.moveToEnd(tp);
    }

    public synchronized Optional<ConsumerRebalanceListener> rebalanceListener() {
        return this.rebalanceListener;
    }

    public static class LogTruncation {
        public final TopicPartition topicPartition;
        public final FetchPosition fetchPosition;
        public final Optional<OffsetAndMetadata> divergentOffsetOpt;

        public LogTruncation(TopicPartition topicPartition, FetchPosition fetchPosition, Optional<OffsetAndMetadata> divergentOffsetOpt) {
            this.topicPartition = topicPartition;
            this.fetchPosition = fetchPosition;
            this.divergentOffsetOpt = divergentOffsetOpt;
        }

        public String toString() {
            StringBuilder bldr = new StringBuilder().append("(partition=").append(this.topicPartition).append(", fetchOffset=").append(this.fetchPosition.offset).append(", fetchEpoch=").append(this.fetchPosition.offsetEpoch);
            if (this.divergentOffsetOpt.isPresent()) {
                OffsetAndMetadata divergentOffset = this.divergentOffsetOpt.get();
                bldr.append(", divergentOffset=").append(divergentOffset.offset()).append(", divergentEpoch=").append(divergentOffset.leaderEpoch());
            } else {
                bldr.append(", divergentOffset=unknown").append(", divergentEpoch=unknown");
            }
            return bldr.append(")").toString();
        }
    }

    public static class FetchPosition {
        public final long offset;
        final Optional<Integer> offsetEpoch;
        final Metadata.LeaderAndEpoch currentLeader;

        FetchPosition(long offset) {
            this(offset, Optional.empty(), Metadata.LeaderAndEpoch.noLeaderOrEpoch());
        }

        public FetchPosition(long offset, Optional<Integer> offsetEpoch, Metadata.LeaderAndEpoch currentLeader) {
            this.offset = offset;
            this.offsetEpoch = Objects.requireNonNull(offsetEpoch);
            this.currentLeader = Objects.requireNonNull(currentLeader);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FetchPosition that = (FetchPosition)o;
            return this.offset == that.offset && this.offsetEpoch.equals(that.offsetEpoch) && this.currentLeader.equals(that.currentLeader);
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.offsetEpoch, this.currentLeader);
        }

        public String toString() {
            return "FetchPosition{offset=" + this.offset + ", offsetEpoch=" + this.offsetEpoch + ", currentLeader=" + this.currentLeader + '}';
        }
    }

    static enum FetchStates implements FetchState
    {
        INITIALIZING{

            @Override
            public Collection<FetchState> validTransitions() {
                return Arrays.asList(FETCHING, AWAIT_RESET, AWAIT_VALIDATION);
            }

            @Override
            public boolean requiresPosition() {
                return false;
            }

            @Override
            public boolean hasValidPosition() {
                return false;
            }
        }
        ,
        FETCHING{

            @Override
            public Collection<FetchState> validTransitions() {
                return Arrays.asList(FETCHING, AWAIT_RESET, AWAIT_VALIDATION);
            }

            @Override
            public boolean requiresPosition() {
                return true;
            }

            @Override
            public boolean hasValidPosition() {
                return true;
            }
        }
        ,
        AWAIT_RESET{

            @Override
            public Collection<FetchState> validTransitions() {
                return Arrays.asList(FETCHING, AWAIT_RESET);
            }

            @Override
            public boolean requiresPosition() {
                return false;
            }

            @Override
            public boolean hasValidPosition() {
                return false;
            }
        }
        ,
        AWAIT_VALIDATION{

            @Override
            public Collection<FetchState> validTransitions() {
                return Arrays.asList(FETCHING, AWAIT_RESET, AWAIT_VALIDATION);
            }

            @Override
            public boolean requiresPosition() {
                return true;
            }

            @Override
            public boolean hasValidPosition() {
                return false;
            }
        };

    }

    static interface FetchState {
        default public FetchState transitionTo(FetchState newState) {
            if (this.validTransitions().contains(newState)) {
                return newState;
            }
            return this;
        }

        public Collection<FetchState> validTransitions();

        public boolean requiresPosition();

        public boolean hasValidPosition();
    }

    private static class TopicPartitionState {
        private FetchState fetchState = FetchStates.INITIALIZING;
        private FetchPosition position = null;
        private Long highWatermark = null;
        private Long logStartOffset = null;
        private Long lastStableOffset = null;
        private boolean paused = false;
        private boolean pendingRevocation = false;
        private OffsetResetStrategy resetStrategy = null;
        private Long nextRetryTimeMs = null;
        private Integer preferredReadReplica = null;
        private Long preferredReadReplicaExpireTimeMs;
        private boolean endOffsetRequested = false;

        TopicPartitionState() {
        }

        public boolean endOffsetRequested() {
            return this.endOffsetRequested;
        }

        public void requestEndOffset() {
            this.endOffsetRequested = true;
        }

        private void transitionState(FetchState newState, Runnable runIfTransitioned) {
            FetchState nextState = this.fetchState.transitionTo(newState);
            if (nextState.equals(newState)) {
                this.fetchState = nextState;
                runIfTransitioned.run();
                if (this.position == null && nextState.requiresPosition()) {
                    throw new IllegalStateException("Transitioned subscription state to " + nextState + ", but position is null");
                }
                if (!nextState.requiresPosition()) {
                    this.position = null;
                }
            }
        }

        private Optional<Integer> preferredReadReplica(long timeMs) {
            if (this.preferredReadReplicaExpireTimeMs != null && timeMs > this.preferredReadReplicaExpireTimeMs) {
                this.preferredReadReplica = null;
                return Optional.empty();
            }
            return Optional.ofNullable(this.preferredReadReplica);
        }

        private void updatePreferredReadReplica(int preferredReadReplica, LongSupplier timeMs) {
            if (this.preferredReadReplica == null || preferredReadReplica != this.preferredReadReplica) {
                this.preferredReadReplica = preferredReadReplica;
                this.preferredReadReplicaExpireTimeMs = timeMs.getAsLong();
            }
        }

        private Optional<Integer> clearPreferredReadReplica() {
            if (this.preferredReadReplica != null) {
                int removedReplicaId = this.preferredReadReplica;
                this.preferredReadReplica = null;
                this.preferredReadReplicaExpireTimeMs = null;
                return Optional.of(removedReplicaId);
            }
            return Optional.empty();
        }

        private void reset(OffsetResetStrategy strategy) {
            this.transitionState(FetchStates.AWAIT_RESET, () -> {
                this.resetStrategy = strategy;
                this.nextRetryTimeMs = null;
            });
        }

        private boolean maybeValidatePosition(Metadata.LeaderAndEpoch currentLeaderAndEpoch) {
            if (this.fetchState.equals(FetchStates.AWAIT_RESET)) {
                return false;
            }
            if (!currentLeaderAndEpoch.leader.isPresent()) {
                return false;
            }
            if (this.position != null && !this.position.currentLeader.equals(currentLeaderAndEpoch)) {
                FetchPosition newPosition = new FetchPosition(this.position.offset, this.position.offsetEpoch, currentLeaderAndEpoch);
                this.validatePosition(newPosition);
                this.preferredReadReplica = null;
            }
            return this.fetchState.equals(FetchStates.AWAIT_VALIDATION);
        }

        private void updatePositionLeaderNoValidation(Metadata.LeaderAndEpoch currentLeaderAndEpoch) {
            if (this.position != null) {
                this.transitionState(FetchStates.FETCHING, () -> {
                    this.position = new FetchPosition(this.position.offset, this.position.offsetEpoch, currentLeaderAndEpoch);
                    this.nextRetryTimeMs = null;
                });
            }
        }

        private void validatePosition(FetchPosition position) {
            if (position.offsetEpoch.isPresent() && position.currentLeader.epoch.isPresent()) {
                this.transitionState(FetchStates.AWAIT_VALIDATION, () -> {
                    this.position = position;
                    this.nextRetryTimeMs = null;
                });
            } else {
                this.transitionState(FetchStates.FETCHING, () -> {
                    this.position = position;
                    this.nextRetryTimeMs = null;
                });
            }
        }

        private void completeValidation() {
            if (this.hasPosition()) {
                this.transitionState(FetchStates.FETCHING, () -> {
                    this.nextRetryTimeMs = null;
                });
            }
        }

        private boolean awaitingValidation() {
            return this.fetchState.equals(FetchStates.AWAIT_VALIDATION);
        }

        private boolean awaitingRetryBackoff(long nowMs) {
            return this.nextRetryTimeMs != null && nowMs < this.nextRetryTimeMs;
        }

        private boolean awaitingReset() {
            return this.fetchState.equals(FetchStates.AWAIT_RESET);
        }

        private void setNextAllowedRetry(long nextAllowedRetryTimeMs) {
            this.nextRetryTimeMs = nextAllowedRetryTimeMs;
        }

        private void requestFailed(long nextAllowedRetryTimeMs) {
            this.nextRetryTimeMs = nextAllowedRetryTimeMs;
        }

        private boolean hasValidPosition() {
            return this.fetchState.hasValidPosition();
        }

        private boolean hasPosition() {
            return this.position != null;
        }

        private boolean isPaused() {
            return this.paused;
        }

        private void seekValidated(FetchPosition position) {
            this.transitionState(FetchStates.FETCHING, () -> {
                this.position = position;
                this.resetStrategy = null;
                this.nextRetryTimeMs = null;
            });
        }

        private void seekUnvalidated(FetchPosition fetchPosition) {
            this.seekValidated(fetchPosition);
            this.validatePosition(fetchPosition);
        }

        private void position(FetchPosition position) {
            if (!this.hasValidPosition()) {
                throw new IllegalStateException("Cannot set a new position without a valid current position");
            }
            this.position = position;
        }

        private FetchPosition validPosition() {
            if (this.hasValidPosition()) {
                return this.position;
            }
            return null;
        }

        private void pause() {
            this.paused = true;
        }

        private void markPendingRevocation() {
            this.pendingRevocation = true;
        }

        private void resume() {
            this.paused = false;
        }

        private boolean isFetchable() {
            return !this.paused && !this.pendingRevocation && this.hasValidPosition();
        }

        private void highWatermark(Long highWatermark) {
            this.highWatermark = highWatermark;
            this.endOffsetRequested = false;
        }

        private void logStartOffset(Long logStartOffset) {
            this.logStartOffset = logStartOffset;
        }

        private void lastStableOffset(Long lastStableOffset) {
            this.lastStableOffset = lastStableOffset;
            this.endOffsetRequested = false;
        }

        private OffsetResetStrategy resetStrategy() {
            return this.resetStrategy;
        }
    }

    private static enum SubscriptionType {
        NONE,
        AUTO_TOPICS,
        AUTO_PATTERN,
        USER_ASSIGNED;

    }
}

