/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.naming;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;

public class BinderServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator {
    private final ContextNames.BindInfo binding;
    private final ServiceName targetServiceName;
    private final List<ContextNames.BindInfo> aliases = new LinkedList<ContextNames.BindInfo>();
    private volatile boolean enabled = true;

    public BinderServiceConfigurator(ContextNames.BindInfo binding, ServiceName targetServiceName) {
        super(binding.getBinderServiceName());
        this.binding = binding;
        this.targetServiceName = targetServiceName;
    }

    public BinderServiceConfigurator alias(ContextNames.BindInfo alias) {
        this.aliases.add(alias);
        return this;
    }

    @Override
    public ServiceConfigurator configure(OperationContext context) {
        this.enabled = context.getCapabilityServiceSupport().hasCapability(CommonRequirement.NAMING_STORE.getName());
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        if (!this.enabled) {
            return target.addService(this.getServiceName()).setInitialMode(ServiceController.Mode.NEVER);
        }
        String name = this.binding.getBindName();
        BinderService binder = new BinderService(name);
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{name})}).addDependency(this.targetServiceName, Object.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(this.binding.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector());
        for (ContextNames.BindInfo alias : this.aliases) {
            builder.addAliases(new ServiceName[]{alias.getBinderServiceName(), ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{alias.getBindName()})});
        }
        return builder.setInitialMode(ServiceController.Mode.PASSIVE);
    }
}

