/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.IncomingKafkaCloudEventMetadata;
import io.smallrye.reactive.messaging.kafka.KafkaRecord;
import io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.impl.ce.KafkaCloudEventHelper;
import io.smallrye.reactive.messaging.providers.MetadataInjectableMessage;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class IncomingKafkaRecord<K, T>
implements KafkaRecord<K, T>,
MetadataInjectableMessage<T> {
    private Metadata metadata;
    private final IncomingKafkaRecordMetadata<K, T> kafkaMetadata;
    private final KafkaCommitHandler commitHandler;
    private final KafkaFailureHandler onNack;
    private final T payload;

    public IncomingKafkaRecord(ConsumerRecord<K, T> record, String channel, int index, KafkaCommitHandler commitHandler, KafkaFailureHandler onNack, boolean cloudEventEnabled, boolean tracingEnabled) {
        this.commitHandler = commitHandler;
        this.kafkaMetadata = new IncomingKafkaRecordMetadata(record, channel, index);
        ArrayList<Object> meta = new ArrayList<Object>();
        meta.add(this.kafkaMetadata);
        Object payload = null;
        boolean payloadSet = false;
        if (cloudEventEnabled) {
            KafkaCloudEventHelper.CloudEventMode mode = KafkaCloudEventHelper.getCloudEventMode(record);
            switch (mode) {
                case NOT_A_CLOUD_EVENT: {
                    break;
                }
                case STRUCTURED: {
                    IncomingKafkaCloudEventMetadata<K, T> event = KafkaCloudEventHelper.createFromStructuredCloudEvent(record);
                    meta.add(event);
                    payloadSet = true;
                    payload = event.getData();
                    break;
                }
                case BINARY: {
                    meta.add(KafkaCloudEventHelper.createFromBinaryCloudEvent(record));
                }
            }
        }
        this.metadata = ContextAwareMessage.captureContextMetadata(meta);
        this.onNack = onNack;
        this.payload = payload == null && !payloadSet ? record.value() : payload;
    }

    public T getPayload() {
        return this.payload;
    }

    @Override
    public K getKey() {
        return (K)this.kafkaMetadata.getKey();
    }

    @Override
    public String getTopic() {
        return this.kafkaMetadata.getTopic();
    }

    @Override
    public int getPartition() {
        return this.kafkaMetadata.getPartition();
    }

    @Override
    public Instant getTimestamp() {
        return this.kafkaMetadata.getTimestamp();
    }

    @Override
    public Headers getHeaders() {
        return this.kafkaMetadata.getHeaders();
    }

    public long getOffset() {
        return this.kafkaMetadata.getOffset();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Function<Metadata, CompletionStage<Void>> getAckWithMetadata() {
        return this::ack;
    }

    public BiFunction<Throwable, Metadata, CompletionStage<Void>> getNackWithMetadata() {
        return this::nack;
    }

    public CompletionStage<Void> ack(Metadata metadata) {
        return this.commitHandler.handle(this).subscribeAsCompletionStage();
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return this.onNack.handle(this, reason, metadata).subscribeAsCompletionStage();
    }

    public synchronized void injectMetadata(Object metadata) {
        this.metadata = this.metadata.with(metadata);
    }
}

