/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.ResetConnectorStatisticsHandler;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowListener;
import org.xnio.Option;
import org.xnio.Options;

abstract class ListenerResourceDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> LISTENER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.listener", (boolean)true, UndertowListener.class).setAllowMultipleRegistrations(true).build();
    static final RuntimeCapability<Void> HTTP_UPGRADE_REGISTRY_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.listener.http-upgrade-registry", (boolean)true, ChannelUpgradeHandler.class).setAllowMultipleRegistrations(true).build();
    static final SimpleAttributeDefinition SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setCapabilityReference("org.wildfly.network.socket-binding", LISTENER_CAPABILITY)).build();
    static final SimpleAttributeDefinition WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setDefaultValue(new ModelNode("default"))).setCapabilityReference("org.wildfly.io.worker", LISTENER_CAPABILITY)).build();
    static final SimpleAttributeDefinition BUFFER_POOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("buffer-pool", ModelType.STRING).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setDefaultValue(new ModelNode("default"))).setCapabilityReference("org.wildfly.undertow.byte-buffer-pool", LISTENER_CAPABILITY)).build();
    static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN).setRequired(false)).setDeprecated(ModelVersion.create((int)3, (int)2))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition REDIRECT_SOCKET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("redirect-socket", ModelType.STRING).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAllowExpression(false)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setCapabilityReference("org.wildfly.network.socket-binding", LISTENER_CAPABILITY)).build();
    static final SimpleAttributeDefinition RESOLVE_PEER_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resolve-peer-address", ModelType.BOOLEAN).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    static final StringListAttributeDefinition DISALLOWED_METHODS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("disallowed-methods").setDefaultValue(new ModelNode().add("TRACE"))).setRequired(false)).setValidator((ParameterValidator)new StringLengthValidator(0))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition SECURE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secure", ModelType.BOOLEAN).setDefaultValue(ModelNode.FALSE)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAllowExpression(true)).build();
    static final OptionAttributeDefinition BACKLOG = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"tcp-backlog", (Option)Options.BACKLOG).setDefaultValue(new ModelNode(10000))).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    static final OptionAttributeDefinition RECEIVE_BUFFER = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"receive-buffer", (Option)Options.RECEIVE_BUFFER).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    static final OptionAttributeDefinition SEND_BUFFER = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"send-buffer", (Option)Options.SEND_BUFFER).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    static final OptionAttributeDefinition KEEP_ALIVE = ((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"tcp-keep-alive", (Option)Options.KEEP_ALIVE).setAllowExpression(true)).build();
    static final OptionAttributeDefinition READ_TIMEOUT = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"read-timeout", (Option)Options.READ_TIMEOUT).setDefaultValue(new ModelNode(90000))).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).build();
    static final OptionAttributeDefinition WRITE_TIMEOUT = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"write-timeout", (Option)Options.WRITE_TIMEOUT).setDefaultValue(new ModelNode(90000))).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).build();
    static final OptionAttributeDefinition MAX_CONNECTIONS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"max-connections", (Option)Options.CONNECTION_HIGH_WATER).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).build();
    static final OptionAttributeDefinition MAX_HEADER_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"max-header-size", (Option)UndertowOptions.MAX_HEADER_SIZE).setDefaultValue(new ModelNode(0x100000))).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    static final OptionAttributeDefinition MAX_ENTITY_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"max-post-size", (Option)UndertowOptions.MAX_ENTITY_SIZE).setDefaultValue(new ModelNode(0xA00000L))).setValidator((ParameterValidator)new LongRangeValidator(0L))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition BUFFER_PIPELINED_DATA = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"buffer-pipelined-data", (Option)UndertowOptions.BUFFER_PIPELINED_DATA).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition MAX_PARAMETERS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"max-parameters", (Option)UndertowOptions.MAX_PARAMETERS).setDefaultValue(new ModelNode(1000))).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).build();
    static final OptionAttributeDefinition MAX_HEADERS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"max-headers", (Option)UndertowOptions.MAX_HEADERS).setDefaultValue(new ModelNode(200))).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).build();
    static final OptionAttributeDefinition MAX_COOKIES = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"max-cookies", (Option)UndertowOptions.MAX_COOKIES).setDefaultValue(new ModelNode(200))).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).build();
    static final OptionAttributeDefinition ALLOW_ENCODED_SLASH = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"allow-encoded-slash", (Option)UndertowOptions.ALLOW_ENCODED_SLASH).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition DECODE_URL = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"decode-url", (Option)UndertowOptions.DECODE_URL).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition URL_CHARSET = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"url-charset", (Option)UndertowOptions.URL_CHARSET).setDefaultValue(new ModelNode("UTF-8"))).setAllowExpression(true)).build();
    static final OptionAttributeDefinition ALWAYS_SET_KEEP_ALIVE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"always-set-keep-alive", (Option)UndertowOptions.ALWAYS_SET_KEEP_ALIVE).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition MAX_BUFFERED_REQUEST_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"max-buffered-request-size", (Option)UndertowOptions.MAX_BUFFERED_REQUEST_SIZE).setDefaultValue(new ModelNode(16384))).setValidator((ParameterValidator)new IntRangeValidator(1))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition RECORD_REQUEST_START_TIME = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"record-request-start-time", (Option)UndertowOptions.RECORD_REQUEST_START_TIME).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition ALLOW_EQUALS_IN_COOKIE_VALUE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"allow-equals-in-cookie-value", (Option)UndertowOptions.ALLOW_EQUALS_IN_COOKIE_VALUE).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition NO_REQUEST_TIMEOUT = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"no-request-timeout", (Option)UndertowOptions.NO_REQUEST_TIMEOUT).setDefaultValue(new ModelNode(60000))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition REQUEST_PARSE_TIMEOUT = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"request-parse-timeout", (Option)UndertowOptions.REQUEST_PARSE_TIMEOUT).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition RFC6265_COOKIE_VALIDATION = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"rfc6265-cookie-validation", (Option)UndertowOptions.ENABLE_RFC6265_COOKIE_VALIDATION).setDefaultValue(ModelNode.FALSE)).setRequired(false)).setAllowExpression(true)).build();
    static final OptionAttributeDefinition ALLOW_UNESCAPED_CHARACTERS_IN_URL = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"allow-unescaped-characters-in-url", (Option)UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL).setDefaultValue(ModelNode.FALSE)).setRequired(false)).setAllowExpression(true)).build();
    static final Collection<OptionAttributeDefinition> LISTENER_OPTIONS = List.of(MAX_HEADER_SIZE, MAX_ENTITY_SIZE, BUFFER_PIPELINED_DATA, MAX_PARAMETERS, MAX_HEADERS, MAX_COOKIES, ALLOW_ENCODED_SLASH, DECODE_URL, URL_CHARSET, ALWAYS_SET_KEEP_ALIVE, MAX_BUFFERED_REQUEST_SIZE, RECORD_REQUEST_START_TIME, ALLOW_EQUALS_IN_COOKIE_VALUE, NO_REQUEST_TIMEOUT, REQUEST_PARSE_TIMEOUT, RFC6265_COOKIE_VALIDATION, ALLOW_UNESCAPED_CHARACTERS_IN_URL);
    static final Collection<OptionAttributeDefinition> SOCKET_OPTIONS = List.of(BACKLOG, RECEIVE_BUFFER, SEND_BUFFER, KEEP_ALIVE, READ_TIMEOUT, WRITE_TIMEOUT, MAX_CONNECTIONS);
    private static final Collection<AttributeDefinition> SIMPLE_ATTRIBUTES = List.of(SOCKET_BINDING, WORKER, BUFFER_POOL, ENABLED, RESOLVE_PEER_ADDRESS, DISALLOWED_METHODS, SECURE);
    static final Collection<AttributeDefinition> ATTRIBUTES = ListenerResourceDefinition.collectAttributes();
    private final Function<Collection<AttributeDefinition>, AbstractAddStepHandler> addHandlerFactory;
    private final Map<AttributeDefinition, OperationStepHandler> writeAttributeHandlers;

    private static Collection<AttributeDefinition> collectAttributes() {
        ArrayList<Object> attributes = new ArrayList<Object>(SIMPLE_ATTRIBUTES.size() + LISTENER_OPTIONS.size() + SOCKET_OPTIONS.size());
        attributes.addAll(SIMPLE_ATTRIBUTES);
        attributes.addAll(LISTENER_OPTIONS);
        attributes.addAll(SOCKET_OPTIONS);
        return Collections.unmodifiableCollection(attributes);
    }

    public ListenerResourceDefinition(SimpleResourceDefinition.Parameters parameters, Function<Collection<AttributeDefinition>, AbstractAddStepHandler> addHandlerFactory, Map<AttributeDefinition, OperationStepHandler> writeAttributeHandlers) {
        super(parameters.setDescriptionResolver((ResourceDescriptionResolver)UndertowExtension.getResolver("listener")).addCapabilities(new RuntimeCapability[]{LISTENER_CAPABILITY}));
        this.addHandlerFactory = addHandlerFactory;
        this.writeAttributeHandlers = new HashMap<AttributeDefinition, OperationStepHandler>();
        this.writeAttributeHandlers.putAll(writeAttributeHandlers);
        this.writeAttributeHandlers.put((AttributeDefinition)ENABLED, (OperationStepHandler)new EnabledAttributeHandler());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        AbstractAddStepHandler addHandler = this.addHandlerFactory.apply(this.getAttributes());
        super.registerAddOperation(resourceRegistration, addHandler, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_NONE});
        super.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)new ServiceRemoveStepHandler(addHandler), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_NONE});
        resourceRegistration.registerOperationHandler(ResetConnectorStatisticsHandler.DEFINITION, (OperationStepHandler)ResetConnectorStatisticsHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        Collection attributes = this.getAttributes();
        ReloadRequiredWriteAttributeHandler defaultWriteAttributeHandler = new ReloadRequiredWriteAttributeHandler(attributes);
        for (AttributeDefinition attribute : attributes) {
            OperationStepHandler writeAttributeHandler = this.writeAttributeHandlers.getOrDefault(attribute, (OperationStepHandler)defaultWriteAttributeHandler);
            resourceRegistration.registerReadWriteAttribute(attribute, null, writeAttributeHandler);
        }
        for (ConnectorStat attr : ConnectorStat.values()) {
            resourceRegistration.registerMetric(attr.definition, (OperationStepHandler)ReadStatisticHandler.INSTANCE);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return List.of(new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("undertow", "web-connector", false, false, false)));
    }

    static ListenerService getListenerService(OperationContext context) {
        String name = context.getCurrentAddressValue();
        ServiceName serviceName = LISTENER_CAPABILITY.getCapabilityServiceName(new String[]{name});
        ServiceController listenerSC = context.getServiceRegistry(false).getService(serviceName);
        if (listenerSC == null || listenerSC.getState() != ServiceController.State.UP) {
            return null;
        }
        return (ListenerService)listenerSC.getValue();
    }

    private static class EnabledAttributeHandler
    extends AbstractWriteAttributeHandler<Boolean> {
        protected EnabledAttributeHandler() {
            super(new AttributeDefinition[]{ENABLED});
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
            boolean enabled = resolvedValue.asBoolean();
            ListenerService listenerService = ListenerResourceDefinition.getListenerService(context);
            if (listenerService != null) {
                boolean currentEnabled = listenerService.isEnabled();
                handbackHolder.setHandback((Object)currentEnabled);
                listenerService.setEnabled(enabled);
            }
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
            ListenerService listenerService;
            if (handback != null && (listenerService = ListenerResourceDefinition.getListenerService(context)) != null) {
                listenerService.setEnabled(handback);
            }
        }
    }

    public static enum ConnectorStat {
        REQUEST_COUNT((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-count", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).setStorageRuntime()).build()),
        BYTES_SENT((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("bytes-sent", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.BYTES)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).setStorageRuntime()).build()),
        BYTES_RECEIVED((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("bytes-received", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.BYTES)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).setStorageRuntime()).build()),
        ERROR_COUNT((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("error-count", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).setStorageRuntime()).build()),
        PROCESSING_TIME((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("processing-time", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.NANOSECONDS)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).setStorageRuntime()).build()),
        MAX_PROCESSING_TIME((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-processing-time", ModelType.LONG).setMeasurementUnit(MeasurementUnit.NANOSECONDS)).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build());

        private static final Map<String, ConnectorStat> MAP;
        final AttributeDefinition definition;

        private ConnectorStat(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static synchronized ConnectorStat getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, ConnectorStat>();
            for (ConnectorStat stat : EnumSet.allOf(ConnectorStat.class)) {
                MAP.put(stat.toString(), stat);
            }
        }
    }

    private static class ReadStatisticHandler
    implements OperationStepHandler {
        public static final ReadStatisticHandler INSTANCE = new ReadStatisticHandler();

        private ReadStatisticHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ListenerService service = ListenerResourceDefinition.getListenerService(context);
            if (service == null) {
                return;
            }
            String op = operation.get("name").asString();
            ConnectorStatistics stats = service.getOpenListener().getConnectorStatistics();
            if (stats != null) {
                ConnectorStat element = ConnectorStat.getStat(op);
                switch (element) {
                    case BYTES_RECEIVED: {
                        context.getResult().set(stats.getBytesReceived());
                        break;
                    }
                    case BYTES_SENT: {
                        context.getResult().set(stats.getBytesSent());
                        break;
                    }
                    case ERROR_COUNT: {
                        context.getResult().set(stats.getErrorCount());
                        break;
                    }
                    case MAX_PROCESSING_TIME: {
                        context.getResult().set(stats.getMaxProcessingTime());
                        break;
                    }
                    case PROCESSING_TIME: {
                        context.getResult().set(stats.getProcessingTime());
                        break;
                    }
                    case REQUEST_COUNT: {
                        context.getResult().set(stats.getRequestCount());
                    }
                }
            }
        }
    }
}

